/****************************************************************************
 * boards/arm/lpc17xx_40xx/pnev5180b/scripts/memory.ld
 *
 *   Copyright (C) 2019 Gregory Nutt. All rights reserved.
 *   Author: Michael Jung <mijung@gmx.net>
 *
 * Based on boards/open1788/scripts/memory.ld
 *
 *   Copyright (C) 2013 Gregory Nutt. All rights reserved.
 *   Author: Gregory Nutt <gnutt@nuttx.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name NuttX nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* The LPC1769 has 512Kb of FLASH beginning at address 0x0000:0000 and
 * 64Kb of total SRAM: 32Kb of SRAM in the CPU block beginning at address
 * 0x10000000 and 32Kb of AHB SRAM in two banks of 16Kb beginning at addresses
 * 0x20070000 and 0x20080000.  Here we assume that .data and .bss will all fit
 * into the 32Kb CPU SRAM address range.
 */

MEMORY
{
  /* 512Kb FLASH - Leave 256Kb for application usage */

  kflash (rx)      : ORIGIN = 0x00000000, LENGTH = 128K
  uflash (rx)      : ORIGIN = 0x00020000, LENGTH = 128K

  /* 32Kb of SRAM in the CPU block - Leave 32Kb of AHB SRAM for app usage */

  ksram (rwx)      : ORIGIN = 0x10000000, LENGTH = 16K
  usram (rwx)      : ORIGIN = 0x10004000, LENGTH = 16K
}
