/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Date;
import java.util.List;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class GroupUserDao
implements IDataProviderDao<GroupUser> {
    private static final List<String> searchFields = List.of("user.lastname", "user.firstname", "user.login", "user.address.email");
    private static final String PARAM_GROUPID = "groupId";
    @PersistenceContext
    private EntityManager em;

    @Override
    public GroupUser get(Long id) {
        return (GroupUser)this.em.createNamedQuery("getGroupUsersById", GroupUser.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<GroupUser> get(long start, long count) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public List<GroupUser> get(String search, long start, long count, SortParam<String> sort) {
        throw DaoHelper.UNSUPPORTED;
    }

    private Predicate getGroupFilter(Long groupId, CriteriaBuilder builder, CriteriaQuery<?> query) {
        Root<GroupUser> root = DaoHelper.getRoot(query, GroupUser.class);
        return builder.equal((Expression)root.get("group").get("id"), (Object)groupId);
    }

    public List<GroupUser> get(long groupId, String search, long start, long count, SortParam<String> sort) {
        return DaoHelper.get(this.em, GroupUser.class, false, search, searchFields, false, (builder, query) -> this.getGroupFilter(groupId, (CriteriaBuilder)builder, (CriteriaQuery<?>)query), sort, start, count);
    }

    public List<GroupUser> get(long groupId, long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getGroupUsersByGroupId", GroupUser.class).setParameter("id", (Object)groupId), start, count).getResultList();
    }

    public GroupUser getByGroupAndUser(Long groupId, Long userId) {
        return (GroupUser)DaoHelper.single(this.em.createNamedQuery("isUserInGroup", GroupUser.class).setParameter(PARAM_GROUPID, (Object)groupId).setParameter("userId", (Object)userId).getResultList());
    }

    public boolean isUserInGroup(long groupId, long userId) {
        return !this.em.createNamedQuery("isUserInGroup", GroupUser.class).setParameter(PARAM_GROUPID, (Object)groupId).setParameter("userId", (Object)userId).getResultList().isEmpty();
    }

    @Override
    public long count() {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public long count(String search) {
        return DaoHelper.count(this.em, GroupUser.class, search, searchFields, false, null);
    }

    public long count(long groupId) {
        return (Long)this.em.createNamedQuery("countGroupUsers", Long.class).setParameter("id", (Object)groupId).getSingleResult();
    }

    @Override
    public GroupUser update(GroupUser entity, Long userId) {
        throw DaoHelper.UNSUPPORTED;
    }

    @Override
    public void delete(GroupUser entity, Long userId) {
        throw DaoHelper.UNSUPPORTED;
    }

    public long getGroupUserCountAddedAfter(Long id, Date date) {
        return (Long)this.em.createNamedQuery("getGroupUserCountAddedAfter", Long.class).setParameter("id", (Object)id).setParameter("inserted", (Object)date).getSingleResult();
    }

    public List<User> getGroupModerators(Long id) {
        return this.em.createNamedQuery("getGroupModerators", User.class).setParameter("id", (Object)id).getResultList();
    }
}

