/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.Date;
import org.asteriskjava.live.AsteriskQueueEntry;
import org.asteriskjava.live.QueueEntryState;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskQueueImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.lock.Locker;

class AsteriskQueueEntryImpl
extends AbstractLiveObject
implements AsteriskQueueEntry {
    private final AsteriskQueueImpl queue;
    private final AsteriskChannelImpl channel;
    private final Date dateJoined;
    private Date dateLeft;
    private QueueEntryState state;
    private int reportedPosition;
    private int position = -1;

    AsteriskQueueEntryImpl(AsteriskServerImpl server, AsteriskQueueImpl queue, AsteriskChannelImpl channel, int reportedPosition, Date dateJoined) {
        super(server);
        this.queue = queue;
        this.channel = channel;
        this.dateJoined = dateJoined;
        this.state = QueueEntryState.JOINED;
        this.reportedPosition = reportedPosition;
    }

    @Override
    public String getChannelName() {
        return this.channel.getName();
    }

    @Override
    public AsteriskQueueImpl getQueue() {
        return this.queue;
    }

    @Override
    public AsteriskChannelImpl getChannel() {
        return this.channel;
    }

    @Override
    public Date getDateJoined() {
        return this.dateJoined;
    }

    @Override
    public Date getDateLeft() {
        return this.dateLeft;
    }

    void left(Date dateLeft) {
        QueueEntryState oldState;
        try (Locker.LockCloser closer = this.withLock();){
            oldState = this.state;
            this.dateLeft = dateLeft;
            this.state = QueueEntryState.LEFT;
        }
        this.firePropertyChange("state", (Object)oldState, (Object)this.state);
    }

    @Override
    public QueueEntryState getState() {
        return this.state;
    }

    public int getReportedPosition() {
        return this.reportedPosition;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    void setPosition(int position) {
        int oldPosition = this.position;
        this.position = position;
        this.firePropertyChange("position", oldPosition, position);
    }

    void setReportedPosition(int reportedPosition) {
        int oldPosition = this.reportedPosition;
        this.reportedPosition = reportedPosition;
        this.firePropertyChange("reportedPosition", oldPosition, reportedPosition);
    }

    public String toString() {
        int systemHashcode;
        StringBuilder sb = new StringBuilder("AsteriskQueueEntry[");
        try (Locker.LockCloser closer = this.withLock();){
            sb.append("dateJoined=").append(this.getDateJoined()).append(",");
            sb.append("postition=").append(this.getPosition()).append(",");
            sb.append("dateLeft=").append(this.getDateLeft()).append(",");
            systemHashcode = System.identityHashCode(this);
        }
        if (this.channel != null) {
            sb.append("channel=AsteriskChannel[");
            closer = this.channel.withLock();
            var4_3 = null;
            try {
                sb.append("id='").append(this.channel.getId()).append("',");
                sb.append("name='").append(this.channel.getName()).append("'],");
            }
            catch (Throwable throwable) {
                var4_3 = throwable;
                throw throwable;
            }
            finally {
                if (closer != null) {
                    if (var4_3 != null) {
                        try {
                            closer.close();
                        }
                        catch (Throwable throwable) {
                            var4_3.addSuppressed(throwable);
                        }
                    } else {
                        closer.close();
                    }
                }
            }
        } else {
            sb.append("channel=null,");
        }
        sb.append("systemHashcode=").append(systemHashcode);
        sb.append("]");
        return sb.toString();
    }
}

