/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.core.request.mapper.IMapperContext;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReferenceRegistry;

public class DefaultMapperContext
implements IMapperContext {
    private final Application application;

    public DefaultMapperContext() {
        this(Application.get());
    }

    public DefaultMapperContext(Application application) {
        this.application = application;
    }

    @Override
    public String getBookmarkableIdentifier() {
        return "bookmarkable";
    }

    @Override
    public String getNamespace() {
        return "wicket";
    }

    @Override
    public String getPageIdentifier() {
        return "page";
    }

    @Override
    public String getResourceIdentifier() {
        return "resource";
    }

    @Override
    public ResourceReferenceRegistry getResourceReferenceRegistry() {
        return this.application.getResourceReferenceRegistry();
    }

    @Override
    public IRequestablePage newPageInstance(Class<? extends IRequestablePage> pageClass, PageParameters pageParameters) {
        if (pageParameters == null) {
            return this.application.getPageFactory().newPage(pageClass);
        }
        return this.application.getPageFactory().newPage(pageClass, pageParameters);
    }

    @Override
    public IRequestablePage getPageInstance(int pageId) {
        IManageablePage manageablePage = Session.get().getPageManager().getPage(pageId);
        IRequestablePage requestablePage = null;
        if (manageablePage instanceof IRequestablePage) {
            requestablePage = (IRequestablePage)manageablePage;
        }
        return requestablePage;
    }

    @Override
    public Class<? extends IRequestablePage> getHomePageClass() {
        return this.application.getHomePage();
    }
}

