/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.core.util;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.openmeetings.IApplication;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.core.util.ws.WsMessageChat;
import org.apache.openmeetings.core.util.ws.WsMessageChat2All;
import org.apache.openmeetings.core.util.ws.WsMessageChat2User;
import org.apache.openmeetings.db.entity.basic.ChatMessage;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.manager.IClientManager;
import org.apache.openmeetings.db.util.FormatHelper;
import org.apache.openmeetings.util.ws.IClusterWsMessage;

public class ChatWebSocketHelper {
    public static final String ID_TAB_PREFIX = "chatTab-";
    public static final String ID_ALL = "chatTab-all";
    public static final String ID_ROOM_PREFIX = "chatTab-r";
    public static final String ID_USER_PREFIX = "chatTab-u";

    private ChatWebSocketHelper() {
    }

    private static JSONObject setScope(JSONObject o, ChatMessage m, long curUserId) {
        Object scope;
        String scopeName = null;
        if (m.getToUser() != null) {
            User u = curUserId == m.getToUser().getId() ? m.getFromUser() : m.getToUser();
            scope = ID_USER_PREFIX + u.getId();
            scopeName = u.getDisplayName();
        } else if (m.getToRoom() != null) {
            scope = ID_ROOM_PREFIX + m.getToRoom().getId();
            o.put("needModeration", m.isNeedModeration());
        } else {
            scope = ID_ALL;
        }
        return o.put("scope", scope).put("scopeName", scopeName);
    }

    public static JSONObject getMessage(User curUser, List<ChatMessage> list, BiConsumer<JSONObject, User> uFmt) {
        JSONArray arr = new JSONArray();
        for (ChatMessage m : list) {
            String smsg = m.getMessage();
            smsg = smsg == null ? smsg : " " + smsg.replace("&nbsp;", " ") + " ";
            JSONObject from = new JSONObject().put("id", (Object)m.getFromUser().getId()).put("displayName", (Object)m.getFromName()).put("name", (Object)m.getFromUser().getDisplayName());
            if (uFmt != null) {
                uFmt.accept(from, m.getFromUser());
            }
            arr.put((Object)ChatWebSocketHelper.setDates(ChatWebSocketHelper.setScope(new JSONObject(), m, curUser.getId()).put("id", (Object)m.getId()).put("message", (Object)smsg).put("from", (Object)from).put("actions", (Object)(curUser.getId().equals(m.getFromUser().getId()) ? "short" : "full")), m, curUser, true));
        }
        return new JSONObject().put("type", (Object)"chat").put("msg", (Object)arr);
    }

    public static boolean send(IClusterWsMessage msg) {
        if (msg instanceof WsMessageChat) {
            WsMessageChat chatMsg = (WsMessageChat)msg;
            if (msg instanceof WsMessageChat2User) {
                WsMessageChat2User userMsg = (WsMessageChat2User)msg;
                ChatWebSocketHelper.sendUser(userMsg.getUserId(), userMsg.getChatMessage(), userMsg.getMsg(), false);
            } else if (msg instanceof WsMessageChat2All) {
                WsMessageChat2All allMsg = (WsMessageChat2All)msg;
                ChatWebSocketHelper.sendAll(allMsg.getChatMessage(), allMsg.getMsg(), false);
            } else {
                ChatWebSocketHelper.sendRoom(chatMsg.getChatMessage(), chatMsg.getMsg(), false);
            }
            return true;
        }
        return false;
    }

    public static void sendRoom(ChatMessage m, JSONObject msg) {
        ChatWebSocketHelper.sendRoom(m, msg, true);
    }

    private static JSONObject setDates(JSONObject o, ChatMessage m, User u, boolean immediate) {
        FastDateFormat fullFmt = FormatHelper.getDateTimeFormat((User)u);
        FastDateFormat dateFmt = FormatHelper.getDateFormat((User)u);
        FastDateFormat timeFmt = FormatHelper.getTimeFormat((User)u);
        JSONObject obj = immediate ? o : o.getJSONArray("msg").getJSONObject(0);
        obj.put("sent", (Object)fullFmt.format(m.getSent())).put("date", (Object)dateFmt.format(m.getSent())).put("time", (Object)timeFmt.format(m.getSent()));
        return o;
    }

    private static void sendRoom(ChatMessage m, JSONObject msg, boolean publish) {
        if (publish) {
            WebSocketHelper.publish(new WsMessageChat(m, msg));
        }
        WebSocketHelper.sendRoom(m.getToRoom().getId(), msg, c -> !m.isNeedModeration() || m.isNeedModeration() && c.hasRight(Room.Right.MODERATOR), (o, c) -> ChatWebSocketHelper.setDates(o, m, c.getUser(), false));
    }

    public static void sendUser(Long userId, ChatMessage m, JSONObject msg) {
        ChatWebSocketHelper.sendUser(userId, m, msg, true);
    }

    private static void sendUser(Long userId, ChatMessage m, JSONObject msg, boolean publish) {
        if (publish) {
            WebSocketHelper.publish(new WsMessageChat2User(userId, m, msg));
        }
        WebSocketHelper.sendUser(userId, msg, (JSONObject o, Client c) -> ChatWebSocketHelper.setDates(o, m, c.getUser(), false), false);
    }

    public static void sendAll(ChatMessage m, JSONObject msg) {
        ChatWebSocketHelper.sendAll(m, msg, true);
    }

    private static void sendAll(ChatMessage m, JSONObject msg, boolean publish) {
        if (publish) {
            WebSocketHelper.publish(new WsMessageChat2All(m, msg));
        }
        WebSocketHelper.send(a -> ((IClientManager)((IApplication)a).getBean(IClientManager.class)).stream(), (t, c) -> WebSocketHelper.doSend(t, c, msg, (o, cm) -> ChatWebSocketHelper.setDates(o, m, c.getUser(), false), "all"), WebSocketHelper.alwaysTrue());
    }
}

