/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.asteriskjava.live.AmaFlags;
import org.asteriskjava.live.AsteriskChannel;
import org.asteriskjava.live.CallDetailRecord;
import org.asteriskjava.live.Disposition;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.manager.event.CdrEvent;

public class CallDetailRecordImpl
implements CallDetailRecord {
    private static final Map<String, Disposition> DISPOSITION_MAP = new HashMap<String, Disposition>();
    private static final Map<String, AmaFlags> AMA_FLAGS_MAP;
    private final AsteriskChannelImpl channel;
    private final AsteriskChannelImpl destinationChannel;
    private final String accountCode;
    private final String destinationContext;
    private final String destinationExtension;
    private final String lastApplication;
    private final String lastAppData;
    private final Date startDate;
    private final Date answerDate;
    private final Date endDate;
    private final Integer duration;
    private final Integer billableSeconds;
    private final Disposition disposition;
    private final AmaFlags amaFlags;
    private final String userField;

    CallDetailRecordImpl(AsteriskChannelImpl channel, AsteriskChannelImpl destinationChannel, CdrEvent cdrEvent) {
        TimeZone tz = TimeZone.getDefault();
        this.channel = channel;
        this.destinationChannel = destinationChannel;
        this.accountCode = cdrEvent.getAccountCode();
        this.destinationContext = cdrEvent.getDestinationContext();
        this.destinationExtension = cdrEvent.getDestination();
        this.lastApplication = cdrEvent.getLastApplication();
        this.lastAppData = cdrEvent.getLastData();
        this.startDate = cdrEvent.getStartTimeAsDate(tz);
        this.answerDate = cdrEvent.getAnswerTimeAsDate(tz);
        this.endDate = cdrEvent.getEndTimeAsDate(tz);
        this.duration = cdrEvent.getDuration();
        this.billableSeconds = cdrEvent.getBillableSeconds();
        this.amaFlags = cdrEvent.getAmaFlags() != null ? AMA_FLAGS_MAP.get(cdrEvent.getAmaFlags()) : null;
        this.disposition = cdrEvent.getDisposition() != null ? DISPOSITION_MAP.get(cdrEvent.getDisposition()) : null;
        this.userField = cdrEvent.getUserField();
    }

    @Override
    public AsteriskChannel getChannel() {
        return this.channel;
    }

    @Override
    public AsteriskChannel getDestinationChannel() {
        return this.destinationChannel;
    }

    @Override
    public String getAccountCode() {
        return this.accountCode;
    }

    @Override
    public AmaFlags getAmaFlags() {
        return this.amaFlags;
    }

    @Override
    public Date getAnswerDate() {
        return this.answerDate;
    }

    @Override
    public Integer getBillableSeconds() {
        return this.billableSeconds;
    }

    @Override
    public String getDestinationContext() {
        return this.destinationContext;
    }

    @Override
    public String getDestinationExtension() {
        return this.destinationExtension;
    }

    @Override
    public Disposition getDisposition() {
        return this.disposition;
    }

    @Override
    public Integer getDuration() {
        return this.duration;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public String getLastApplication() {
        return this.lastApplication;
    }

    @Override
    public String getLastAppData() {
        return this.lastAppData;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public String getUserField() {
        return this.userField;
    }

    static {
        DISPOSITION_MAP.put("ANSWERED", Disposition.ANSWERED);
        DISPOSITION_MAP.put("BUSY", Disposition.BUSY);
        DISPOSITION_MAP.put("FAILED", Disposition.FAILED);
        DISPOSITION_MAP.put("NO ANSWER", Disposition.NO_ANSWER);
        DISPOSITION_MAP.put("UNKNOWN", Disposition.UNKNOWN);
        AMA_FLAGS_MAP = new HashMap<String, AmaFlags>();
        AMA_FLAGS_MAP.put("BILLING", AmaFlags.BILLING);
        AMA_FLAGS_MAP.put("DOCUMENTATION", AmaFlags.DOCUMENTATION);
        AMA_FLAGS_MAP.put("OMIT", AmaFlags.OMIT);
        AMA_FLAGS_MAP.put("Unknown", AmaFlags.UNKNOWN);
    }
}

