/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.management;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.management.ClientConnectionProcessListener;
import com.hazelcast.cluster.Address;
import com.hazelcast.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ClientConnectionProcessListenerRegistry {
    private final CopyOnWriteArrayList<ClientConnectionProcessListener> listeners;
    private final ILogger logger;

    public ClientConnectionProcessListenerRegistry(HazelcastClientInstanceImpl client) {
        this.logger = client.getLoggingService().getLogger(ClientConnectionProcessListenerRegistry.class);
        this.listeners = new CopyOnWriteArrayList();
    }

    public void addListener(ClientConnectionProcessListener listener) {
        this.listeners.add(listener);
    }

    public <A> void onAttemptingToConnectToTarget(Function<A, Address> addressTranslator, A target) {
        if (this.listeners.isEmpty()) {
            return;
        }
        Address translatedAddress = this.translateAddress(addressTranslator, target, "attemptingToConnectToAddress");
        if (translatedAddress == null) {
            return;
        }
        this.callListeners(listener -> listener.attemptingToConnectToAddress(translatedAddress));
    }

    public <A> void onConnectionAttemptFailed(Function<A, Address> addressTranslator, A target) {
        if (this.listeners.isEmpty()) {
            return;
        }
        Address translatedAddress = this.translateAddress(addressTranslator, target, "connectionAttemptFailed");
        if (translatedAddress == null) {
            return;
        }
        this.callListeners(listener -> listener.connectionAttemptFailed(translatedAddress));
    }

    public void onHostNotFound(String host) {
        this.callListeners(listener -> listener.hostNotFound(host));
    }

    public void onPossibleAddressesCollected(Collection<Address> addresses) {
        if (this.listeners.isEmpty()) {
            return;
        }
        ArrayList<Address> addressesList = new ArrayList<Address>(addresses);
        this.callListeners(listener -> listener.possibleAddressesCollected(addressesList));
    }

    public void onPossibleAddressesCollected(List<Address> addresses) {
        this.callListeners(listener -> listener.possibleAddressesCollected(addresses));
    }

    public void onAuthenticationSuccess(Address address) {
        this.callListeners(listener -> listener.authenticationSuccess(address));
    }

    public void onCredentialsFailed(Address address) {
        this.callListeners(listener -> listener.credentialsFailed(address));
    }

    public void onClientNotAllowedInCluster(Address address) {
        this.callListeners(listener -> listener.clientNotAllowedInCluster(address));
    }

    public void onClusterConnectionFailed(String clusterName) {
        this.callListeners(listener -> listener.clusterConnectionFailed(clusterName));
    }

    public void onClusterConnectionSucceeded(String clusterName) {
        this.callListeners(listener -> listener.clusterConnectionSucceeded(clusterName));
    }

    public <A> void onRemoteClosedConnection(Function<A, Address> addressTranslator, A target) {
        if (this.listeners.isEmpty()) {
            return;
        }
        Address translatedAddress = this.translateAddress(addressTranslator, target, "remoteClosedConnection");
        if (translatedAddress == null) {
            return;
        }
        this.callListeners(listener -> listener.remoteClosedConnection(translatedAddress));
    }

    private <A> Address translateAddress(Function<A, Address> addressTranslator, A target, String listenerMethodName) {
        try {
            return addressTranslator.apply(target);
        }
        catch (Throwable t) {
            this.logger.finest("Failed to translate address, can't fire " + listenerMethodName + " event for target " + target, t);
            return null;
        }
    }

    private void callListeners(Consumer<ClientConnectionProcessListener> consumer) {
        for (ClientConnectionProcessListener listener : this.listeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable t) {
                this.logger.finest("Exception while calling the ClientConnectionProcessListener listener " + listener, t);
            }
        }
    }
}

