/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.holder;

import com.hazelcast.client.impl.protocol.codec.holder.AnchorDataListHolder;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.IterationType;
import com.hazelcast.query.PartitionPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.predicates.MultiPartitionPredicateImpl;
import com.hazelcast.query.impl.predicates.PagingPredicateImpl;
import com.hazelcast.query.impl.predicates.PartitionPredicateImpl;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PagingPredicateHolder {
    private final AnchorDataListHolder anchorDataListHolder;
    private final Data predicateData;
    private final Data comparatorData;
    private final int pageSize;
    private final int page;
    private final byte iterationTypeId;
    private final Collection<Data> partitionKeysData;

    public PagingPredicateHolder(AnchorDataListHolder anchorDataListHolder, Data predicateData, Data comparatorData, int pageSize, int page, byte iterationTypeId, Data partitionKeyData, boolean partitionKeysDataExists, Collection<Data> partitionKeysData) {
        this.anchorDataListHolder = anchorDataListHolder;
        this.predicateData = predicateData;
        this.comparatorData = comparatorData;
        this.pageSize = pageSize;
        this.page = page;
        this.iterationTypeId = iterationTypeId;
        this.partitionKeysData = partitionKeysData != null ? (Collection)partitionKeysData.stream().collect(Collectors.toSet()) : (partitionKeyData != null ? Collections.singleton(partitionKeyData) : null);
    }

    public AnchorDataListHolder getAnchorDataListHolder() {
        return this.anchorDataListHolder;
    }

    public Data getPredicateData() {
        return this.predicateData;
    }

    public Data getComparatorData() {
        return this.comparatorData;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPage() {
        return this.page;
    }

    public byte getIterationTypeId() {
        return this.iterationTypeId;
    }

    public Data getPartitionKeyData() {
        if (this.partitionKeysData == null) {
            return null;
        }
        return this.partitionKeysData.iterator().next();
    }

    public Collection<Data> getPartitionKeysData() {
        return this.partitionKeysData;
    }

    public <K, V> Predicate<K, V> asPredicate(SerializationService serializationService, @Nullable String namespace) {
        return (Predicate)((Object)NamespaceUtil.callWithNamespace(namespace, () -> {
            List anchorList = this.anchorDataListHolder.asAnchorList(serializationService);
            Predicate predicate = (Predicate)serializationService.toObject(this.predicateData);
            Comparator comparator = (Comparator)serializationService.toObject(this.comparatorData);
            IterationType iterationType = IterationType.getById(this.iterationTypeId);
            PagingPredicateImpl pagingPredicate = new PagingPredicateImpl(anchorList, predicate, comparator, this.pageSize, this.page, iterationType, namespace);
            if (this.partitionKeysData == null) {
                return pagingPredicate;
            }
            HashSet partitionKeys = new HashSet();
            for (Data keyData : this.partitionKeysData) {
                partitionKeys.add(serializationService.toObject(keyData));
            }
            return partitionKeys.size() == 1 ? new PartitionPredicateImpl(partitionKeys.iterator().next(), pagingPredicate) : new MultiPartitionPredicateImpl(partitionKeys, pagingPredicate);
        }));
    }

    public static <K, V> PagingPredicateHolder of(Predicate<K, V> predicate, SerializationService serializationService) {
        if (predicate instanceof PartitionPredicate) {
            return PagingPredicateHolder.ofInternal((PartitionPredicate)predicate, serializationService);
        }
        return PagingPredicateHolder.ofInternal((PagingPredicateImpl)predicate, serializationService);
    }

    private static <K, V> PagingPredicateHolder ofInternal(PagingPredicateImpl<K, V> pagingPredicate, SerializationService serializationService) {
        if (pagingPredicate == null) {
            return null;
        }
        return PagingPredicateHolder.buildHolder(serializationService, pagingPredicate, null);
    }

    private static <K, V> PagingPredicateHolder ofInternal(@Nonnull PartitionPredicate<K, V> partitionPredicate, SerializationService serializationService) {
        PagingPredicateImpl pagingPredicate = (PagingPredicateImpl)partitionPredicate.getTarget();
        return PagingPredicateHolder.buildHolder(serializationService, pagingPredicate, partitionPredicate.getPartitionKeys());
    }

    private static <K, V> PagingPredicateHolder buildHolder(SerializationService serializationService, PagingPredicateImpl<K, V> pagingPredicate, Collection<? extends Object> partitionKeys) {
        List<Map.Entry<Integer, Map.Entry<K, V>>> anchorList = pagingPredicate.getAnchorList();
        ArrayList<Map.Entry<Data, Data>> anchorDataList = new ArrayList<Map.Entry<Data, Data>>(anchorList.size());
        ArrayList<Integer> pageList = new ArrayList<Integer>(anchorList.size());
        anchorList.forEach(item -> {
            pageList.add((Integer)item.getKey());
            Map.Entry anchorEntry = (Map.Entry)item.getValue();
            anchorDataList.add(new AbstractMap.SimpleImmutableEntry(serializationService.toData(anchorEntry.getKey()), serializationService.toData(anchorEntry.getValue())));
        });
        AnchorDataListHolder anchorDataListHolder = new AnchorDataListHolder(pageList, anchorDataList);
        Object predicateData = serializationService.toData(pagingPredicate.getPredicate());
        Object comparatorData = serializationService.toData(pagingPredicate.getComparator());
        boolean partitionKeysDataExists = partitionKeys != null;
        return new PagingPredicateHolder(anchorDataListHolder, (Data)predicateData, (Data)comparatorData, pagingPredicate.getPageSize(), pagingPredicate.getPage(), pagingPredicate.getIterationType().getId(), null, partitionKeysDataExists, partitionKeysDataExists ? (Collection)partitionKeys.stream().map(k -> serializationService.toData(k)).collect(Collectors.toList()) : null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagingPredicateHolder that = (PagingPredicateHolder)o;
        return this.pageSize == that.pageSize && this.page == that.page && this.iterationTypeId == that.iterationTypeId && Objects.equals(this.anchorDataListHolder, that.anchorDataListHolder) && this.predicateData.equals(that.predicateData) && this.comparatorData.equals(that.comparatorData) && this.partitionKeysData.equals(that.partitionKeysData);
    }

    public int hashCode() {
        return Objects.hash(this.anchorDataListHolder, this.predicateData, this.comparatorData, this.pageSize, this.page, this.iterationTypeId, this.partitionKeysData);
    }
}

