/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl.operations;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.executor.impl.DistributedExecutorService;
import com.hazelcast.executor.impl.ExecutorDataSerializerHook;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.NamedOperation;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nonnull;

abstract class AbstractCallableTaskOperation
extends Operation
implements NamedOperation,
IdentifiedDataSerializable {
    protected String name;
    protected UUID uuid;
    private Data callableData;

    AbstractCallableTaskOperation() {
    }

    AbstractCallableTaskOperation(String name, UUID uuid, @Nonnull Data callableData) {
        this.name = name;
        this.uuid = uuid;
        this.callableData = callableData;
    }

    @Override
    public final CallStatus call() {
        return new OffloadImpl();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        UUIDSerializationUtil.writeUUID(out, this.uuid);
        IOUtil.writeData(out, this.callableData);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.uuid = UUIDSerializationUtil.readUUID(in);
        this.callableData = IOUtil.readData(in);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", name=").append(this.name);
    }

    @Override
    public int getFactoryId() {
        return ExecutorDataSerializerHook.F_ID;
    }

    private class OffloadImpl
    extends Offload {
        OffloadImpl() {
            super(AbstractCallableTaskOperation.this);
        }

        @Override
        public void start() {
            DistributedExecutorService service = (DistributedExecutorService)AbstractCallableTaskOperation.this.getService();
            service.execute(AbstractCallableTaskOperation.this.name, AbstractCallableTaskOperation.this.uuid, this.loadTask(), AbstractCallableTaskOperation.this);
        }

        private Object loadTask() {
            return NamespaceUtil.callWithNamespace(DistributedExecutorService.lookupNamespace(this.nodeEngine, AbstractCallableTaskOperation.this.name), () -> {
                ManagedContext managedContext = this.serializationService.getManagedContext();
                Object object = this.serializationService.toObject(AbstractCallableTaskOperation.this.callableData);
                return managedContext.initialize(object);
            });
        }
    }
}

