/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.ConfigRecognizer;
import com.hazelcast.config.ConfigStream;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.internal.util.XmlUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.InputStream;
import java.util.Objects;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AbstractXmlConfigRootTagRecognizer
implements ConfigRecognizer {
    private final SAXParser saxParser;
    private final String expectedRootNode;
    private final ILogger logger = Logger.getLogger(AbstractXmlConfigRootTagRecognizer.class);

    public AbstractXmlConfigRootTagRecognizer(String expectedRootNode) throws Exception {
        this.expectedRootNode = expectedRootNode;
        SAXParserFactory factory = XmlUtil.getSAXParserFactory();
        this.saxParser = factory.newSAXParser();
    }

    @Override
    public boolean isRecognized(ConfigStream configStream) throws Exception {
        MemberHandler memberHandler = new MemberHandler(this.expectedRootNode);
        try {
            this.saxParser.parse((InputStream)configStream, (DefaultHandler)memberHandler);
        }
        catch (TerminateParseException terminateParseException) {
        }
        catch (SAXParseException ex) {
            this.handleParseException(ex);
            return false;
        }
        catch (Exception ex) {
            this.handleUnexpectedException(ex);
            throw ex;
        }
        return memberHandler.isMemberXml;
    }

    private void handleParseException(SAXParseException ex) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("An exception is encountered while processing the provided XML configuration", ex);
        }
    }

    private void handleUnexpectedException(Exception ex) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("An unexpected exception is encountered while processing the provided XML configuration", ex);
        }
    }

    private static final class MemberHandler
    extends DefaultHandler {
        private final String expectedRootNode;
        private boolean isMemberXml;

        private MemberHandler(String expectedRootNode) {
            this.expectedRootNode = Objects.requireNonNull(expectedRootNode);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (StringUtil.equalsIgnoreCase(this.expectedRootNode, qName)) {
                this.isMemberXml = true;
            }
            throw new TerminateParseException();
        }
    }

    private static final class TerminateParseException
    extends SAXException {
        private TerminateParseException() {
        }
    }
}

