/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.UUID;

public class DemoteRequestOperation
extends AbstractPartitionOperation
implements MigrationCycleOperation {
    private UUID uuid;
    private transient boolean response;

    public DemoteRequestOperation() {
    }

    public DemoteRequestOperation(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public void run() {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        ILogger logger = this.getLogger();
        Address caller = this.getCallerAddress();
        if (partitionService.isLocalMemberMaster()) {
            ClusterService clusterService = this.getNodeEngine().getClusterService();
            MemberImpl member = clusterService.getMember(caller);
            if (member != null) {
                if (logger.isFinestEnabled()) {
                    logger.finest("Received demote request from " + caller);
                }
                if (member.getUuid().equals(this.uuid)) {
                    this.response = partitionService.onDemoteRequest(member);
                } else {
                    logger.warning("Ignoring demote request from " + this.uuid + " because it is not a member");
                    this.response = false;
                }
            } else {
                logger.warning("Ignoring demote request from " + caller + " because it is not a member");
                this.response = false;
            }
        } else {
            logger.warning("Received demote request from " + caller + " but this node is not master.");
            this.response = false;
        }
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public int getClassId() {
        return 26;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.uuid);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.uuid = UUIDSerializationUtil.readUUID(in);
    }
}

