/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.map.EntryProcessor;

public class MapSinkEntryProcessorConfiguration<E, K, V, R> {
    private final String mapName;
    private DataConnectionRef dataConnectionRef;
    private String clientXml;
    private FunctionEx<? super E, ? extends K> toKeyFn;
    private FunctionEx<? super E, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn;
    private int maxParallelAsyncOps = 1000;

    public MapSinkEntryProcessorConfiguration(String mapName) {
        this.mapName = mapName;
    }

    public String getMapName() {
        return this.mapName;
    }

    public DataConnectionRef getDataConnectionRef() {
        return this.dataConnectionRef;
    }

    public String getDataConnectionName() {
        return this.dataConnectionRef == null ? null : this.dataConnectionRef.getName();
    }

    public void setDataConnectionRef(DataConnectionRef dataConnectionRef) {
        this.dataConnectionRef = dataConnectionRef;
    }

    public String getClientXml() {
        return this.clientXml;
    }

    public void setClientXml(String clientXml) {
        this.clientXml = clientXml;
    }

    public FunctionEx<? super E, ? extends K> getToKeyFn() {
        return this.toKeyFn;
    }

    public void setToKeyFn(FunctionEx<? super E, ? extends K> toKeyFn) {
        this.toKeyFn = toKeyFn;
    }

    public FunctionEx<? super E, ? extends EntryProcessor<K, V, R>> getToEntryProcessorFn() {
        return this.toEntryProcessorFn;
    }

    public void setToEntryProcessorFn(FunctionEx<? super E, ? extends EntryProcessor<K, V, R>> toEntryProcessorFn) {
        this.toEntryProcessorFn = toEntryProcessorFn;
    }

    public int getMaxParallelAsyncOps() {
        return this.maxParallelAsyncOps;
    }

    public void setMaxParallelAsyncOps(int maxParallelAsyncOps) {
        this.maxParallelAsyncOps = maxParallelAsyncOps;
    }

    public boolean isRemote() {
        return this.dataConnectionRef != null || this.clientXml != null;
    }
}

