/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.pages.auth;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.openmeetings.core.util.StrongPasswordValidator;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.validation.IValidator;

public class ResetPasswordDialog
extends Modal<String> {
    private static final long serialVersionUID = 1L;
    private Form<String> form = new ResetForm("form");
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private PasswordTextField password;
    private final User user;
    @Inject
    private UserDao userDao;

    public ResetPasswordDialog(String id, User user) {
        super(id);
        this.user = user;
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("325"));
        this.setCloseOnEscapeKey(false);
        this.setBackdrop(Modal.Backdrop.STATIC);
        this.show(true);
        this.add(new Component[]{this.form});
        this.addButton((Component)new BootstrapAjaxButton("button", (IModel)new ResourceModel("327"), this.form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;
        });
        super.onInitialize();
    }

    private class ResetForm
    extends Form<String> {
        private static final long serialVersionUID = 1L;
        private PasswordTextField confirmPassword;

        private ResetForm(String id) {
            super(id);
        }

        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{ResetPasswordDialog.this.feedback.setOutputMarkupId(true)});
            TextField login = new TextField("login", (IModel)Model.of((Serializable)((Object)ResetPasswordDialog.this.user.getLogin())));
            this.add(new Component[]{login.setOutputMarkupId(true)});
            Component[] componentArray = new Component[1];
            ResetPasswordDialog.this.password = new PasswordTextField("password", (IModel)new Model());
            componentArray[0] = ResetPasswordDialog.this.password;
            this.add(componentArray);
            ResetPasswordDialog.this.password.setLabel((IModel)new ResourceModel("328")).add((IValidator)new StrongPasswordValidator(ResetPasswordDialog.this.user)).setRequired(false).setOutputMarkupId(true);
            Component[] componentArray2 = new Component[1];
            this.confirmPassword = new PasswordTextField("confirmPassword", (IModel)new Model());
            componentArray2[0] = this.confirmPassword;
            this.add(componentArray2);
            this.confirmPassword.setLabel((IModel)new ResourceModel("116")).setOutputMarkupId(true);
            this.add(new Component[]{new AjaxButton("submit"){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target) {
                    ResetForm.this.onSubmit(target);
                }

                protected void onError(AjaxRequestTarget target) {
                    ResetForm.this.onError(target);
                }
            }});
        }

        protected void onValidate() {
            String pass = (String)ResetPasswordDialog.this.password.getConvertedInput();
            if (pass != null && !pass.isEmpty() && !pass.equals(this.confirmPassword.getConvertedInput())) {
                this.error((Serializable)((Object)this.getString("232")));
            }
            super.onValidate();
        }

        protected void onError() {
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(this::onError);
        }

        protected void onError(AjaxRequestTarget target) {
            target.add(new Component[]{ResetPasswordDialog.this.feedback});
        }

        protected void onSubmit() {
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(this::onSubmit);
        }

        protected void onSubmit(AjaxRequestTarget target) {
            try {
                ResetPasswordDialog.this.userDao.resetPassword(ResetPasswordDialog.this.user, (String)ResetPasswordDialog.this.password.getConvertedInput());
                ResetPasswordDialog.this.close((IPartialPageRequestHandler)target);
                Modal resetInfo = (Modal)this.getPage().get("resetInfo");
                resetInfo.show((IPartialPageRequestHandler)target);
            }
            catch (Exception e) {
                this.error((Serializable)((Object)e.getMessage()));
            }
        }
    }
}

