/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client;

import com.google.common.base.StandardSystemProperty;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import javax.annotation.PreDestroy;
import org.kurento.client.AbstractBuilder;
import org.kurento.client.Continuation;
import org.kurento.client.Handler;
import org.kurento.client.JsonRpcConnectionListenerKurento;
import org.kurento.client.KurentoConnectionListener;
import org.kurento.client.KurentoObject;
import org.kurento.client.MediaPipeline;
import org.kurento.client.Properties;
import org.kurento.client.ReconnectedHandler;
import org.kurento.client.ServerManager;
import org.kurento.client.Transaction;
import org.kurento.client.internal.KmsUrlLoader;
import org.kurento.client.internal.TransactionImpl;
import org.kurento.client.internal.client.RomManager;
import org.kurento.client.internal.transport.jsonrpc.RomClientJsonRpcClient;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.jsonrpc.client.AbstractJsonRpcClientWebSocket;
import org.kurento.jsonrpc.client.JsonRpcClient;
import org.kurento.jsonrpc.client.JsonRpcClientNettyWebSocket;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KurentoClient {
    private static final int KEEPALIVE_TIME = PropertiesManager.getProperty((String)"kurento.client.keepAliveTime", (int)240000);
    private static final long WARN_CONNECTION_TIME = 5000L;
    private static Logger log = LoggerFactory.getLogger(KurentoClient.class);
    protected RomManager manager;
    private long requesTimeout = PropertiesManager.getProperty((String)"kurento.client.requestTimeout", (int)10000);
    private long connectionTimeout = PropertiesManager.getProperty((String)"kurento.client.connectionTimeout", (int)5000);
    private String id;
    private ServerManager serverManager;
    private JsonRpcClient client;
    private static KmsUrlLoader kmsUrlLoader;
    private String label;
    private boolean destroyed = false;

    public static synchronized String getKmsUrl(String id, Properties properties) {
        Object load;
        if (properties == null) {
            properties = new Properties();
        }
        if (kmsUrlLoader == null) {
            Path configFile = Paths.get(StandardSystemProperty.USER_HOME.value(), ".kurento", "config.properties");
            kmsUrlLoader = new KmsUrlLoader(configFile);
        }
        if ((load = properties.get("loadPoints")) == null) {
            return kmsUrlLoader.getKmsUrl(id);
        }
        if (load instanceof Number) {
            return kmsUrlLoader.getKmsUrlLoad(id, ((Number)load).intValue());
        }
        return kmsUrlLoader.getKmsUrlLoad(id, Integer.parseInt(load.toString()));
    }

    private void setId(String id) {
        this.id = id;
    }

    public static KurentoClient create() {
        return KurentoClient.create(new Properties());
    }

    public static KurentoClient create(Properties properties) {
        String id = UUID.randomUUID().toString();
        KurentoClient client = KurentoClient.create(KurentoClient.getKmsUrl(id, properties), properties);
        client.setId(id);
        return client;
    }

    public static KurentoClient create(String websocketUrl) {
        return KurentoClient.create(websocketUrl, new Properties());
    }

    public static KurentoClient create(String websocketUrl, Properties properties) {
        log.debug("Connecting to kms in {}", (Object)websocketUrl);
        JsonRpcClientNettyWebSocket client = new JsonRpcClientNettyWebSocket(websocketUrl);
        KurentoClient.configureJsonRpcClient((AbstractJsonRpcClientWebSocket)client);
        return new KurentoClient((JsonRpcClient)client);
    }

    protected static void configureJsonRpcClient(AbstractJsonRpcClientWebSocket client) {
        client.enableHeartbeat(KEEPALIVE_TIME);
        client.setTryReconnectingForever(true);
        KurentoClient.updateLabel((JsonRpcClient)client, null);
        client.setSendCloseMessage(true);
    }

    public static KurentoClient create(String websocketUrl, KurentoConnectionListener listener) {
        return KurentoClient.create(websocketUrl, listener, new Properties());
    }

    public static KurentoClient create(Properties properties, KurentoConnectionListener listener) {
        String id = UUID.randomUUID().toString();
        KurentoClient client = KurentoClient.create(KurentoClient.getKmsUrl(id, properties), listener, properties);
        client.setId(id);
        return client;
    }

    public static KurentoClient create(String websocketUrl, KurentoConnectionListener listener, Properties properties) {
        log.debug("Connecting to KMS in {}", (Object)websocketUrl);
        JsonRpcClientNettyWebSocket client = new JsonRpcClientNettyWebSocket(websocketUrl, JsonRpcConnectionListenerKurento.create(listener));
        KurentoClient.configureJsonRpcClient((AbstractJsonRpcClientWebSocket)client);
        return new KurentoClient((JsonRpcClient)client);
    }

    protected static KurentoClient create(String kmsWsUri, Properties properties, final Handler connectedHandler, final Handler connectionFailedHandler, final Handler reconnectingHandler, final Handler disconnectedHandler, final ReconnectedHandler reconnectedHandler, Long tryReconnectingMaxTime, Long connectionTimeout) {
        String clientId = null;
        if (kmsWsUri == null) {
            clientId = UUID.randomUUID().toString();
            kmsWsUri = KurentoClient.getKmsUrl(clientId, properties);
        }
        KurentoClient kurentoClient = null;
        log.debug("Connecting to KMS in {}", (Object)kmsWsUri);
        JsonRpcClientNettyWebSocket client = new JsonRpcClientNettyWebSocket(kmsWsUri);
        if (connectionTimeout != null) {
            client.setConnectionTimeout(connectionTimeout.intValue());
        }
        if (connectedHandler != null) {
            client.onConnected(new org.kurento.jsonrpc.client.Handler(){

                public void run() {
                    connectedHandler.run();
                }
            });
        }
        if (connectionFailedHandler != null) {
            client.onConnectionFailed(new org.kurento.jsonrpc.client.Handler(){

                public void run() {
                    connectionFailedHandler.run();
                }
            });
        }
        if (reconnectingHandler != null) {
            client.onReconnecting(new org.kurento.jsonrpc.client.Handler(){

                public void run() {
                    reconnectingHandler.run();
                }
            });
        }
        if (disconnectedHandler != null) {
            client.onDisconnected(new org.kurento.jsonrpc.client.Handler(){

                public void run() {
                    disconnectedHandler.run();
                }
            });
        }
        if (reconnectedHandler != null) {
            client.onReconnected(new org.kurento.jsonrpc.client.ReconnectedHandler(){

                public void run(boolean sameServer) {
                    reconnectedHandler.run(sameServer);
                }
            });
        }
        KurentoClient.configureJsonRpcClient((AbstractJsonRpcClientWebSocket)client);
        if (tryReconnectingMaxTime != null) {
            client.setTryReconnectingMaxTime(tryReconnectingMaxTime.longValue());
        }
        kurentoClient = new KurentoClient((JsonRpcClient)client);
        if (clientId != null) {
            kurentoClient.setId(clientId);
        }
        return kurentoClient;
    }

    protected KurentoClient(JsonRpcClient client) {
        this(client, true);
    }

    protected KurentoClient(JsonRpcClient client, boolean overrideClientTimeouts) {
        this.client = client;
        this.manager = new RomManager(new RomClientJsonRpcClient(client));
        if (overrideClientTimeouts) {
            client.setRequestTimeout(this.requesTimeout);
            client.setConnectionTimeout((int)this.connectionTimeout);
        }
        if (client instanceof AbstractJsonRpcClientWebSocket) {
            ((AbstractJsonRpcClientWebSocket)client).enableHeartbeat(KEEPALIVE_TIME);
        }
        try {
            long start = System.currentTimeMillis();
            client.connect();
            long duration = System.currentTimeMillis() - start;
            if (duration > 5000L) {
                log.warn("Connected to KMS in {} millis (> {} millis)", (Object)duration, (Object)5000L);
            }
        }
        catch (Exception e) {
            throw new KurentoException("Exception connecting to KMS", (Throwable)e);
        }
    }

    public MediaPipeline createMediaPipeline() {
        return (MediaPipeline)new AbstractBuilder(MediaPipeline.class, this.manager).build();
    }

    public void createMediaPipeline(Continuation<MediaPipeline> cont) throws KurentoException {
        new AbstractBuilder<MediaPipeline>(MediaPipeline.class, this.manager).buildAsync(cont);
    }

    public MediaPipeline createMediaPipeline(Transaction tx) {
        return (MediaPipeline)new AbstractBuilder(MediaPipeline.class, this.manager).build(tx);
    }

    public MediaPipeline createMediaPipeline(Properties properties) {
        return (MediaPipeline)new AbstractBuilder(MediaPipeline.class, this.manager).withProperties(properties).build();
    }

    public void createMediaPipeline(Properties properties, Continuation<MediaPipeline> cont) throws KurentoException {
        new AbstractBuilder(MediaPipeline.class, this.manager).withProperties(properties).buildAsync(cont);
    }

    public MediaPipeline createMediaPipeline(Transaction tx, Properties properties) {
        return (MediaPipeline)new AbstractBuilder(MediaPipeline.class, this.manager).withProperties(properties).build(tx);
    }

    @PreDestroy
    public void destroy() {
        this.destroyed = true;
        if (this.isClosed()) {
            log.debug("{} KurentoClient already closed", (Object)this.label);
            return;
        }
        log.debug("Closing KurentoClient");
        this.manager.destroy();
        try {
            this.client.close();
        }
        catch (IOException e) {
            log.error("Error while closing KurentoClient", (Throwable)e);
        }
        if (kmsUrlLoader != null) {
            kmsUrlLoader.clientDestroyed(this.id);
        }
    }

    public boolean isClosed() {
        return this.manager.getRomClient().isClosed();
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public static KurentoClient createFromJsonRpcClient(JsonRpcClient jsonRpcClient) {
        return new KurentoClient(jsonRpcClient);
    }

    public static KurentoClient createFromJsonRpcClientHonoringClientTimeouts(JsonRpcClient jsonRpcClient) {
        return new KurentoClient(jsonRpcClient, false);
    }

    public Transaction beginTransaction() {
        return new TransactionImpl(this.manager);
    }

    public ServerManager getServerManager() {
        if (this.serverManager == null) {
            this.serverManager = this.getById("manager_ServerManager", ServerManager.class);
        }
        return this.serverManager;
    }

    public <T extends KurentoObject> T getById(String id, Class<T> clazz) {
        return (T)((KurentoObject)this.manager.getById(id, clazz));
    }

    public String getSessionId() {
        return this.client.getSession().getSessionId();
    }

    public void setLabel(String label) {
        this.label = label;
        KurentoClient.updateLabel(this.client, label);
    }

    public String getLabel() {
        return this.label;
    }

    private static void updateLabel(JsonRpcClient client, String label) {
        Object clientLabel = "KurentoClient";
        if (label != null) {
            clientLabel = (String)clientLabel + ":" + label;
        }
        client.setLabel((String)clientLabel);
    }

    public Response<JsonElement> sendJsonRpcRequest(Request<JsonObject> request) throws IOException {
        return this.client.sendRequest(request);
    }
}

