/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.checksum;

import java.io.IOException;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.checksum.BaseFileChecksumHelper;
import org.apache.hadoop.ozone.client.checksum.ECFileChecksumHelper;
import org.apache.hadoop.ozone.client.checksum.ReplicatedFileChecksumHelper;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;

public final class ChecksumHelperFactory {
    private ChecksumHelperFactory() {
    }

    public static BaseFileChecksumHelper getChecksumHelper(HddsProtos.ReplicationType replicationType, OzoneVolume volume, OzoneBucket bucket, String keyName, long length, OzoneClientConfig.ChecksumCombineMode combineMode, ClientProtocol rpcClient, OmKeyInfo keyInfo) throws IOException {
        if (replicationType == HddsProtos.ReplicationType.EC) {
            return new ECFileChecksumHelper(volume, bucket, keyName, length, combineMode, rpcClient, keyInfo);
        }
        return new ReplicatedFileChecksumHelper(volume, bucket, keyName, length, combineMode, rpcClient, keyInfo);
    }
}

