/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import org.apache.hadoop.hdds.scm.container.balancer.MoveManager;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@Metrics(name="ContainerBalancer Metrics", about="Metrics related to Container Balancer running in SCM", context="SCM")
public final class ContainerBalancerMetrics {
    public static final String NAME = ContainerBalancerMetrics.class.getSimpleName();
    private final MetricsSystem ms;
    @Metric(about="Amount of Gigabytes that Container Balancer moved in the latest iteration.")
    private MutableCounterLong dataSizeMovedGBInLatestIteration;
    @Metric(about="Number of completed container moves performed by Container Balancer in the latest iteration.")
    private MutableCounterLong numContainerMovesCompletedInLatestIteration;
    @Metric(about="Number of timeout container moves performed by Container Balancer in the latest iteration.")
    private MutableCounterLong numContainerMovesTimeoutInLatestIteration;
    @Metric(about="Number of iterations that Container Balancer has run for.")
    private MutableCounterLong numIterations;
    @Metric(about="Number of datanodes that were involved in balancing in the latest iteration.")
    private MutableCounterLong numDatanodesInvolvedInLatestIteration;
    @Metric(about="Amount of data in Gigabytes that is causing unbalance.")
    private MutableCounterLong dataSizeUnbalancedGB;
    @Metric(about="Number of unbalanced datanodes.")
    private MutableCounterLong numDatanodesUnbalanced;
    @Metric(about="Total number of completed container moves across all iterations of Container Balancer.")
    private MutableCounterLong numContainerMovesCompleted;
    @Metric(about="Total number of timeout container moves across all iterations of Container Balancer.")
    private MutableCounterLong numContainerMovesTimeout;
    @Metric(about="Total data size in GB moved across all iterations of Container Balancer.")
    private MutableCounterLong dataSizeMovedGB;
    @Metric(about="Total number container for which moves failed exceptionally across all iterations of Container Balancer.")
    private MutableCounterLong numContainerMovesFailed;
    @Metric(about="Total number container for which moves failed exceptionally in latest iteration of Container Balancer.")
    private MutableCounterLong numContainerMovesFailedInLatestIteration;
    @Metric(about="Number of container moves that were scheduled in the latest iteration of Container Balancer.")
    private MutableCounterLong numContainerMovesScheduledInLatestIteration;
    @Metric(about="Total number of container moves that were scheduled across all iterations of Container Balancer.")
    private MutableCounterLong numContainerMovesScheduled;

    public static ContainerBalancerMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (ContainerBalancerMetrics)ms.register(NAME, "Container Balancer Metrics", (Object)new ContainerBalancerMetrics(ms));
    }

    private ContainerBalancerMetrics(MetricsSystem ms) {
        this.ms = ms;
    }

    public long getNumContainerMovesScheduled() {
        return this.numContainerMovesScheduled.value();
    }

    void incrementNumContainerMovesScheduled(long valueToAdd) {
        this.numContainerMovesScheduled.incr(valueToAdd);
    }

    public long getNumContainerMovesScheduledInLatestIteration() {
        return this.numContainerMovesScheduledInLatestIteration.value();
    }

    void incrementNumContainerMovesScheduledInLatestIteration(long valueToAdd) {
        this.numContainerMovesScheduledInLatestIteration.incr(valueToAdd);
    }

    public long getDataSizeMovedGBInLatestIteration() {
        return this.dataSizeMovedGBInLatestIteration.value();
    }

    public void incrementDataSizeMovedGBInLatestIteration(long valueToAdd) {
        this.dataSizeMovedGBInLatestIteration.incr(valueToAdd);
    }

    public void resetDataSizeMovedGBInLatestIteration() {
        this.dataSizeMovedGBInLatestIteration.incr(-this.getDataSizeMovedGBInLatestIteration());
    }

    public long getNumContainerMovesCompletedInLatestIteration() {
        return this.numContainerMovesCompletedInLatestIteration.value();
    }

    public void incrementNumContainerMovesCompletedInLatestIteration(long valueToAdd) {
        this.numContainerMovesCompletedInLatestIteration.incr(valueToAdd);
    }

    public void incrementCurrentIterationContainerMoveMetric(MoveManager.MoveResult result, long valueToAdd) {
        if (result == null) {
            return;
        }
        switch (result) {
            case COMPLETED: {
                this.numContainerMovesCompletedInLatestIteration.incr(valueToAdd);
                break;
            }
            case REPLICATION_FAIL_TIME_OUT: 
            case DELETION_FAIL_TIME_OUT: {
                this.numContainerMovesTimeoutInLatestIteration.incr(valueToAdd);
                break;
            }
            case FAIL_LEADER_NOT_READY: 
            case REPLICATION_FAIL_INFLIGHT_REPLICATION: 
            case REPLICATION_FAIL_NOT_EXIST_IN_SOURCE: 
            case REPLICATION_FAIL_EXIST_IN_TARGET: 
            case REPLICATION_FAIL_CONTAINER_NOT_CLOSED: 
            case REPLICATION_FAIL_INFLIGHT_DELETION: 
            case REPLICATION_FAIL_NODE_NOT_IN_SERVICE: 
            case DELETION_FAIL_NODE_NOT_IN_SERVICE: 
            case REPLICATION_FAIL_NODE_UNHEALTHY: 
            case DELETION_FAIL_NODE_UNHEALTHY: 
            case DELETE_FAIL_POLICY: 
            case REPLICATION_NOT_HEALTHY_BEFORE_MOVE: 
            case REPLICATION_NOT_HEALTHY_AFTER_MOVE: 
            case FAIL_CONTAINER_ALREADY_BEING_MOVED: 
            case FAIL_UNEXPECTED_ERROR: {
                this.incrementNumContainerMovesFailedInLatestIteration(valueToAdd);
                break;
            }
        }
    }

    public void resetNumContainerMovesCompletedInLatestIteration() {
        this.numContainerMovesCompletedInLatestIteration.incr(-this.getNumContainerMovesCompletedInLatestIteration());
    }

    public long getNumContainerMovesTimeoutInLatestIteration() {
        return this.numContainerMovesTimeoutInLatestIteration.value();
    }

    public void incrementNumContainerMovesTimeoutInLatestIteration(long valueToAdd) {
        this.numContainerMovesTimeoutInLatestIteration.incr(valueToAdd);
    }

    public void resetNumContainerMovesTimeoutInLatestIteration() {
        this.numContainerMovesTimeoutInLatestIteration.incr(-this.getNumContainerMovesTimeoutInLatestIteration());
    }

    public long getNumIterations() {
        return this.numIterations.value();
    }

    public void incrementNumIterations(long valueToAdd) {
        this.numIterations.incr(valueToAdd);
    }

    public long getNumDatanodesInvolvedInLatestIteration() {
        return this.numDatanodesInvolvedInLatestIteration.value();
    }

    public void incrementNumDatanodesInvolvedInLatestIteration(long valueToAdd) {
        this.numDatanodesInvolvedInLatestIteration.incr(valueToAdd);
    }

    public void resetNumDatanodesInvolvedInLatestIteration() {
        this.numDatanodesInvolvedInLatestIteration.incr(-this.getNumDatanodesInvolvedInLatestIteration());
    }

    public long getDataSizeUnbalancedGB() {
        return this.dataSizeUnbalancedGB.value();
    }

    public void incrementDataSizeUnbalancedGB(long valueToAdd) {
        this.dataSizeUnbalancedGB.incr(valueToAdd);
    }

    public void resetDataSizeUnbalancedGB() {
        this.dataSizeUnbalancedGB.incr(-this.getDataSizeUnbalancedGB());
    }

    public long getNumDatanodesUnbalanced() {
        return this.numDatanodesUnbalanced.value();
    }

    public void incrementNumDatanodesUnbalanced(long valueToAdd) {
        this.numDatanodesUnbalanced.incr(valueToAdd);
    }

    public void resetNumDatanodesUnbalanced() {
        this.numDatanodesUnbalanced.incr(-this.getNumDatanodesUnbalanced());
    }

    public long getNumContainerMovesCompleted() {
        return this.numContainerMovesCompleted.value();
    }

    public void incrementNumContainerMovesCompleted(long valueToAdd) {
        this.numContainerMovesCompleted.incr(valueToAdd);
    }

    public long getNumContainerMovesTimeout() {
        return this.numContainerMovesTimeout.value();
    }

    public void incrementNumContainerMovesTimeout(long valueToAdd) {
        this.numContainerMovesTimeout.incr(valueToAdd);
    }

    public long getDataSizeMovedGB() {
        return this.dataSizeMovedGB.value();
    }

    public void incrementDataSizeMovedGB(long valueToAdd) {
        this.dataSizeMovedGB.incr(valueToAdd);
    }

    public long getNumContainerMovesFailed() {
        return this.numContainerMovesFailed.value();
    }

    public void incrementNumContainerMovesFailed(long valueToAdd) {
        this.numContainerMovesFailed.incr(valueToAdd);
    }

    public long getNumContainerMovesFailedInLatestIteration() {
        return this.numContainerMovesFailedInLatestIteration.value();
    }

    public void incrementNumContainerMovesFailedInLatestIteration(long valueToAdd) {
        this.numContainerMovesFailedInLatestIteration.incr(valueToAdd);
    }

    public void resetNumContainerMovesFailedInLatestIteration() {
        this.numContainerMovesFailedInLatestIteration.incr(-this.getNumContainerMovesFailedInLatestIteration());
    }
}

