/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.scm.container.placement.metrics.LongMetric;
import org.apache.hadoop.hdds.scm.container.placement.metrics.NodeStat;

public class SCMNodeStat
implements NodeStat {
    private LongMetric capacity;
    private LongMetric scmUsed;
    private LongMetric remaining;

    public SCMNodeStat() {
        this(0L, 0L, 0L);
    }

    public SCMNodeStat(SCMNodeStat other) {
        this(other.capacity.get(), other.scmUsed.get(), other.remaining.get());
    }

    public SCMNodeStat(long capacity, long used, long remaining) {
        Preconditions.checkArgument((capacity >= 0L ? 1 : 0) != 0, (Object)"Capacity cannot be negative.");
        Preconditions.checkArgument((used >= 0L ? 1 : 0) != 0, (Object)"used space cannot be negative.");
        Preconditions.checkArgument((remaining >= 0L ? 1 : 0) != 0, (Object)"remaining cannot be negative");
        this.capacity = new LongMetric(capacity);
        this.scmUsed = new LongMetric(used);
        this.remaining = new LongMetric(remaining);
    }

    @Override
    public LongMetric getCapacity() {
        return this.capacity;
    }

    @Override
    public LongMetric getScmUsed() {
        return this.scmUsed;
    }

    @Override
    public LongMetric getRemaining() {
        return this.remaining;
    }

    @Override
    @VisibleForTesting
    public void set(long newCapacity, long newUsed, long newRemaining) {
        Preconditions.checkArgument((newCapacity >= 0L ? 1 : 0) != 0, (Object)"Capacity cannot be negative.");
        Preconditions.checkArgument((newUsed >= 0L ? 1 : 0) != 0, (Object)"used space cannot be negative.");
        Preconditions.checkArgument((newRemaining >= 0L ? 1 : 0) != 0, (Object)"remaining cannot be negative");
        this.capacity = new LongMetric(newCapacity);
        this.scmUsed = new LongMetric(newUsed);
        this.remaining = new LongMetric(newRemaining);
    }

    @Override
    public SCMNodeStat add(NodeStat stat) {
        this.capacity.set(this.getCapacity().get() + stat.getCapacity().get());
        this.scmUsed.set(this.getScmUsed().get() + stat.getScmUsed().get());
        this.remaining.set(this.getRemaining().get() + stat.getRemaining().get());
        return this;
    }

    @Override
    public SCMNodeStat subtract(NodeStat stat) {
        this.capacity.set(this.getCapacity().get() - stat.getCapacity().get());
        this.scmUsed.set(this.getScmUsed().get() - stat.getScmUsed().get());
        this.remaining.set(this.getRemaining().get() - stat.getRemaining().get());
        return this;
    }

    public boolean equals(Object to) {
        if (to instanceof SCMNodeStat) {
            SCMNodeStat tempStat = (SCMNodeStat)to;
            return this.capacity.isEqual(tempStat.getCapacity().get()) && this.scmUsed.isEqual(tempStat.getScmUsed().get()) && this.remaining.isEqual(tempStat.getRemaining().get());
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.capacity.get() ^ this.scmUsed.get() ^ this.remaining.get());
    }
}

