/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.util.Map;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.scm.node.NodeManagerMXBean;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@Metrics(about="SCM NodeManager Metrics", context="ozone")
public final class SCMNodeMetrics
implements MetricsSource {
    public static final String SOURCE_NAME = SCMNodeMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong numHBProcessed;
    @Metric
    private MutableCounterLong numHBProcessingFailed;
    @Metric
    private MutableCounterLong numNodeReportProcessed;
    @Metric
    private MutableCounterLong numNodeReportProcessingFailed;
    @Metric
    private MutableCounterLong numNodeCommandQueueReportProcessed;
    @Metric
    private MutableCounterLong numNodeCommandQueueReportProcessingFailed;
    @Metric
    private String textMetric;
    private final MetricsRegistry registry;
    private final NodeManagerMXBean managerMXBean;
    private final MetricsInfo recordInfo = Interns.info((String)"SCMNodeManager", (String)"SCM NodeManager metrics");

    private SCMNodeMetrics(NodeManagerMXBean managerMXBean) {
        this.managerMXBean = managerMXBean;
        this.registry = new MetricsRegistry(this.recordInfo);
        this.textMetric = "my_test_metric";
    }

    public static SCMNodeMetrics create(NodeManagerMXBean managerMXBean) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (SCMNodeMetrics)ms.register(SOURCE_NAME, "SCM NodeManager Metrics", (Object)new SCMNodeMetrics(managerMXBean));
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    void incNumHBProcessed() {
        this.numHBProcessed.incr();
    }

    void incNumHBProcessingFailed() {
        this.numHBProcessingFailed.incr();
    }

    void incNumNodeReportProcessed() {
        this.numNodeReportProcessed.incr();
    }

    void incNumNodeReportProcessingFailed() {
        this.numNodeReportProcessingFailed.incr();
    }

    void incNumNodeCommandQueueReportProcessed() {
        this.numNodeCommandQueueReportProcessed.incr();
    }

    void incNumNodeCommandQueueReportProcessingFailed() {
        this.numNodeCommandQueueReportProcessingFailed.incr();
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        Map<String, Map<String, Integer>> nodeCount = this.managerMXBean.getNodeCount();
        Map<String, Long> nodeInfo = this.managerMXBean.getNodeInfo();
        MetricsRecordBuilder metrics = collector.addRecord(this.registry.info());
        for (Map.Entry<String, Map<String, Integer>> entry : nodeCount.entrySet()) {
            for (Map.Entry<String, Integer> h : entry.getValue().entrySet()) {
                metrics.addGauge(Interns.info((String)StringUtils.camelize((String)(entry.getKey() + "_" + h.getKey() + "_nodes")), (String)("Number of " + entry.getKey() + " " + h.getKey() + " datanodes")), h.getValue().intValue());
            }
        }
        for (Map.Entry<String, Object> entry : nodeInfo.entrySet()) {
            metrics.addGauge(Interns.info((String)entry.getKey(), (String)this.diskMetricDescription(entry.getKey())), ((Long)entry.getValue()).longValue());
        }
        this.registry.snapshot(metrics, all);
    }

    private String diskMetricDescription(String metric) {
        StringBuilder sb = new StringBuilder();
        sb.append("Total");
        if (metric.indexOf("Maintenance") >= 0) {
            sb.append(" maintenance");
        } else if (metric.indexOf("Decommissioned") >= 0) {
            sb.append(" decommissioned");
        }
        if (metric.indexOf("DiskCapacity") >= 0) {
            sb.append(" disk capacity");
        } else if (metric.indexOf("DiskUsed") >= 0) {
            sb.append(" disk capacity used");
        } else if (metric.indexOf("DiskRemaining") >= 0) {
            sb.append(" disk capacity remaining");
        } else if (metric.indexOf("SSDCapacity") >= 0) {
            sb.append(" SSD capacity");
        } else if (metric.indexOf("SSDUsed") >= 0) {
            sb.append(" SSD capacity used");
        } else if (metric.indexOf("SSDRemaining") >= 0) {
            sb.append(" SSD capacity remaining");
        }
        return sb.toString();
    }
}

