/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.SCMCommonPlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipelineProvider<REPLICATION_CONFIG extends ReplicationConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineProvider.class);
    private final NodeManager nodeManager;
    private final PipelineStateManager stateManager;

    public PipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager) {
        this.nodeManager = nodeManager;
        this.stateManager = stateManager;
    }

    public PipelineProvider() {
        this.nodeManager = null;
        this.stateManager = null;
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public PipelineStateManager getPipelineStateManager() {
        return this.stateManager;
    }

    protected abstract Pipeline create(REPLICATION_CONFIG var1) throws IOException;

    protected abstract Pipeline create(REPLICATION_CONFIG var1, List<DatanodeDetails> var2, List<DatanodeDetails> var3) throws IOException;

    protected abstract Pipeline create(REPLICATION_CONFIG var1, List<DatanodeDetails> var2);

    protected abstract Pipeline createForRead(REPLICATION_CONFIG var1, Set<ContainerReplica> var2);

    protected abstract void close(Pipeline var1) throws IOException;

    protected abstract void shutdown();

    List<DatanodeDetails> pickNodesNotUsed(REPLICATION_CONFIG replicationConfig, long metadataSizeRequired, long dataSizeRequired) throws SCMException {
        int nodesRequired = replicationConfig.getRequiredNodes();
        List<DatanodeDetails> healthyDNs = this.pickAllNodesNotUsed(replicationConfig);
        List<DatanodeDetails> healthyDNsWithSpace = healthyDNs.stream().filter(dn -> SCMCommonPlacementPolicy.hasEnoughSpace(dn, metadataSizeRequired, dataSizeRequired)).limit(nodesRequired).collect(Collectors.toList());
        if (healthyDNsWithSpace.size() < nodesRequired) {
            String msg = String.format("Unable to find enough nodes that meet the space requirement of %d bytes for metadata and %d bytes for data in healthy node set. Nodes required: %d Found: %d", metadataSizeRequired, dataSizeRequired, nodesRequired, healthyDNsWithSpace.size());
            LOG.warn(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_FIND_NODES_WITH_SPACE);
        }
        return healthyDNsWithSpace;
    }

    List<DatanodeDetails> pickNodesNotUsed(REPLICATION_CONFIG replicationConfig) throws SCMException {
        return this.pickAllNodesNotUsed(replicationConfig).stream().limit(replicationConfig.getRequiredNodes()).collect(Collectors.toList());
    }

    List<DatanodeDetails> pickAllNodesNotUsed(REPLICATION_CONFIG replicationConfig) throws SCMException {
        HashSet dnsUsed = new HashSet();
        this.stateManager.getPipelines((ReplicationConfig)replicationConfig).stream().filter(p -> p.getPipelineState().equals((Object)Pipeline.PipelineState.OPEN) || p.getPipelineState().equals((Object)Pipeline.PipelineState.DORMANT) || p.getPipelineState().equals((Object)Pipeline.PipelineState.ALLOCATED)).forEach(p -> dnsUsed.addAll(p.getNodes()));
        List<DatanodeDetails> dns = this.nodeManager.getNodes(NodeStatus.inServiceHealthy()).parallelStream().filter(dn -> !dnsUsed.contains(dn)).collect(Collectors.toList());
        if (dns.size() < replicationConfig.getRequiredNodes()) {
            String e = String.format("Cannot create pipeline %s using %d nodes. Used %d nodes. Healthy nodes %d", replicationConfig.toString(), dns.size(), dnsUsed.size(), this.nodeManager.getNodes(NodeStatus.inServiceHealthy()).size());
            throw new SCMException(e, SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        return dns;
    }
}

