/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.BlockingService;
import com.google.protobuf.ByteString;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ObjectName;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.ReconfigurableConfig;
import org.apache.hadoop.hdds.conf.ReconfigurationHandler;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.PipelineChoosePolicy;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.PlacementPolicyValidateProxy;
import org.apache.hadoop.hdds.scm.RemoveSCMRequest;
import org.apache.hadoop.hdds.scm.ScmConfig;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.block.BlockManager;
import org.apache.hadoop.hdds.scm.block.BlockManagerImpl;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLogImpl;
import org.apache.hadoop.hdds.scm.command.CommandStatusReportHandler;
import org.apache.hadoop.hdds.scm.container.CloseContainerEventHandler;
import org.apache.hadoop.hdds.scm.container.ContainerActionsHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerManagerImpl;
import org.apache.hadoop.hdds.scm.container.ContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.IncrementalContainerReportHandler;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancer;
import org.apache.hadoop.hdds.scm.container.balancer.MoveManager;
import org.apache.hadoop.hdds.scm.container.common.helpers.MoveDataNodePair;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicyFactory;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMMetrics;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaPendingOps;
import org.apache.hadoop.hdds.scm.container.replication.DatanodeCommandCountUpdatedHandler;
import org.apache.hadoop.hdds.scm.container.replication.LegacyReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.BackgroundSCMService;
import org.apache.hadoop.hdds.scm.ha.HASecurityUtils;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMHAManager;
import org.apache.hadoop.hdds.scm.ha.SCMHAManagerImpl;
import org.apache.hadoop.hdds.scm.ha.SCMHAMetrics;
import org.apache.hadoop.hdds.scm.ha.SCMHANodeDetails;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.ha.SCMNodeDetails;
import org.apache.hadoop.hdds.scm.ha.SCMNodeInfo;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServerImpl;
import org.apache.hadoop.hdds.scm.ha.SCMServiceException;
import org.apache.hadoop.hdds.scm.ha.SCMServiceManager;
import org.apache.hadoop.hdds.scm.ha.SequenceIdGenerator;
import org.apache.hadoop.hdds.scm.ha.StatefulServiceStateManager;
import org.apache.hadoop.hdds.scm.ha.StatefulServiceStateManagerImpl;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStoreImpl;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.node.DeadNodeHandler;
import org.apache.hadoop.hdds.scm.node.HealthyReadOnlyNodeHandler;
import org.apache.hadoop.hdds.scm.node.NewNodeHandler;
import org.apache.hadoop.hdds.scm.node.NodeAddressUpdateHandler;
import org.apache.hadoop.hdds.scm.node.NodeDecommissionManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeReportHandler;
import org.apache.hadoop.hdds.scm.node.ReadOnlyHealthyToHealthyNodeHandler;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.node.StaleNodeHandler;
import org.apache.hadoop.hdds.scm.node.StartDatanodeAdminHandler;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineActionHandler;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManagerImpl;
import org.apache.hadoop.hdds.scm.pipeline.PipelineReportHandler;
import org.apache.hadoop.hdds.scm.pipeline.WritableContainerFactory;
import org.apache.hadoop.hdds.scm.pipeline.choose.algorithms.PipelineChoosePolicyFactory;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.security.CRLStatusReportHandler;
import org.apache.hadoop.hdds.scm.security.RootCARotationManager;
import org.apache.hadoop.hdds.scm.security.SecretKeyManagerService;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.scm.server.SCMBlockProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMCertStore;
import org.apache.hadoop.hdds.scm.server.SCMClientProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMConfigurator;
import org.apache.hadoop.hdds.scm.server.SCMContainerMetrics;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMMXBean;
import org.apache.hadoop.hdds.scm.server.SCMSecurityProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.scm.server.StorageContainerManagerHttpServer;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationManager;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationManagerImpl;
import org.apache.hadoop.hdds.scm.server.upgrade.SCMUpgradeFinalizationContext;
import org.apache.hadoop.hdds.scm.server.upgrade.ScmHAUnfinalizedStateValidationAction;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyManager;
import org.apache.hadoop.hdds.security.symmetric.SecretKeySignerClient;
import org.apache.hadoop.hdds.security.token.ContainerTokenGenerator;
import org.apache.hadoop.hdds.security.token.ContainerTokenSecretManager;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CAType;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateServer;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.security.x509.certificate.authority.DefaultCAServer;
import org.apache.hadoop.hdds.security.x509.certificate.authority.profile.DefaultCAProfile;
import org.apache.hadoop.hdds.security.x509.certificate.authority.profile.DefaultProfile;
import org.apache.hadoop.hdds.security.x509.certificate.authority.profile.PKIProfile;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.SCMCertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.server.OzoneAdmins;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.server.ServiceRuntimeInfoImpl;
import org.apache.hadoop.hdds.server.events.EventExecutor;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.FixedThreadPoolWithAffinityExecutor;
import org.apache.hadoop.hdds.server.http.RatisDropwizardExports;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.HddsVersionInfo;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.LegacyHadoopConfigurationSource;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.TableMapping;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.apache.hadoop.ozone.lease.LeaseManagerNotRunningException;
import org.apache.hadoop.ozone.upgrade.DefaultUpgradeFinalizationExecutor;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizationExecutor;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.JvmPauseMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "CBLOCK", "OZONE", "HBASE"})
public final class StorageContainerManager
extends ServiceRuntimeInfoImpl
implements SCMMXBean,
OzoneStorageContainerManager {
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainerManager.class);
    private static SCMMetrics metrics;
    private SCMHAMetrics scmHAMetrics;
    private final SCMDatanodeProtocolServer datanodeProtocolServer;
    private final SCMBlockProtocolServer blockProtocolServer;
    private final SCMClientProtocolServer clientProtocolServer;
    private SCMSecurityProtocolServer securityProtocolServer;
    private NodeManager scmNodeManager;
    private PipelineManager pipelineManager;
    private ContainerManager containerManager;
    private BlockManager scmBlockManager;
    private final SCMStorageConfig scmStorageConfig;
    private NodeDecommissionManager scmDecommissionManager;
    private WritableContainerFactory writableContainerFactory;
    private FinalizationManager finalizationManager;
    private HDDSLayoutVersionManager scmLayoutVersionManager;
    private LeaseManager<Object> leaseManager;
    private SCMMetadataStore scmMetadataStore;
    private CertificateStore certificateStore;
    private SCMHAManager scmHAManager;
    private SCMContext scmContext;
    private SequenceIdGenerator sequenceIdGen;
    private final EventQueue eventQueue;
    private final SCMServiceManager serviceManager;
    private final ReconfigurationHandler reconfigurationHandler;
    private StorageContainerManagerHttpServer httpServer;
    private final String scmStarterUser;
    private final OzoneAdmins scmAdmins;
    private final OzoneAdmins scmReadOnlyAdmins;
    private ObjectName scmInfoBeanName;
    private ReplicationManager replicationManager;
    private SCMSafeModeManager scmSafeModeManager;
    private SCMCertificateClient scmCertificateClient;
    private RootCARotationManager rootCARotationManager;
    private ContainerTokenSecretManager containerTokenMgr;
    private final JvmPauseMonitor jvmPauseMonitor;
    private final OzoneConfiguration configuration;
    private SCMContainerMetrics scmContainerMetrics;
    private SCMContainerPlacementMetrics placementMetrics;
    private PlacementPolicy containerPlacementPolicy;
    private PlacementPolicy ecContainerPlacementPolicy;
    private PlacementPolicyValidateProxy placementPolicyValidateProxy;
    private MetricsSystem ms;
    private final Map<String, RatisDropwizardExports> ratisMetricsMap = new ConcurrentHashMap<String, RatisDropwizardExports>();
    private List<RatisDropwizardExports.MetricReporter> ratisReporterList = null;
    private final String primaryScmNodeId;
    private NetworkTopology clusterMap;
    private PipelineChoosePolicy pipelineChoosePolicy;
    private PipelineChoosePolicy ecPipelineChoosePolicy;
    private SecurityConfig securityConfig;
    private final SCMHANodeDetails scmHANodeDetails;
    private final String threadNamePrefix;
    private final ContainerBalancer containerBalancer;
    private final MoveManager moveManager;
    private StatefulServiceStateManager statefulServiceStateManager;
    private ContainerReplicaPendingOps containerReplicaPendingOps;
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final SecretKeyManagerService secretKeyManagerService;
    private Clock systemClock;
    private DNSToSwitchMapping dnsToSwitchMapping;

    @VisibleForTesting
    public StorageContainerManager(OzoneConfiguration conf) throws IOException, AuthenticationException {
        this(conf, new SCMConfigurator());
    }

    private StorageContainerManager(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException, AuthenticationException {
        super(HddsVersionInfo.HDDS_VERSION_INFO);
        Objects.requireNonNull(configurator, "configurator cannot not be null");
        Objects.requireNonNull(conf, "configuration cannot not be null");
        this.scmStorageConfig = new SCMStorageConfig(conf);
        this.scmHANodeDetails = SCMHANodeDetails.loadSCMHAConfig(conf, this.scmStorageConfig);
        this.configuration = conf;
        StorageContainerManager.initMetrics();
        boolean ratisEnabled = SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf);
        if (this.scmStorageConfig.getState() != Storage.StorageState.INITIALIZED) {
            String errMsg = "Please make sure you have run 'ozone scm --init' command to generate all the required metadata to " + this.scmStorageConfig.getStorageDir();
            if (ratisEnabled && !this.scmStorageConfig.isSCMHAEnabled()) {
                errMsg = errMsg + " or make sure you have run 'ozone scm --bootstrap' cmd to add the SCM to existing SCM HA group";
            }
            LOG.error(errMsg + ".");
            throw new SCMException("SCM not initialized due to storage config failure.", SCMException.ResultCodes.SCM_NOT_INITIALIZED);
        }
        this.threadNamePrefix = this.getScmNodeDetails().threadNamePrefix();
        this.primaryScmNodeId = this.scmStorageConfig.getPrimaryScmNodeId();
        JvmPauseMonitor jvmPauseMonitor = this.jvmPauseMonitor = !ratisEnabled ? RatisHelper.newJvmPauseMonitor((String)this.getScmId()) : null;
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            StorageContainerManager.loginAsSCMUserIfSecurityEnabled(this.scmHANodeDetails, (ConfigurationSource)conf);
        }
        this.initializeCertificateClient();
        this.initalizeMetadataStore(conf, configurator);
        this.eventQueue = new EventQueue(this.threadNamePrefix);
        this.serviceManager = new SCMServiceManager();
        this.reconfigurationHandler = new ReconfigurationHandler("SCM", conf, this::checkAdminAccess).register("ozone.administrators", this::reconfOzoneAdmins).register("ozone.readonly.administrators", this::reconfOzoneReadOnlyAdmins);
        this.initializeSystemManagers(conf, configurator);
        if (SecretKeyManagerService.isSecretKeyEnable(this.securityConfig)) {
            this.secretKeyManagerService = new SecretKeyManagerService(this.scmContext, (ConfigurationSource)conf, this.scmHAManager.getRatisServer());
            if (!ratisEnabled) {
                this.secretKeyManagerService.getSecretKeyManager().checkAndInitialize();
            }
            this.serviceManager.register(this.secretKeyManagerService);
        } else {
            this.secretKeyManagerService = null;
        }
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            this.initializeCAnSecurityProtocol(conf, configurator);
        } else {
            this.securityProtocolServer = null;
        }
        this.scmStarterUser = UserGroupInformation.getCurrentUser().getShortUserName();
        this.scmAdmins = OzoneAdmins.getOzoneAdmins((String)this.scmStarterUser, (OzoneConfiguration)conf);
        this.scmReadOnlyAdmins = OzoneAdmins.getReadonlyAdmins((OzoneConfiguration)conf);
        LOG.info("SCM start with adminUsers: {}", (Object)this.scmAdmins.getAdminUsernames());
        this.datanodeProtocolServer = new SCMDatanodeProtocolServer(conf, this, (EventPublisher)this.eventQueue, this.scmContext);
        this.blockProtocolServer = new SCMBlockProtocolServer(conf, this);
        this.clientProtocolServer = new SCMClientProtocolServer(conf, this, this.reconfigurationHandler);
        this.initializeEventHandlers();
        this.moveManager = new MoveManager(this.replicationManager, this.containerManager);
        this.containerReplicaPendingOps.registerSubscriber(this.moveManager);
        this.containerBalancer = new ContainerBalancer(this);
        LOG.info(this.containerBalancer.toString());
        this.scmSafeModeManager.emitSafeModeStatus();
        this.registerMXBean();
        this.registerMetricsSource(this);
    }

    private void initializeEventHandlers() {
        long timeDuration = this.configuration.getTimeDuration("ozone.scm.close.container.wait.duration", OzoneConfigKeys.OZONE_SCM_CLOSE_CONTAINER_WAIT_DURATION_DEFAULT.getDuration(), TimeUnit.MILLISECONDS);
        CloseContainerEventHandler closeContainerHandler = new CloseContainerEventHandler(this.pipelineManager, this.containerManager, this.scmContext, this.leaseManager, timeDuration);
        NodeReportHandler nodeReportHandler = new NodeReportHandler(this.scmNodeManager);
        PipelineReportHandler pipelineReportHandler = new PipelineReportHandler(this.scmSafeModeManager, this.pipelineManager, this.scmContext, (ConfigurationSource)this.configuration);
        CommandStatusReportHandler cmdStatusReportHandler = new CommandStatusReportHandler();
        NewNodeHandler newNodeHandler = new NewNodeHandler(this.pipelineManager, this.scmDecommissionManager, (ConfigurationSource)this.configuration, this.serviceManager);
        NodeAddressUpdateHandler nodeAddressUpdateHandler = new NodeAddressUpdateHandler(this.pipelineManager, this.scmDecommissionManager, this.serviceManager);
        StaleNodeHandler staleNodeHandler = new StaleNodeHandler(this.scmNodeManager, this.pipelineManager, this.configuration);
        DeadNodeHandler deadNodeHandler = new DeadNodeHandler(this.scmNodeManager, this.pipelineManager, this.containerManager);
        StartDatanodeAdminHandler datanodeStartAdminHandler = new StartDatanodeAdminHandler(this.scmNodeManager, this.pipelineManager);
        ReadOnlyHealthyToHealthyNodeHandler readOnlyHealthyToHealthyNodeHandler = new ReadOnlyHealthyToHealthyNodeHandler(this.configuration, this.serviceManager);
        HealthyReadOnlyNodeHandler healthyReadOnlyNodeHandler = new HealthyReadOnlyNodeHandler(this.scmNodeManager, this.pipelineManager);
        ContainerActionsHandler actionsHandler = new ContainerActionsHandler();
        ContainerReportHandler containerReportHandler = new ContainerReportHandler(this.scmNodeManager, this.containerManager, this.scmContext, this.configuration);
        IncrementalContainerReportHandler incrementalContainerReportHandler = new IncrementalContainerReportHandler(this.scmNodeManager, this.containerManager, this.scmContext);
        PipelineActionHandler pipelineActionHandler = new PipelineActionHandler(this.pipelineManager, this.scmContext, this.configuration);
        CRLStatusReportHandler crlStatusReportHandler = new CRLStatusReportHandler(this.certificateStore, this.configuration);
        this.eventQueue.addHandler(SCMEvents.DATANODE_COMMAND, (EventHandler)this.scmNodeManager);
        this.eventQueue.addHandler(SCMEvents.RETRIABLE_DATANODE_COMMAND, (EventHandler)this.scmNodeManager);
        this.eventQueue.addHandler(SCMEvents.NODE_REPORT, (EventHandler)nodeReportHandler);
        this.eventQueue.addHandler(SCMEvents.DATANODE_COMMAND_COUNT_UPDATED, (EventHandler)new DatanodeCommandCountUpdatedHandler(this.replicationManager));
        long waitQueueThreshold = this.configuration.getInt(ScmUtils.getContainerReportConfPrefix() + ".queue.wait.threshold", 60000);
        long execWaitThreshold = this.configuration.getInt(ScmUtils.getContainerReportConfPrefix() + ".execute.wait.threshold", 120000);
        List<BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>> queues = ScmUtils.initContainerReportQueue(this.configuration);
        List executors = FixedThreadPoolWithAffinityExecutor.initializeExecutorPool((String)this.threadNamePrefix, queues);
        ConcurrentHashMap reportExecutorMap = new ConcurrentHashMap();
        FixedThreadPoolWithAffinityExecutor containerReportExecutors = new FixedThreadPoolWithAffinityExecutor(EventQueue.getExecutorName(SCMEvents.CONTAINER_REPORT, (EventHandler)containerReportHandler), (EventHandler)containerReportHandler, queues, (EventPublisher)this.eventQueue, SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode.class, executors, reportExecutorMap);
        containerReportExecutors.setQueueWaitThreshold(waitQueueThreshold);
        containerReportExecutors.setExecWaitThreshold(execWaitThreshold);
        FixedThreadPoolWithAffinityExecutor incrementalReportExecutors = new FixedThreadPoolWithAffinityExecutor(EventQueue.getExecutorName(SCMEvents.INCREMENTAL_CONTAINER_REPORT, (EventHandler)incrementalContainerReportHandler), (EventHandler)incrementalContainerReportHandler, queues, (EventPublisher)this.eventQueue, SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode.class, executors, reportExecutorMap);
        incrementalReportExecutors.setQueueWaitThreshold(waitQueueThreshold);
        incrementalReportExecutors.setExecWaitThreshold(execWaitThreshold);
        this.eventQueue.addHandler(SCMEvents.CONTAINER_REPORT, (EventExecutor)containerReportExecutors, (EventHandler)containerReportHandler);
        this.eventQueue.addHandler(SCMEvents.INCREMENTAL_CONTAINER_REPORT, (EventExecutor)incrementalReportExecutors, (EventHandler)incrementalContainerReportHandler);
        this.eventQueue.addHandler(SCMEvents.CONTAINER_ACTIONS, (EventHandler)actionsHandler);
        this.eventQueue.addHandler(SCMEvents.CLOSE_CONTAINER, (EventHandler)closeContainerHandler);
        this.eventQueue.addHandler(SCMEvents.NEW_NODE, (EventHandler)newNodeHandler);
        this.eventQueue.addHandler(SCMEvents.NODE_ADDRESS_UPDATE, (EventHandler)nodeAddressUpdateHandler);
        this.eventQueue.addHandler(SCMEvents.STALE_NODE, (EventHandler)staleNodeHandler);
        this.eventQueue.addHandler(SCMEvents.HEALTHY_READONLY_TO_HEALTHY_NODE, (EventHandler)readOnlyHealthyToHealthyNodeHandler);
        this.eventQueue.addHandler(SCMEvents.HEALTHY_READONLY_NODE, (EventHandler)healthyReadOnlyNodeHandler);
        this.eventQueue.addHandler(SCMEvents.DEAD_NODE, (EventHandler)deadNodeHandler);
        this.eventQueue.addHandler(SCMEvents.START_ADMIN_ON_NODE, (EventHandler)datanodeStartAdminHandler);
        this.eventQueue.addHandler(SCMEvents.CMD_STATUS_REPORT, (EventHandler)cmdStatusReportHandler);
        this.eventQueue.addHandler(SCMEvents.DELETE_BLOCK_STATUS, (EventHandler)((DeletedBlockLogImpl)this.scmBlockManager.getDeletedBlockLog()));
        this.eventQueue.addHandler(SCMEvents.PIPELINE_ACTIONS, (EventHandler)pipelineActionHandler);
        this.eventQueue.addHandler(SCMEvents.PIPELINE_REPORT, (EventHandler)pipelineReportHandler);
        this.eventQueue.addHandler(SCMEvents.CRL_STATUS_REPORT, (EventHandler)crlStatusReportHandler);
    }

    private void initializeCertificateClient() throws IOException {
        this.securityConfig = new SecurityConfig((ConfigurationSource)this.configuration);
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)this.configuration) && this.scmStorageConfig.checkPrimarySCMIdInitialized()) {
            SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient = HddsServerUtil.getScmSecurityClientWithMaxRetry((OzoneConfiguration)this.configuration, (UserGroupInformation)UserGroupInformation.getCurrentUser());
            this.scmCertificateClient = new SCMCertificateClient(this.securityConfig, scmSecurityClient, this.scmStorageConfig.getScmId(), this.scmStorageConfig.getClusterID(), this.scmStorageConfig.getScmCertSerialId(), StorageContainerManager.getScmAddress(this.scmHANodeDetails, (ConfigurationSource)this.configuration).getHostName());
        }
    }

    public OzoneConfiguration getConfiguration() {
        return this.configuration;
    }

    public static StorageContainerManager createSCM(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException, AuthenticationException {
        return new StorageContainerManager(conf, configurator);
    }

    public static StorageContainerManager createSCM(OzoneConfiguration conf) throws IOException, AuthenticationException {
        return StorageContainerManager.createSCM(conf, new SCMConfigurator());
    }

    private void initializeSystemManagers(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException {
        this.systemClock = Clock.system(ZoneOffset.UTC);
        this.clusterMap = configurator.getNetworkTopology() != null ? configurator.getNetworkTopology() : new NetworkTopologyImpl((ConfigurationSource)conf);
        this.ratisReporterList = RatisDropwizardExports.registerRatisMetricReporters(this.ratisMetricsMap, this.isStopped::get);
        this.scmHAManager = configurator.getSCMHAManager() != null ? configurator.getSCMHAManager() : new SCMHAManagerImpl((ConfigurationSource)conf, this.securityConfig, this);
        if (configurator.getLeaseManager() != null) {
            this.leaseManager = configurator.getLeaseManager();
        } else {
            long timeDuration = conf.getTimeDuration("ozone.scm.close.container.wait.duration", OzoneConfigKeys.OZONE_SCM_CLOSE_CONTAINER_WAIT_DURATION_DEFAULT.getDuration(), TimeUnit.MILLISECONDS);
            this.leaseManager = new LeaseManager(this.threadNamePrefix, timeDuration);
        }
        this.scmLayoutVersionManager = new HDDSLayoutVersionManager(this.scmStorageConfig.getLayoutVersion());
        DefaultUpgradeFinalizationExecutor finalizationExecutor = configurator.getUpgradeFinalizationExecutor() != null ? configurator.getUpgradeFinalizationExecutor() : new DefaultUpgradeFinalizationExecutor();
        this.finalizationManager = new FinalizationManagerImpl.Builder().setConfiguration(conf).setLayoutVersionManager(this.scmLayoutVersionManager).setStorage(this.scmStorageConfig).setHAManager(this.scmHAManager).setFinalizationStore((Table<String, String>)this.scmMetadataStore.getMetaTable()).setFinalizationExecutor((UpgradeFinalizationExecutor<SCMUpgradeFinalizationContext>)finalizationExecutor).build();
        SequenceIdGenerator.upgradeToSequenceId(this.scmMetadataStore);
        this.sequenceIdGen = new SequenceIdGenerator((ConfigurationSource)conf, this.scmHAManager, (Table<String, Long>)this.scmMetadataStore.getSequenceIdTable());
        if (configurator.getScmContext() != null) {
            this.scmContext = configurator.getScmContext();
        } else {
            long term = SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf) ? 0L : -1L;
            this.scmContext = new SCMContext.Builder().setLeader(false).setTerm(term).setIsInSafeMode(true).setIsPreCheckComplete(false).setSCM(this).setThreadNamePrefix(this.threadNamePrefix).setFinalizationCheckpoint(this.finalizationManager.getCheckpoint()).build();
        }
        Class dnsToSwitchMappingClass = conf.getClass("net.topology.node.switch.mapping.impl", TableMapping.class, DNSToSwitchMapping.class);
        DNSToSwitchMapping newInstance = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)dnsToSwitchMappingClass, (Configuration)conf);
        this.dnsToSwitchMapping = newInstance instanceof CachedDNSToSwitchMapping ? newInstance : new CachedDNSToSwitchMapping(newInstance);
        this.scmNodeManager = configurator.getScmNodeManager() != null ? configurator.getScmNodeManager() : new SCMNodeManager(conf, this.scmStorageConfig, (EventPublisher)this.eventQueue, this.clusterMap, this.scmContext, this.scmLayoutVersionManager, this::resolveNodeLocation);
        this.placementMetrics = SCMContainerPlacementMetrics.create();
        this.containerPlacementPolicy = ContainerPlacementPolicyFactory.getPolicy((ConfigurationSource)conf, this.scmNodeManager, this.clusterMap, true, this.placementMetrics);
        this.ecContainerPlacementPolicy = ContainerPlacementPolicyFactory.getECPolicy((ConfigurationSource)conf, this.scmNodeManager, this.clusterMap, true, this.placementMetrics);
        this.placementPolicyValidateProxy = new PlacementPolicyValidateProxy(this.containerPlacementPolicy, this.ecContainerPlacementPolicy);
        this.pipelineManager = configurator.getPipelineManager() != null ? configurator.getPipelineManager() : PipelineManagerImpl.newPipelineManager((ConfigurationSource)conf, this.scmHAManager, this.scmNodeManager, (Table<PipelineID, Pipeline>)this.scmMetadataStore.getPipelineTable(), (EventPublisher)this.eventQueue, this.scmContext, this.serviceManager, this.systemClock);
        this.finalizationManager.buildUpgradeContext(this.scmNodeManager, this.pipelineManager, this.scmContext);
        this.containerReplicaPendingOps = new ContainerReplicaPendingOps(this.systemClock);
        long containerReplicaOpScrubberIntervalMs = conf.getTimeDuration("ozone.scm.expired.container.replica.op.scrub.interval", "5m", TimeUnit.MILLISECONDS);
        long backgroundServiceSafemodeWaitMs = conf.getTimeDuration("hdds.scm.wait.time.after.safemode.exit", "5m", TimeUnit.MILLISECONDS);
        String backgroundServiceName = "ExpiredContainerReplicaOpScrubber";
        BackgroundSCMService expiredContainerReplicaOpScrubber = new BackgroundSCMService.Builder().setClock(this.systemClock).setScmContext(this.scmContext).setServiceName("ExpiredContainerReplicaOpScrubber").setIntervalInMillis(containerReplicaOpScrubberIntervalMs).setWaitTimeInMillis(backgroundServiceSafemodeWaitMs).setPeriodicalTask(() -> this.containerReplicaPendingOps.removeExpiredEntries()).build();
        this.serviceManager.register(expiredContainerReplicaOpScrubber);
        this.containerManager = configurator.getContainerManager() != null ? configurator.getContainerManager() : new ContainerManagerImpl((Configuration)conf, this.scmHAManager, this.sequenceIdGen, this.pipelineManager, (Table<ContainerID, ContainerInfo>)this.scmMetadataStore.getContainerTable(), this.containerReplicaPendingOps);
        ScmConfig scmConfig = (ScmConfig)conf.getObject(ScmConfig.class);
        this.pipelineChoosePolicy = PipelineChoosePolicyFactory.getPolicy(scmConfig, false);
        this.ecPipelineChoosePolicy = PipelineChoosePolicyFactory.getPolicy(scmConfig, true);
        this.writableContainerFactory = configurator.getWritableContainerFactory() != null ? configurator.getWritableContainerFactory() : new WritableContainerFactory(this);
        this.scmBlockManager = configurator.getScmBlockManager() != null ? configurator.getScmBlockManager() : new BlockManagerImpl((ConfigurationSource)conf, scmConfig, this);
        if (configurator.getReplicationManager() != null) {
            this.replicationManager = configurator.getReplicationManager();
        } else {
            LegacyReplicationManager legacyRM = new LegacyReplicationManager((ConfigurationSource)conf, this.containerManager, this.containerPlacementPolicy, (EventPublisher)this.eventQueue, this.scmContext, this.scmNodeManager, this.scmHAManager, this.systemClock, (Table<ContainerID, MoveDataNodePair>)this.getScmMetadataStore().getMoveTable());
            this.replicationManager = new ReplicationManager((ConfigurationSource)conf, this.containerManager, this.containerPlacementPolicy, this.ecContainerPlacementPolicy, (EventPublisher)this.eventQueue, this.scmContext, this.scmNodeManager, this.systemClock, legacyRM, this.containerReplicaPendingOps);
            this.reconfigurationHandler.register((ReconfigurableConfig)this.replicationManager.getConfig());
        }
        this.serviceManager.register(this.replicationManager);
        this.scmSafeModeManager = configurator.getScmSafeModeManager() != null ? configurator.getScmSafeModeManager() : new SCMSafeModeManager((ConfigurationSource)conf, this.containerManager.getContainers(), this.containerManager, this.pipelineManager, this.eventQueue, this.serviceManager, this.scmContext);
        this.scmDecommissionManager = new NodeDecommissionManager(conf, this.scmNodeManager, this.containerManager, this.scmContext, (EventPublisher)this.eventQueue, this.replicationManager);
        this.statefulServiceStateManager = StatefulServiceStateManagerImpl.newBuilder().setStatefulServiceConfig((Table<String, ByteString>)this.scmMetadataStore.getStatefulServiceConfigTable()).setSCMDBTransactionBuffer(this.scmHAManager.getDBTransactionBuffer()).setRatisServer(this.scmHAManager.getRatisServer()).build();
    }

    private void initializeCAnSecurityProtocol(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException {
        CertificateServer rootCertificateServer;
        CertificateServer scmCertificateServer;
        if (this.scmMetadataStore == null) {
            LOG.error("Cannot initialize Certificate Server without a valid meta data layer.");
            throw new SCMException("Cannot initialize CA without a valid metadata store", SCMException.ResultCodes.SCM_NOT_INITIALIZED);
        }
        this.certificateStore = new SCMCertStore.Builder().setMetadaStore(this.scmMetadataStore).setRatisServer(this.scmHAManager.getRatisServer()).setCRLSequenceId(this.getLastSequenceIdForCRL()).build();
        String subject = "scm-sub@" + InetAddress.getLocalHost().getHostName();
        if (configurator.getCertificateServer() != null) {
            scmCertificateServer = configurator.getCertificateServer();
        } else {
            scmCertificateServer = new DefaultCAServer(subject, this.scmStorageConfig.getClusterID(), this.scmStorageConfig.getScmId(), this.certificateStore, null, (PKIProfile)new DefaultCAProfile(), this.scmCertificateClient.getComponentName());
            scmCertificateServer.init(new SecurityConfig((ConfigurationSource)this.configuration), CAType.SUBORDINATE);
        }
        if (this.scmStorageConfig.checkPrimarySCMIdInitialized()) {
            if (this.primaryScmNodeId.equals(this.scmStorageConfig.getScmId())) {
                rootCertificateServer = configurator.getCertificateServer() != null ? configurator.getCertificateServer() : HASecurityUtils.initializeRootCertificateServer(this.securityConfig, this.certificateStore, this.scmStorageConfig, (PKIProfile)new DefaultCAProfile());
                this.persistPrimarySCMCerts();
            } else {
                rootCertificateServer = null;
            }
        } else {
            rootCertificateServer = HASecurityUtils.initializeRootCertificateServer(this.securityConfig, this.certificateStore, this.scmStorageConfig, (PKIProfile)new DefaultProfile());
        }
        SecretKeyManager secretKeyManager = this.secretKeyManagerService != null ? this.secretKeyManagerService.getSecretKeyManager() : null;
        this.securityProtocolServer = new SCMSecurityProtocolServer(conf, rootCertificateServer, scmCertificateServer, (CertificateClient)this.scmCertificateClient, this, secretKeyManager);
        if (this.securityConfig.isContainerTokenEnabled()) {
            this.containerTokenMgr = this.createContainerTokenSecretManager();
        }
        if (this.securityConfig.isAutoCARotationEnabled()) {
            this.rootCARotationManager = new RootCARotationManager(this);
        }
    }

    private void persistPrimarySCMCerts() throws IOException {
        X509Certificate rootCACert;
        BigInteger certSerial = this.scmCertificateClient.getCertificate().getSerialNumber();
        if (this.certificateStore.getCertificateByID(certSerial, CertificateStore.CertType.VALID_CERTS) == null) {
            LOG.info("Storing sub-ca certificate serialId {} on primary SCM", (Object)certSerial);
            this.certificateStore.storeValidScmCertificate(certSerial, this.scmCertificateClient.getCertificate());
        }
        if (this.certificateStore.getCertificateByID((rootCACert = this.scmCertificateClient.getCACertificate()).getSerialNumber(), CertificateStore.CertType.VALID_CERTS) == null) {
            LOG.info("Storing root certificate serialId {}", (Object)rootCACert.getSerialNumber());
            this.certificateStore.storeValidScmCertificate(rootCACert.getSerialNumber(), rootCACert);
        }
        SequenceIdGenerator.upgradeToCertificateSequenceId(this.scmMetadataStore, true);
    }

    public CertificateServer getRootCertificateServer() {
        return this.getSecurityProtocolServer().getRootCertificateServer();
    }

    public CertificateServer getScmCertificateServer() {
        return this.getSecurityProtocolServer().getScmCertificateServer();
    }

    public CertificateClient getScmCertificateClient() {
        return this.scmCertificateClient;
    }

    public Clock getSystemClock() {
        return this.systemClock;
    }

    private ContainerTokenSecretManager createContainerTokenSecretManager() throws IOException {
        long expiryTime = this.securityConfig.getBlockTokenExpiryDurationMs();
        if (this.scmCertificateClient == null) {
            String certSerialNumber;
            Preconditions.checkState((!this.scmStorageConfig.checkPrimarySCMIdInitialized() ? 1 : 0) != 0);
            try {
                certSerialNumber = this.getScmCertificateServer().getCACertificate().getSerialNumber().toString();
            }
            catch (CertificateException ex) {
                LOG.error("Get CA Certificate failed", (Throwable)ex);
                throw new IOException(ex);
            }
            catch (IOException ex) {
                LOG.error("Get CA Certificate failed", (Throwable)ex);
                throw ex;
            }
            SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient = HddsServerUtil.getScmSecurityClientWithMaxRetry((OzoneConfiguration)this.configuration, (UserGroupInformation)UserGroupInformation.getCurrentUser());
            this.scmCertificateClient = new SCMCertificateClient(this.securityConfig, scmSecurityClient, certSerialNumber, this.getScmId(), OzoneConsts.SCM_ROOT_CA_COMPONENT_NAME);
        }
        return new ContainerTokenSecretManager(expiryTime, (SecretKeySignerClient)this.secretKeyManagerService.getSecretKeyManager());
    }

    private void initalizeMetadataStore(OzoneConfiguration conf, SCMConfigurator configurator) throws IOException {
        this.scmMetadataStore = configurator.getMetadataStore() != null ? configurator.getMetadataStore() : new SCMMetadataStoreImpl(conf);
    }

    private static void loginAsSCMUserIfSecurityEnabled(SCMHANodeDetails scmhaNodeDetails, ConfigurationSource conf) throws IOException, AuthenticationException {
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            Configuration hadoopConf;
            if (LOG.isDebugEnabled()) {
                ScmConfig scmConfig = (ScmConfig)conf.getObject(ScmConfig.class);
                LOG.debug("Ozone security is enabled. Attempting login for SCM user. Principal: {}, keytab: {}", (Object)scmConfig.getKerberosPrincipal(), (Object)scmConfig.getKerberosKeytab());
            }
            if (!SecurityUtil.getAuthenticationMethod((Configuration)(hadoopConf = LegacyHadoopConfigurationSource.asHadoopConfiguration((ConfigurationSource)conf))).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                throw new AuthenticationException(SecurityUtil.getAuthenticationMethod((Configuration)hadoopConf) + " authentication method not support. SCM user login failed.");
            }
            UserGroupInformation.setConfiguration((Configuration)hadoopConf);
            InetSocketAddress socketAddress = StorageContainerManager.getScmAddress(scmhaNodeDetails, conf);
            SecurityUtil.login((Configuration)hadoopConf, (String)"hdds.scm.kerberos.keytab.file", (String)"hdds.scm.kerberos.principal", (String)socketAddress.getHostName());
            LOG.info("SCM login successful.");
        }
    }

    long getLastSequenceIdForCRL() throws IOException {
        Long sequenceId = (Long)this.scmMetadataStore.getCRLSequenceIdTable().get((Object)"CRL_SEQUENCE_ID");
        if (sequenceId == null) {
            return 0L;
        }
        return sequenceId;
    }

    public static String buildRpcServerStartMessage(String description, InetSocketAddress addr) {
        return addr != null ? String.format("%s is listening at %s", description, addr) : String.format("%s not started", description);
    }

    public static RPC.Server startRpcServer(OzoneConfiguration conf, InetSocketAddress addr, Class<?> protocol, BlockingService instance, int handlerCount) throws IOException {
        RPC.Server rpcServer = (RPC.Server)HddsUtils.preserveThreadName(() -> new RPC.Builder((Configuration)conf).setProtocol(protocol).setInstance((Object)instance).setBindAddress(addr.getHostString()).setPort(addr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager(null).build());
        HddsServerUtil.addPBProtocol((Configuration)conf, protocol, (BlockingService)instance, (RPC.Server)rpcServer);
        return rpcServer;
    }

    public static boolean scmBootstrap(OzoneConfiguration conf) throws AuthenticationException, IOException {
        if (!SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf)) {
            LOG.error("Bootstrap is not supported without SCM HA.");
            return false;
        }
        String primordialSCM = SCMHAUtils.getPrimordialSCM((ConfigurationSource)conf);
        SCMStorageConfig scmStorageConfig = new SCMStorageConfig(conf);
        SCMHANodeDetails scmhaNodeDetails = SCMHANodeDetails.loadSCMHAConfig(conf, scmStorageConfig);
        String selfNodeId = scmhaNodeDetails.getLocalNodeDetails().getNodeId();
        String selfHostName = scmhaNodeDetails.getLocalNodeDetails().getHostName();
        if (primordialSCM != null && SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf) && SCMHAUtils.isPrimordialSCM((ConfigurationSource)conf, (String)selfNodeId, (String)selfHostName)) {
            LOG.info("SCM bootstrap command can only be executed in non-Primordial SCM {}, self id {} Ignoring it.", (Object)primordialSCM, (Object)selfNodeId);
            return true;
        }
        StorageContainerManager.loginAsSCMUserIfSecurityEnabled(scmhaNodeDetails, (ConfigurationSource)conf);
        String persistedClusterId = scmStorageConfig.getClusterID();
        Storage.StorageState state = scmStorageConfig.getState();
        if (state == Storage.StorageState.INITIALIZED && conf.getBoolean("ozone.scm.skip.bootstrap.validation", false)) {
            LOG.info("Skipping clusterId validation during bootstrap command.  ClusterId id {}, SCM id {}", (Object)persistedClusterId, (Object)scmStorageConfig.getScmId());
            StorageContainerManager.initializeSecurityIfNeeded(conf, scmStorageConfig, selfHostName, false);
            return true;
        }
        OzoneConfiguration config = SCMHAUtils.removeSelfId((OzoneConfiguration)conf, (String)scmhaNodeDetails.getLocalNodeDetails().getNodeId());
        ScmInfo scmInfo = HAUtils.getScmInfo((OzoneConfiguration)config);
        String fetchedId = scmInfo.getClusterId();
        Preconditions.checkNotNull((Object)fetchedId);
        if (state == Storage.StorageState.INITIALIZED) {
            Preconditions.checkNotNull((Object)scmStorageConfig.getScmId());
            if (!fetchedId.equals(persistedClusterId)) {
                LOG.error("Could not bootstrap as SCM is already initialized with cluster id {} but cluster id for existing leader SCM instance is {}", (Object)persistedClusterId, (Object)fetchedId);
                return false;
            }
            StorageContainerManager.initializeSecurityIfNeeded(conf, scmStorageConfig, selfHostName, false);
        } else {
            try {
                scmStorageConfig.setClusterId(fetchedId);
                if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
                    HASecurityUtils.initializeSecurity(scmStorageConfig, config, selfHostName, false);
                }
                scmStorageConfig.setPrimaryScmNodeId(scmInfo.getScmId());
                scmStorageConfig.setSCMHAFlag(true);
                scmStorageConfig.initialize();
                LOG.info("SCM BootStrap  is successful for ClusterID {}, SCMID {}", (Object)scmInfo.getClusterId(), (Object)scmStorageConfig.getScmId());
                LOG.info("Primary SCM Node ID {}", (Object)scmStorageConfig.getPrimaryScmNodeId());
            }
            catch (IOException ioe) {
                LOG.error("Could not initialize SCM version file", (Throwable)ioe);
                return false;
            }
        }
        return true;
    }

    private static void initializeSecurityIfNeeded(OzoneConfiguration conf, SCMStorageConfig scmStorageConfig, String scmHostname, boolean isPrimordial) throws IOException {
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf) && scmStorageConfig.getScmCertSerialId() == null) {
            HASecurityUtils.initializeSecurity(scmStorageConfig, conf, scmHostname, isPrimordial);
            scmStorageConfig.forceInitialize();
            LOG.info("SCM unsecure cluster is converted to secure cluster. Persisted SCM Certificate SerialID {}", (Object)scmStorageConfig.getScmCertSerialId());
        }
    }

    public static boolean scmInit(OzoneConfiguration conf, String clusterId) throws IOException {
        SCMStorageConfig scmStorageConfig = new SCMStorageConfig(conf);
        Storage.StorageState state = scmStorageConfig.getState();
        SCMHANodeDetails haDetails = SCMHANodeDetails.loadSCMHAConfig(conf, scmStorageConfig);
        String primordialSCM = SCMHAUtils.getPrimordialSCM((ConfigurationSource)conf);
        String selfNodeId = haDetails.getLocalNodeDetails().getNodeId();
        String selfHostName = haDetails.getLocalNodeDetails().getHostName();
        if (primordialSCM != null && SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf) && !SCMHAUtils.isPrimordialSCM((ConfigurationSource)conf, (String)selfNodeId, (String)selfHostName)) {
            LOG.info("SCM init command can only be executed in Primordial SCM {}, self id {} Ignoring it.", (Object)primordialSCM, (Object)selfNodeId);
            return true;
        }
        if (state != Storage.StorageState.INITIALIZED) {
            try {
                if (clusterId != null && !clusterId.isEmpty()) {
                    Preconditions.checkNotNull((Object)UUID.fromString(clusterId));
                    scmStorageConfig.setClusterId(clusterId);
                }
                if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
                    HASecurityUtils.initializeSecurity(scmStorageConfig, conf, StorageContainerManager.getScmAddress(haDetails, (ConfigurationSource)conf).getHostName(), true);
                }
                scmStorageConfig.setPrimaryScmNodeId(scmStorageConfig.getScmId());
                scmStorageConfig.initialize();
                if (SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf)) {
                    SCMRatisServerImpl.initialize(scmStorageConfig.getClusterID(), scmStorageConfig.getScmId(), haDetails.getLocalNodeDetails(), conf);
                    scmStorageConfig = new SCMStorageConfig(conf);
                    scmStorageConfig.setSCMHAFlag(true);
                    scmStorageConfig.forceInitialize();
                }
                LOG.info("SCM initialization succeeded. Current cluster id for sd={}; cid={}; layoutVersion={}; scmId={}", new Object[]{scmStorageConfig.getStorageDir(), scmStorageConfig.getClusterID(), scmStorageConfig.getLayoutVersion(), scmStorageConfig.getScmId()});
                return true;
            }
            catch (IOException ioe) {
                LOG.error("Could not initialize SCM version file", (Throwable)ioe);
                return false;
            }
        }
        ScmHAUnfinalizedStateValidationAction.checkScmHA(conf, scmStorageConfig, (LayoutVersionManager)new HDDSLayoutVersionManager(scmStorageConfig.getLayoutVersion()));
        clusterId = scmStorageConfig.getClusterID();
        boolean isSCMHAEnabled = scmStorageConfig.isSCMHAEnabled();
        StorageContainerManager.initializeSecurityIfNeeded(conf, scmStorageConfig, selfHostName, true);
        if (SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf) && !isSCMHAEnabled) {
            SCMRatisServerImpl.initialize(scmStorageConfig.getClusterID(), scmStorageConfig.getScmId(), haDetails.getLocalNodeDetails(), conf);
            scmStorageConfig.setSCMHAFlag(true);
            scmStorageConfig.setPrimaryScmNodeId(scmStorageConfig.getScmId());
            scmStorageConfig.forceInitialize();
            LOG.debug("Enabled SCM HA");
        }
        LOG.info("SCM already initialized. Reusing existing cluster id for sd={};cid={}; layoutVersion={}; HAEnabled={}", new Object[]{scmStorageConfig.getStorageDir(), clusterId, scmStorageConfig.getLayoutVersion(), scmStorageConfig.isSCMHAEnabled()});
        return true;
    }

    private static InetSocketAddress getScmAddress(SCMHANodeDetails haDetails, ConfigurationSource conf) throws IOException {
        List scmNodeInfoList = SCMNodeInfo.buildNodeInfo((ConfigurationSource)conf);
        Preconditions.checkNotNull((Object)scmNodeInfoList, (Object)"scmNodeInfoList is null");
        InetSocketAddress scmAddress = null;
        if (SCMHAUtils.getScmServiceId((ConfigurationSource)conf) != null) {
            for (SCMNodeInfo scmNodeInfo : scmNodeInfoList) {
                if (haDetails.getLocalNodeDetails().getNodeId() == null || !haDetails.getLocalNodeDetails().getNodeId().equals(scmNodeInfo.getNodeId())) continue;
                scmAddress = NetUtils.createSocketAddr((String)scmNodeInfo.getBlockClientAddress());
            }
        } else if (((SCMNodeInfo)scmNodeInfoList.get(0)).getBlockClientAddress() == null) {
            LOG.error("SCM Address not able to figure out from config, finding hostname from InetAddress.");
            scmAddress = NetUtils.createSocketAddr((String)InetAddress.getLocalHost().getHostName(), (int)9863);
        } else {
            scmAddress = NetUtils.createSocketAddr((String)((SCMNodeInfo)scmNodeInfoList.get(0)).getBlockClientAddress());
        }
        return scmAddress;
    }

    public static void initMetrics() {
        metrics = SCMMetrics.create();
    }

    public static SCMMetrics getMetrics() {
        return metrics == null ? SCMMetrics.create() : metrics;
    }

    public SCMStorageConfig getScmStorageConfig() {
        return this.scmStorageConfig;
    }

    public SCMDatanodeProtocolServer getDatanodeProtocolServer() {
        return this.datanodeProtocolServer;
    }

    public SCMBlockProtocolServer getBlockProtocolServer() {
        return this.blockProtocolServer;
    }

    public SCMClientProtocolServer getClientProtocolServer() {
        return this.clientProtocolServer;
    }

    public SCMSecurityProtocolServer getSecurityProtocolServer() {
        return this.securityProtocolServer;
    }

    private void registerMXBean() {
        HashMap<String, String> jmxProperties = new HashMap<String, String>();
        jmxProperties.put("component", "ServerRuntime");
        this.scmInfoBeanName = HddsUtils.registerWithJmxProperties((String)"StorageContainerManager", (String)"StorageContainerManagerInfo", jmxProperties, (Object)this);
    }

    private void registerMetricsSource(SCMMXBean scmMBean) {
        this.scmContainerMetrics = SCMContainerMetrics.create(scmMBean);
    }

    private void unregisterMXBean() {
        if (this.scmInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.scmInfoBeanName);
            this.scmInfoBeanName = null;
        }
    }

    @VisibleForTesting
    public ContainerInfo getContainerInfo(long containerID) throws IOException {
        return this.containerManager.getContainer(ContainerID.valueOf((long)containerID));
    }

    @VisibleForTesting
    public InetSocketAddress getClientRpcAddress() {
        return this.getClientProtocolServer().getClientRpcAddress();
    }

    @Override
    public String getClientRpcPort() {
        InetSocketAddress addr = this.getClientRpcAddress();
        return addr == null ? "0" : Integer.toString(addr.getPort());
    }

    public String getBlockProtocolRpcPort() {
        InetSocketAddress addr = this.getBlockProtocolServer().getBlockRpcAddress();
        return addr == null ? "0" : Integer.toString(addr.getPort());
    }

    public String getSecurityProtocolRpcPort() {
        InetSocketAddress addr = this.getSecurityProtocolServer().getRpcAddress();
        return addr == null ? "0" : Integer.toString(addr.getPort());
    }

    @Override
    public InetSocketAddress getDatanodeRpcAddress() {
        return this.getDatanodeProtocolServer().getDatanodeRpcAddress();
    }

    @Override
    public SCMNodeDetails getScmNodeDetails() {
        return this.scmHANodeDetails.getLocalNodeDetails();
    }

    public SCMHANodeDetails getSCMHANodeDetails() {
        return this.scmHANodeDetails;
    }

    public String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    @Override
    public String getDatanodeRpcPort() {
        InetSocketAddress addr = this.getDatanodeRpcAddress();
        return addr == null ? "0" : Integer.toString(addr.getPort());
    }

    public CertificateStore getCertificateStore() {
        return this.certificateStore;
    }

    @Override
    public void start() throws IOException {
        this.finalizationManager.runPrefinalizeStateActions();
        if (LOG.isInfoEnabled()) {
            LOG.info(StorageContainerManager.buildRpcServerStartMessage("StorageContainerLocationProtocol RPC server", this.getClientRpcAddress()));
        }
        this.scmHAManager.start();
        this.ms = HddsServerUtil.initializeMetrics((OzoneConfiguration)this.configuration, (String)"StorageContainerManager");
        this.getClientProtocolServer().start();
        if (LOG.isInfoEnabled()) {
            LOG.info(StorageContainerManager.buildRpcServerStartMessage("ScmBlockLocationProtocol RPC server", this.getBlockProtocolServer().getBlockRpcAddress()));
        }
        this.getBlockProtocolServer().start();
        if (!this.scmStorageConfig.isSCMHAEnabled()) {
            this.getDatanodeProtocolServer().start();
        }
        if (this.getSecurityProtocolServer() != null) {
            this.getSecurityProtocolServer().start();
            this.persistSCMCertificates();
        }
        if (this.rootCARotationManager != null) {
            try {
                this.rootCARotationManager.start();
            }
            catch (SCMServiceException e) {
                throw new IOException("Failed to start root CA rotation manager", e);
            }
        }
        this.scmBlockManager.start();
        this.leaseManager.start();
        if (this.jvmPauseMonitor != null) {
            this.jvmPauseMonitor.start();
        }
        try {
            this.httpServer = new StorageContainerManagerHttpServer((MutableConfigurationSource)this.configuration, this);
            this.httpServer.start();
        }
        catch (Exception ex) {
            LOG.error("SCM HttpServer failed to start.", (Throwable)ex);
        }
        this.setStartTime();
        this.scmHAMetricsUpdate(null);
        if (this.scmCertificateClient != null) {
            this.scmCertificateClient.refreshCACertificates();
        }
    }

    private void persistSCMCertificates() throws IOException {
        if (this.primaryScmNodeId != null && !this.primaryScmNodeId.equals(this.scmStorageConfig.getScmId())) {
            List pemEncodedCerts = this.scmCertificateClient.listCA();
            for (String cert : pemEncodedCerts) {
                X509Certificate x509Certificate = CertificateCodec.getX509Certificate((String)cert, CertificateCodec::toIOException);
                if (this.certificateStore.getCertificateByID(x509Certificate.getSerialNumber(), CertificateStore.CertType.VALID_CERTS) != null) continue;
                LOG.info("Persist certificate serialId {} on Scm Bootstrap Node {}", (Object)x509Certificate.getSerialNumber(), (Object)this.scmStorageConfig.getScmId());
                this.certificateStore.storeValidScmCertificate(x509Certificate.getSerialNumber(), x509Certificate);
            }
        }
    }

    @Override
    public void stop() {
        if (this.isStopped.getAndSet(true)) {
            LOG.info("Storage Container Manager is not running.");
            IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{this.scmHAManager});
            this.stopReplicationManager();
            return;
        }
        try {
            if (this.containerBalancer.isBalancerRunning()) {
                LOG.info("Stopping Container Balancer service.");
                this.containerBalancer.stop();
            } else {
                LOG.info("Container Balancer is not running.");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to stop Container Balancer service.", (Throwable)e);
        }
        this.stopReplicationManager();
        try {
            LOG.info("Stopping the Datanode Admin Monitor.");
            this.scmDecommissionManager.stop();
        }
        catch (Exception ex) {
            LOG.error("The Datanode Admin Monitor failed to stop", (Throwable)ex);
        }
        try {
            LOG.info("Stopping datanode service RPC server");
            this.getDatanodeProtocolServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager datanode RPC stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping block service RPC server");
            this.getBlockProtocolServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager blockRpcServer stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping the StorageContainerLocationProtocol RPC server");
            this.getClientProtocolServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager clientRpcServer stop failed.", (Throwable)ex);
        }
        try {
            LOG.info("Stopping Storage Container Manager HTTP server.");
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
        }
        catch (Exception ex) {
            LOG.error("Storage Container Manager HTTP server stop failed.", (Throwable)ex);
        }
        LOG.info("Stopping SCM LayoutVersionManager Service.");
        this.scmLayoutVersionManager.close();
        if (this.getSecurityProtocolServer() != null) {
            this.getSecurityProtocolServer().stop();
        }
        if (this.rootCARotationManager != null) {
            this.rootCARotationManager.stop();
        }
        try {
            LOG.info("Stopping Block Manager Service.");
            this.scmBlockManager.stop();
        }
        catch (Exception ex) {
            LOG.error("SCM block manager service stop failed.", (Throwable)ex);
        }
        if (metrics != null) {
            metrics.unRegister();
        }
        this.unregisterMXBean();
        if (this.scmContainerMetrics != null) {
            this.scmContainerMetrics.unRegister();
        }
        if (this.placementMetrics != null) {
            this.placementMetrics.unRegister();
        }
        try {
            LOG.info("Stopping SCM Event Queue.");
            this.eventQueue.close();
        }
        catch (Exception ex) {
            LOG.error("SCM Event Queue stop failed", (Throwable)ex);
        }
        if (this.jvmPauseMonitor != null) {
            this.jvmPauseMonitor.stop();
        }
        try {
            LOG.info("Stopping SCM HA services.");
            this.scmHAManager.stop();
        }
        catch (Exception ex) {
            LOG.error("SCM HA Manager stop failed", (Throwable)ex);
        }
        if (this.scmHAMetrics != null) {
            SCMHAMetrics.unRegister();
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.containerManager});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.pipelineManager});
        if (this.ms != null) {
            this.ms.stop();
        }
        this.scmSafeModeManager.stop();
        this.serviceManager.stop();
        try {
            this.leaseManager.shutdown();
        }
        catch (LeaseManagerNotRunningException ex) {
            LOG.debug("Lease manager not running, ignore");
        }
        RatisDropwizardExports.clear(this.ratisMetricsMap, this.ratisReporterList);
        if (this.scmCertificateClient != null) {
            try {
                this.scmCertificateClient.close();
            }
            catch (IOException ioe) {
                LOG.error("Closing certificate client failed", (Throwable)ioe);
            }
        }
        try {
            LOG.info("Stopping SCM MetadataStore.");
            this.scmMetadataStore.stop();
        }
        catch (Exception ex) {
            LOG.error("SCM Metadata store stop failed", (Throwable)ex);
        }
    }

    private void stopReplicationManager() {
        try {
            LOG.info("Stopping Replication Manager Service.");
            this.replicationManager.stop();
        }
        catch (Exception ex) {
            LOG.error("Replication manager service stop failed.", (Throwable)ex);
        }
    }

    @Override
    public void shutDown(String message) {
        this.stop();
        ExitUtils.terminate((int)0, (String)message, (Logger)LOG);
    }

    @Override
    public void join() {
        try {
            this.getBlockProtocolServer().join();
            this.getClientProtocolServer().join();
            this.getDatanodeProtocolServer().join();
            if (this.getSecurityProtocolServer() != null) {
                this.getSecurityProtocolServer().join();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted during StorageContainerManager join.");
        }
    }

    public int getNodeCount(HddsProtos.NodeState nodestate) {
        return this.scmNodeManager.getNodeCount(null, nodestate);
    }

    public NodeDecommissionManager getScmDecommissionManager() {
        return this.scmDecommissionManager;
    }

    public SCMHAManager getScmHAManager() {
        return this.scmHAManager;
    }

    public WritableContainerFactory getWritableContainerFactory() {
        return this.writableContainerFactory;
    }

    @Override
    @VisibleForTesting
    public ContainerManager getContainerManager() {
        return this.containerManager;
    }

    @Override
    @VisibleForTesting
    public NodeManager getScmNodeManager() {
        return this.scmNodeManager;
    }

    @Override
    @VisibleForTesting
    public PipelineManager getPipelineManager() {
        return this.pipelineManager;
    }

    @Override
    @VisibleForTesting
    public BlockManager getScmBlockManager() {
        return this.scmBlockManager;
    }

    @VisibleForTesting
    public SCMSafeModeManager getScmSafeModeManager() {
        return this.scmSafeModeManager;
    }

    @VisibleForTesting
    public SecretKeyManager getSecretKeyManager() {
        return this.secretKeyManagerService != null ? this.secretKeyManagerService.getSecretKeyManager() : null;
    }

    @Override
    public ReplicationManager getReplicationManager() {
        return this.replicationManager;
    }

    public PlacementPolicy getContainerPlacementPolicy() {
        return this.containerPlacementPolicy;
    }

    public PlacementPolicyValidateProxy getPlacementPolicyValidateProxy() {
        return this.placementPolicyValidateProxy;
    }

    @Override
    @VisibleForTesting
    public ContainerBalancer getContainerBalancer() {
        return this.containerBalancer;
    }

    public MoveManager getMoveManager() {
        return this.moveManager;
    }

    public RootCARotationManager getRootCARotationManager() {
        return this.rootCARotationManager;
    }

    public boolean checkLeader() {
        if (!SCMHAUtils.isSCMHAEnabled((ConfigurationSource)this.configuration)) {
            return true;
        }
        return this.getScmHAManager().getRatisServer().getDivision().getInfo().isLeaderReady();
    }

    private void checkAdminAccess(String op) throws IOException {
        this.checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
    }

    public void checkAdminAccess(UserGroupInformation remoteUser, boolean isRead) throws IOException {
        if (!(remoteUser == null || this.scmAdmins.isAdmin(remoteUser) || isRead && this.scmReadOnlyAdmins.isAdmin(remoteUser))) {
            throw new AccessControlException("Access denied for user " + remoteUser.getUserName() + ". SCM superuser privilege is required.");
        }
    }

    @Override
    public double getSafeModeCurrentContainerThreshold() {
        return this.getCurrentContainerThreshold();
    }

    @Override
    public boolean isInSafeMode() {
        return this.scmSafeModeManager.getInSafeMode();
    }

    public EventPublisher getEventQueue() {
        return this.eventQueue;
    }

    public SCMContext getScmContext() {
        return this.scmContext;
    }

    public SequenceIdGenerator getSequenceIdGen() {
        return this.sequenceIdGen;
    }

    public SCMServiceManager getSCMServiceManager() {
        return this.serviceManager;
    }

    public boolean exitSafeMode() {
        this.scmSafeModeManager.exitSafeMode((EventPublisher)this.eventQueue);
        return true;
    }

    @VisibleForTesting
    public double getCurrentContainerThreshold() {
        return this.scmSafeModeManager.getCurrentContainerThreshold();
    }

    @Override
    public Map<String, Integer> getContainerStateCount() {
        HashMap<String, Integer> nodeStateCount = new HashMap<String, Integer>();
        for (HddsProtos.LifeCycleState state : HddsProtos.LifeCycleState.values()) {
            nodeStateCount.put(state.toString(), this.containerManager.getContainerStateCount(state));
        }
        return nodeStateCount;
    }

    public SCMMetadataStore getScmMetadataStore() {
        return this.scmMetadataStore;
    }

    public NetworkTopology getClusterMap() {
        return this.clusterMap;
    }

    public StatefulServiceStateManager getStatefulServiceStateManager() {
        return this.statefulServiceStateManager;
    }

    public Map<String, Pair<Boolean, String>> getRuleStatus() {
        return this.scmSafeModeManager.getRuleStatus();
    }

    @Override
    public Map<String, String[]> getSafeModeRuleStatus() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (Map.Entry<String, Pair<Boolean, String>> entry : this.scmSafeModeManager.getRuleStatus().entrySet()) {
            String[] status = new String[]{(String)entry.getValue().getRight(), ((Boolean)entry.getValue().getLeft()).toString()};
            map.put(entry.getKey(), status);
        }
        return map;
    }

    public PipelineChoosePolicy getPipelineChoosePolicy() {
        return this.pipelineChoosePolicy;
    }

    public PipelineChoosePolicy getEcPipelineChoosePolicy() {
        return this.ecPipelineChoosePolicy;
    }

    @Override
    public String getScmId() {
        return this.getScmStorageConfig().getScmId();
    }

    @Override
    public String getClusterId() {
        return this.getScmStorageConfig().getClusterID();
    }

    public HDDSLayoutVersionManager getLayoutVersionManager() {
        return this.scmLayoutVersionManager;
    }

    public FinalizationManager getFinalizationManager() {
        return this.finalizationManager;
    }

    public String getSCMNodeId() {
        return this.scmHANodeDetails.getLocalNodeDetails().getNodeId();
    }

    @VisibleForTesting
    public SCMHAMetrics getScmHAMetrics() {
        return this.scmHAMetrics;
    }

    public ContainerTokenGenerator getContainerTokenGenerator() {
        return this.containerTokenMgr != null ? this.containerTokenMgr : ContainerTokenGenerator.DISABLED;
    }

    @Override
    public String getScmRatisRoles() {
        SCMRatisServer server = this.getScmHAManager().getRatisServer();
        return server != null ? HddsUtils.format(server.getRatisRoles()) : "STANDALONE";
    }

    @Override
    public String getPrimordialNode() {
        if (SCMHAUtils.isSCMHAEnabled((ConfigurationSource)this.configuration)) {
            String primordialNode = SCMHAUtils.getPrimordialSCM((ConfigurationSource)this.configuration);
            if (SCMHAUtils.getSCMNodeIds((ConfigurationSource)this.configuration).contains(primordialNode)) {
                ArrayList<SCMNodeDetails> localAndPeerNodes = new ArrayList<SCMNodeDetails>(this.scmHANodeDetails.getPeerNodeDetails());
                localAndPeerNodes.add(this.getSCMHANodeDetails().getLocalNodeDetails());
                for (SCMNodeDetails nodes : localAndPeerNodes) {
                    if (!nodes.getNodeId().equals(primordialNode)) continue;
                    return nodes.getHostName();
                }
            }
            return primordialNode;
        }
        return null;
    }

    @Override
    public String getRatisLogDirectory() {
        return SCMHAUtils.getSCMRatisDirectory((ConfigurationSource)this.configuration);
    }

    @Override
    public String getRocksDbDirectory() {
        return String.valueOf(ServerUtils.getScmDbDir((ConfigurationSource)this.configuration));
    }

    public Collection<String> getScmAdminUsernames() {
        return this.scmAdmins.getAdminUsernames();
    }

    public Collection<String> getScmReadOnlyAdminUsernames() {
        return this.scmReadOnlyAdmins.getAdminUsernames();
    }

    private String reconfOzoneAdmins(String newVal) {
        this.getConfiguration().set("ozone.administrators", newVal);
        Collection admins = OzoneAdmins.getOzoneAdminsFromConfig((OzoneConfiguration)this.getConfiguration(), (String)this.scmStarterUser);
        this.scmAdmins.setAdminUsernames(admins);
        LOG.info("Load conf {} : {}, and now admins are: {}", new Object[]{"ozone.administrators", newVal, admins});
        return String.valueOf(newVal);
    }

    private String reconfOzoneReadOnlyAdmins(String newVal) {
        this.getConfiguration().set("ozone.readonly.administrators", newVal);
        Collection admins = OzoneAdmins.getOzoneReadOnlyAdminsFromConfig((OzoneConfiguration)this.getConfiguration());
        this.scmReadOnlyAdmins.setAdminUsernames(admins);
        LOG.info("Load conf {} : {}, and now read only admins are: {}", new Object[]{"ozone.readonly.administrators", newVal, admins});
        return String.valueOf(newVal);
    }

    public boolean removePeerFromHARing(String scmId) throws IOException {
        if (this.getScmHAManager().getRatisServer() == null) {
            throw new IOException("Cannot remove SCM " + scmId + " in a non-HA cluster");
        }
        if (this.scmContext.isLeader() && scmId.equals(this.getScmId())) {
            throw new IOException("Cannot remove current leader.");
        }
        ScmUtils.checkIfCertSignRequestAllowed(this.rootCARotationManager, false, this.configuration, "removePeerFromHARing");
        Preconditions.checkNotNull((Object)this.getScmHAManager().getRatisServer().getDivision().getGroup());
        if (this.getScmHAManager().getRatisServer().getDivision().getGroup().getPeer(RaftPeerId.valueOf((String)scmId)) == null) {
            throw new IOException("ScmId " + scmId + " supplied for scm removal not in Ratis Peer list");
        }
        RemoveSCMRequest request = new RemoveSCMRequest(this.getClusterId(), scmId, this.getScmHAManager().getRatisServer().getDivision().getGroup().getPeer(RaftPeerId.valueOf((String)scmId)).getAddress());
        return this.getScmHAManager().removeSCM(request);
    }

    public void scmHAMetricsUpdate(String leaderId) {
        SCMHAMetrics.unRegister();
        this.scmHAMetrics = SCMHAMetrics.create(this.getScmId(), leaderId);
    }

    @Override
    public ReconfigurationHandler getReconfigurationHandler() {
        return this.reconfigurationHandler;
    }

    public String resolveNodeLocation(String hostname) {
        List<String> hosts = Collections.singletonList(hostname);
        List resolvedHosts = this.dnsToSwitchMapping.resolve(hosts);
        if (resolvedHosts != null && !resolvedHosts.isEmpty()) {
            String location = (String)resolvedHosts.get(0);
            LOG.debug("Node {} resolved to location {}", (Object)hostname, (Object)location);
            return location;
        }
        LOG.debug("Node resolution did not yield any result for {}", (Object)hostname);
        return null;
    }
}

