/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server.upgrade;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationCheckpoint;
import org.apache.hadoop.hdds.scm.server.upgrade.SCMUpgradeFinalizationContext;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.upgrade.BasicUpgradeFinalizer;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;

public interface FinalizationManager {
    public UpgradeFinalizer.StatusAndMessages finalizeUpgrade(String var1) throws IOException;

    public UpgradeFinalizer.StatusAndMessages queryUpgradeFinalizationProgress(String var1, boolean var2, boolean var3) throws IOException;

    @VisibleForTesting
    public BasicUpgradeFinalizer<SCMUpgradeFinalizationContext, HDDSLayoutVersionManager> getUpgradeFinalizer();

    public void runPrefinalizeStateActions() throws IOException;

    public boolean crossedCheckpoint(FinalizationCheckpoint var1);

    public FinalizationCheckpoint getCheckpoint();

    public void buildUpgradeContext(NodeManager var1, PipelineManager var2, SCMContext var3);

    public void reinitialize(Table<String, String> var1) throws IOException;

    public void onLeaderReady();

    public static boolean shouldCreateNewPipelines(FinalizationCheckpoint checkpoint) {
        return !checkpoint.hasCrossed(FinalizationCheckpoint.FINALIZATION_STARTED) || checkpoint.hasCrossed(FinalizationCheckpoint.MLV_EQUALS_SLV);
    }

    public static boolean shouldTellDatanodesToFinalize(FinalizationCheckpoint checkpoint) {
        return checkpoint.hasCrossed(FinalizationCheckpoint.MLV_EQUALS_SLV);
    }
}

