/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.ha.SCMHAInvocationHandler;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.metadata.DBTransactionBuffer;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationCheckpoint;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationManager;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationStateManager;
import org.apache.hadoop.hdds.scm.server.upgrade.SCMUpgradeFinalizationContext;
import org.apache.hadoop.hdds.scm.server.upgrade.SCMUpgradeFinalizer;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalizationStateManagerImpl
implements FinalizationStateManager {
    @VisibleForTesting
    public static final Logger LOG = LoggerFactory.getLogger(FinalizationStateManagerImpl.class);
    private Table<String, String> finalizationStore;
    private final DBTransactionBuffer transactionBuffer;
    private final HDDSLayoutVersionManager versionManager;
    private final ReadWriteLock checkpointLock;
    private volatile boolean hasFinalizingMark;
    private SCMUpgradeFinalizationContext upgradeContext;
    private final SCMUpgradeFinalizer upgradeFinalizer;

    protected FinalizationStateManagerImpl(Builder builder) throws IOException {
        this.finalizationStore = builder.finalizationStore;
        this.transactionBuffer = builder.transactionBuffer;
        this.upgradeFinalizer = builder.upgradeFinalizer;
        this.versionManager = (HDDSLayoutVersionManager)this.upgradeFinalizer.getVersionManager();
        this.checkpointLock = new ReentrantReadWriteLock();
        this.initialize();
    }

    private void initialize() throws IOException {
        this.hasFinalizingMark = this.finalizationStore.isExist((Object)"#FINALIZING");
    }

    private void publishCheckpoint(FinalizationCheckpoint checkpoint) {
        this.versionManager.setUpgradeState(checkpoint.getStatus());
        if (checkpoint == FinalizationCheckpoint.MLV_EQUALS_SLV) {
            this.upgradeContext.getNodeManager().forceNodesToHealthyReadOnly();
        }
        PipelineManager pipelineManager = this.upgradeContext.getPipelineManager();
        if (FinalizationManager.shouldCreateNewPipelines(checkpoint) && pipelineManager.isPipelineCreationFrozen()) {
            pipelineManager.resumePipelineCreation();
        } else if (!FinalizationManager.shouldCreateNewPipelines(checkpoint) && !pipelineManager.isPipelineCreationFrozen()) {
            pipelineManager.freezePipelineCreation();
        }
        this.upgradeContext.getSCMContext().setFinalizationCheckpoint(checkpoint);
    }

    @Override
    public void setUpgradeContext(SCMUpgradeFinalizationContext context) {
        this.upgradeContext = context;
        FinalizationCheckpoint checkpoint = this.getFinalizationCheckpoint();
        this.upgradeContext.getSCMContext().setFinalizationCheckpoint(checkpoint);
        this.versionManager.setUpgradeState(checkpoint.getStatus());
    }

    @Override
    public void addFinalizingMark() throws IOException {
        this.checkpointLock.writeLock().lock();
        try {
            this.hasFinalizingMark = true;
        }
        finally {
            this.checkpointLock.writeLock().unlock();
        }
        this.transactionBuffer.addToBuffer(this.finalizationStore, (Object)"#FINALIZING", (Object)"");
        this.publishCheckpoint(FinalizationCheckpoint.FINALIZATION_STARTED);
    }

    @Override
    public void finalizeLayoutFeature(Integer layoutVersion) throws IOException {
        this.finalizeLayoutFeatureLocal(layoutVersion);
    }

    private void finalizeLayoutFeatureLocal(Integer layoutVersion) throws IOException {
        this.checkpointLock.writeLock().lock();
        try {
            HDDSLayoutFeature feature = (HDDSLayoutFeature)this.versionManager.getFeature(layoutVersion.intValue());
            this.upgradeFinalizer.replicatedFinalizationSteps(feature, this.upgradeContext);
        }
        finally {
            this.checkpointLock.writeLock().unlock();
        }
        if (!this.versionManager.needsFinalization()) {
            this.publishCheckpoint(FinalizationCheckpoint.MLV_EQUALS_SLV);
        }
        this.transactionBuffer.addToBuffer(this.finalizationStore, (Object)"#LAYOUTVERSION", (Object)String.valueOf(layoutVersion));
    }

    @Override
    public void removeFinalizingMark() throws IOException {
        this.checkpointLock.writeLock().lock();
        try {
            this.hasFinalizingMark = false;
        }
        finally {
            this.checkpointLock.writeLock().unlock();
        }
        this.transactionBuffer.removeFromBuffer(this.finalizationStore, (Object)"#FINALIZING");
        FinalizationCheckpoint checkpoint = this.getFinalizationCheckpoint();
        if (checkpoint != FinalizationCheckpoint.FINALIZATION_COMPLETE) {
            String errorMessage = String.format("SCM upgrade finalization is in an unknown state. Expected %s but was %s", new Object[]{FinalizationCheckpoint.FINALIZATION_COMPLETE, checkpoint});
            ExitUtils.terminate((int)1, (String)errorMessage, (Logger)LOG);
        }
        this.publishCheckpoint(FinalizationCheckpoint.FINALIZATION_COMPLETE);
    }

    @Override
    public boolean crossedCheckpoint(FinalizationCheckpoint query) {
        return this.getFinalizationCheckpoint().hasCrossed(query);
    }

    @Override
    public FinalizationCheckpoint getFinalizationCheckpoint() {
        boolean hasFinalizingMarkSnapshot;
        boolean mlvBehindSlvSnapshot;
        this.checkpointLock.readLock().lock();
        try {
            mlvBehindSlvSnapshot = this.versionManager.needsFinalization();
            hasFinalizingMarkSnapshot = this.hasFinalizingMark;
        }
        finally {
            this.checkpointLock.readLock().unlock();
        }
        FinalizationCheckpoint currentCheckpoint = null;
        for (FinalizationCheckpoint checkpoint : FinalizationCheckpoint.values()) {
            if (!checkpoint.isCurrent(hasFinalizingMarkSnapshot, mlvBehindSlvSnapshot)) continue;
            currentCheckpoint = checkpoint;
            break;
        }
        if (currentCheckpoint == null) {
            String errorMessage = String.format("SCM upgrade finalization is in an unknown state.%nFinalizing mark present? %b%nMetadata layout version behind software layout version? %b", hasFinalizingMarkSnapshot, mlvBehindSlvSnapshot);
            ExitUtils.terminate((int)1, (String)errorMessage, (Logger)LOG);
        }
        return currentCheckpoint;
    }

    @Override
    public void reinitialize(Table<String, String> newFinalizationStore) throws IOException {
        this.checkpointLock.writeLock().lock();
        try {
            this.finalizationStore.close();
            this.finalizationStore = newFinalizationStore;
            this.initialize();
            int dbLayoutVersion = this.getDBLayoutVersion();
            int currentLayoutVersion = this.versionManager.getMetadataLayoutVersion();
            if (currentLayoutVersion < dbLayoutVersion) {
                LOG.info("New SCM snapshot received with metadata layout version {}, which is higher than this SCM's metadata layout version {}.Attempting to finalize current SCM to that version.", (Object)dbLayoutVersion, (Object)currentLayoutVersion);
                for (int version = currentLayoutVersion + 1; version <= dbLayoutVersion; ++version) {
                    this.finalizeLayoutFeatureLocal(version);
                }
            }
            this.publishCheckpoint(this.getFinalizationCheckpoint());
        }
        catch (Exception ex) {
            LOG.error("Failed to reinitialize finalization state", (Throwable)ex);
            throw new IOException(ex);
        }
        finally {
            this.checkpointLock.writeLock().unlock();
        }
    }

    private int getDBLayoutVersion() throws IOException {
        String dbLayoutVersion = (String)this.finalizationStore.get((Object)"#LAYOUTVERSION");
        if (dbLayoutVersion == null) {
            return this.versionManager.getMetadataLayoutVersion();
        }
        try {
            return Integer.parseInt(dbLayoutVersion);
        }
        catch (NumberFormatException ex) {
            String msg = String.format("Failed to read layout version from SCM DB. Found string %s", dbLayoutVersion);
            LOG.error(msg, (Throwable)ex);
            throw new IOException(msg, ex);
        }
    }

    public static class Builder {
        private Table<String, String> finalizationStore;
        private DBTransactionBuffer transactionBuffer;
        private SCMRatisServer scmRatisServer;
        private SCMUpgradeFinalizer upgradeFinalizer;

        public Builder setUpgradeFinalizer(SCMUpgradeFinalizer finalizer) {
            this.upgradeFinalizer = finalizer;
            return this;
        }

        public Builder setRatisServer(SCMRatisServer ratisServer) {
            this.scmRatisServer = ratisServer;
            return this;
        }

        public Builder setFinalizationStore(Table<String, String> finalizationStore) {
            this.finalizationStore = finalizationStore;
            return this;
        }

        public Builder setTransactionBuffer(DBTransactionBuffer transactionBuffer) {
            this.transactionBuffer = transactionBuffer;
            return this;
        }

        public FinalizationStateManager build() throws IOException {
            Preconditions.checkNotNull(this.finalizationStore);
            Preconditions.checkNotNull((Object)this.transactionBuffer);
            Preconditions.checkNotNull((Object)((Object)this.upgradeFinalizer));
            SCMHAInvocationHandler invocationHandler = new SCMHAInvocationHandler(SCMRatisProtocol.RequestType.FINALIZE, new FinalizationStateManagerImpl(this), this.scmRatisServer);
            return (FinalizationStateManager)Proxy.newProxyInstance(SCMHAInvocationHandler.class.getClassLoader(), new Class[]{FinalizationStateManager.class}, (InvocationHandler)invocationHandler);
        }
    }
}

