/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server.upgrade;

import java.io.IOException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.scm.server.upgrade.SCMUpgradeFinalizationContext;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSUpgradeAction;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.UpgradeActionHdds;
import org.apache.hadoop.ozone.upgrade.UpgradeException;

@UpgradeActionHdds(feature=HDDSLayoutFeature.SCM_HA, component=UpgradeActionHdds.Component.SCM, type=LayoutFeature.UpgradeActionType.VALIDATE_IN_PREFINALIZE)
public class ScmHAUnfinalizedStateValidationAction
implements HDDSUpgradeAction<SCMUpgradeFinalizationContext> {
    public void execute(SCMUpgradeFinalizationContext context) throws IOException {
        ScmHAUnfinalizedStateValidationAction.checkScmHA(context.getConfiguration(), context.getStorage(), (LayoutVersionManager)context.getLayoutVersionManager());
    }

    public static void checkScmHA(OzoneConfiguration conf, SCMStorageConfig storageConf, LayoutVersionManager versionManager) throws IOException {
        if (!versionManager.isAllowed((LayoutFeature)HDDSLayoutFeature.SCM_HA) && SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf) && !storageConf.isSCMHAEnabled()) {
            throw new UpgradeException(String.format("Configuration %s cannot be used until SCM upgrade has been finalized", "ozone.scm.ratis.enable"), UpgradeException.ResultCodes.PREFINALIZE_ACTION_VALIDATION_FAILED);
        }
    }
}

