/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.server.http.HttpServer2;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.VersionInfo;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.s3.OzoneConfigurationHolder;
import org.apache.hadoop.ozone.s3.S3GatewayHttpServer;
import org.apache.hadoop.ozone.s3.metrics.S3GatewayMetrics;
import org.apache.hadoop.ozone.util.OzoneNetUtils;
import org.apache.hadoop.ozone.util.OzoneVersionInfo;
import org.apache.hadoop.ozone.util.ShutdownHookManager;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.ratis.util.JvmPauseMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ozone s3g", hidden=true, description={"S3 compatible rest server."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class Gateway
extends GenericCli {
    private static final Logger LOG = LoggerFactory.getLogger(Gateway.class);
    private S3GatewayHttpServer httpServer;
    private S3GatewayMetrics metrics;
    private OzoneConfiguration ozoneConfiguration;
    private final JvmPauseMonitor jvmPauseMonitor = RatisHelper.newJvmPauseMonitor((String)"S3G");

    public static void main(String[] args) throws Exception {
        OzoneNetUtils.disableJvmNetworkAddressCacheIfRequired((OzoneConfiguration)new OzoneConfiguration());
        new Gateway().run(args);
    }

    public Void call() throws Exception {
        this.ozoneConfiguration = this.createOzoneConfiguration();
        TracingUtil.initTracing((String)"S3gateway", (ConfigurationSource)this.ozoneConfiguration);
        OzoneConfigurationHolder.setConfiguration(this.ozoneConfiguration);
        UserGroupInformation.setConfiguration((Configuration)this.ozoneConfiguration);
        Gateway.loginS3GUser(this.ozoneConfiguration);
        HttpServer2.setHttpBaseDir((OzoneConfiguration)this.ozoneConfiguration);
        this.httpServer = new S3GatewayHttpServer((MutableConfigurationSource)this.ozoneConfiguration, "s3gateway");
        this.metrics = S3GatewayMetrics.create();
        this.start();
        ShutdownHookManager.get().addShutdownHook(() -> {
            try {
                this.stop();
            }
            catch (Exception e) {
                LOG.error("Error during stop S3Gateway", (Throwable)e);
            }
        }, 10);
        return null;
    }

    public void start() throws IOException {
        String[] originalArgs = this.getCmd().getParseResult().originalArgs().toArray(new String[0]);
        StringUtils.startupShutdownMessage((VersionInfo)OzoneVersionInfo.OZONE_VERSION_INFO, Gateway.class, (String[])originalArgs, (Logger)LOG, (OzoneConfiguration)this.ozoneConfiguration);
        LOG.info("Starting Ozone S3 gateway");
        HddsServerUtil.initializeMetrics((OzoneConfiguration)this.ozoneConfiguration, (String)"S3Gateway");
        this.jvmPauseMonitor.start();
        this.httpServer.start();
    }

    public void stop() throws Exception {
        LOG.info("Stopping Ozone S3 gateway");
        this.httpServer.stop();
        this.jvmPauseMonitor.stop();
        S3GatewayMetrics.unRegister();
    }

    private static void loginS3GUser(OzoneConfiguration conf) throws IOException, AuthenticationException {
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            if (SecurityUtil.getAuthenticationMethod((Configuration)conf).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ozone security is enabled. Attempting login for S3G user. Principal: {}, keytab: {}", (Object)conf.get("ozone.s3g.kerberos.principal"), (Object)conf.get("ozone.s3g.kerberos.keytab.file"));
                }
            } else {
                throw new AuthenticationException(SecurityUtil.getAuthenticationMethod((Configuration)conf) + " authentication method not supported. S3G user login failed.");
            }
            SecurityUtil.login((Configuration)conf, (String)"ozone.s3g.kerberos.keytab.file", (String)"ozone.s3g.kerberos.principal");
            LOG.info("S3Gateway login successful.");
        }
    }
}

