/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.util;

import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public enum S3StorageType {
    REDUCED_REDUNDANCY(ReplicationType.RATIS, ReplicationFactor.ONE),
    STANDARD(ReplicationType.RATIS, ReplicationFactor.THREE);

    private final ReplicationType type;
    private final ReplicationFactor factor;

    private S3StorageType(ReplicationType type, ReplicationFactor factor) {
        this.type = type;
        this.factor = factor;
    }

    public ReplicationFactor getFactor() {
        return this.factor;
    }

    public ReplicationType getType() {
        return this.type;
    }

    public static S3StorageType getDefault(ConfigurationSource config) {
        ReplicationFactor configFactor;
        String replicationString = config.get("ozone.replication");
        try {
            configFactor = ReplicationFactor.valueOf((int)Integer.parseInt(replicationString));
        }
        catch (NumberFormatException ex) {
            return STANDARD;
        }
        return configFactor == ReplicationFactor.ONE ? REDUCED_REDUNDANCY : STANDARD;
    }

    public static S3StorageType fromReplicationConfig(ReplicationConfig config) {
        if (config instanceof ECReplicationConfig) {
            return STANDARD;
        }
        if (config.getReplicationType() == HddsProtos.ReplicationType.STAND_ALONE || config.getRequiredNodes() == 1) {
            return REDUCED_REDUNDANCY;
        }
        return STANDARD;
    }
}

