/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provider;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;

public class ConfigurationProvider
implements Provider<OzoneConfiguration> {
    private static OzoneConfiguration configuration;

    private static void addDeprecations() {
        Configuration.addDeprecations((Configuration.DeprecationDelta[])new Configuration.DeprecationDelta[]{new Configuration.DeprecationDelta("ozone.recon.keytab.file", "ozone.recon.http.auth.kerberos.keytab"), new Configuration.DeprecationDelta("ozone.recon.http.kerberos.keytab.file", "ozone.recon.http.auth.kerberos.keytab"), new Configuration.DeprecationDelta("ozone.recon.authentication.kerberos.principal", "ozone.recon.http.auth.kerberos.principal")});
    }

    @VisibleForTesting
    public static void setConfiguration(OzoneConfiguration conf) {
        if (configuration == null) {
            configuration = conf;
        }
    }

    @VisibleForTesting
    public static void resetConfiguration() {
        configuration = null;
    }

    public OzoneConfiguration get() {
        return configuration;
    }

    static {
        ConfigurationProvider.addDeprecations();
    }
}

