/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.recon.api.AdminOnly;
import org.apache.hadoop.ozone.recon.api.types.ContainerDiscrepancyInfo;
import org.apache.hadoop.ozone.recon.api.types.ContainerKeyPrefix;
import org.apache.hadoop.ozone.recon.api.types.ContainerMetadata;
import org.apache.hadoop.ozone.recon.api.types.ContainersResponse;
import org.apache.hadoop.ozone.recon.api.types.DeletedContainerInfo;
import org.apache.hadoop.ozone.recon.api.types.KeyMetadata;
import org.apache.hadoop.ozone.recon.api.types.KeysResponse;
import org.apache.hadoop.ozone.recon.api.types.MissingContainerMetadata;
import org.apache.hadoop.ozone.recon.api.types.MissingContainersResponse;
import org.apache.hadoop.ozone.recon.api.types.UnhealthyContainerMetadata;
import org.apache.hadoop.ozone.recon.api.types.UnhealthyContainersResponse;
import org.apache.hadoop.ozone.recon.api.types.UnhealthyContainersSummary;
import org.apache.hadoop.ozone.recon.persistence.ContainerHealthSchemaManager;
import org.apache.hadoop.ozone.recon.persistence.ContainerHistory;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.hadoop.ozone.recon.schema.ContainerSchemaDefinition;
import org.hadoop.ozone.recon.schema.tables.pojos.UnhealthyContainers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/containers")
@Produces(value={"application/json"})
@AdminOnly
public class ContainerEndpoint {
    @Inject
    private ReconContainerMetadataManager reconContainerMetadataManager;
    @Inject
    private ReconOMMetadataManager omMetadataManager;
    private final ReconContainerManager containerManager;
    private final PipelineManager pipelineManager;
    private final ContainerHealthSchemaManager containerHealthSchemaManager;
    private final ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private final OzoneStorageContainerManager reconSCM;
    private static final Logger LOG = LoggerFactory.getLogger(ContainerEndpoint.class);
    private BucketLayout layout = BucketLayout.DEFAULT;

    @Inject
    public ContainerEndpoint(OzoneStorageContainerManager reconSCM, ContainerHealthSchemaManager containerHealthSchemaManager, ReconNamespaceSummaryManager reconNamespaceSummaryManager) {
        this.containerManager = (ReconContainerManager)reconSCM.getContainerManager();
        this.pipelineManager = reconSCM.getPipelineManager();
        this.containerHealthSchemaManager = containerHealthSchemaManager;
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
        this.reconSCM = reconSCM;
    }

    @GET
    public Response getContainers(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="prevKey") long prevKey) {
        if (limit < 0 || prevKey < 0L) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        List<ContainerMetadata> containerMetaDataList = this.containerManager.getContainers(ContainerID.valueOf((long)(prevKey + 1L)), limit).stream().map(container -> {
            ContainerMetadata containerMetadata = new ContainerMetadata(container.getContainerID());
            containerMetadata.setNumberOfKeys(container.getNumberOfKeys());
            return containerMetadata;
        }).collect(Collectors.toList());
        long containersCount = containerMetaDataList.size();
        long lastContainerID = containerMetaDataList.isEmpty() ? prevKey : ((ContainerMetadata)containerMetaDataList.get(containerMetaDataList.size() - 1)).getContainerID();
        ContainersResponse containersResponse = new ContainersResponse(containersCount, containerMetaDataList, lastContainerID);
        return Response.ok((Object)containersResponse).build();
    }

    @GET
    @Path(value="/{id}/keys")
    public Response getKeysForContainer(@PathParam(value="id") Long containerID, @DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="prevKey") String prevKeyPrefix) {
        long totalCount;
        LinkedHashMap<String, KeyMetadata> keyMetadataMap = new LinkedHashMap<String, KeyMetadata>();
        try {
            Map<ContainerKeyPrefix, Integer> containerKeyPrefixMap = this.reconContainerMetadataManager.getKeyPrefixesForContainer(containerID, prevKeyPrefix);
            for (ContainerKeyPrefix containerKeyPrefix : containerKeyPrefixMap.keySet()) {
                OmKeyInfo omKeyInfo = (OmKeyInfo)this.omMetadataManager.getKeyTable(BucketLayout.LEGACY).getSkipCache((Object)containerKeyPrefix.getKeyPrefix());
                if (omKeyInfo == null) {
                    omKeyInfo = (OmKeyInfo)this.omMetadataManager.getKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).getSkipCache((Object)containerKeyPrefix.getKeyPrefix());
                }
                if (null == omKeyInfo) continue;
                List<OmKeyLocationInfoGroup> matchedKeys = omKeyInfo.getKeyLocationVersions().stream().filter(k -> k.getVersion() == containerKeyPrefix.getKeyVersion()).collect(Collectors.toList());
                List<KeyMetadata.ContainerBlockMetadata> blockIds = this.getBlocks(matchedKeys, containerID);
                String ozoneKey = this.omMetadataManager.getOzoneKey(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), omKeyInfo.getKeyName());
                if (keyMetadataMap.containsKey(ozoneKey)) {
                    ((KeyMetadata)keyMetadataMap.get(ozoneKey)).getVersions().add(containerKeyPrefix.getKeyVersion());
                    ((KeyMetadata)keyMetadataMap.get(ozoneKey)).getBlockIds().put(containerKeyPrefix.getKeyVersion(), blockIds);
                    continue;
                }
                if (keyMetadataMap.size() == limit) break;
                KeyMetadata keyMetadata = new KeyMetadata();
                keyMetadata.setBucket(omKeyInfo.getBucketName());
                keyMetadata.setVolume(omKeyInfo.getVolumeName());
                keyMetadata.setKey(omKeyInfo.getKeyName());
                keyMetadata.setCreationTime(Instant.ofEpochMilli(omKeyInfo.getCreationTime()));
                keyMetadata.setModificationTime(Instant.ofEpochMilli(omKeyInfo.getModificationTime()));
                keyMetadata.setDataSize(omKeyInfo.getDataSize());
                keyMetadata.getVersions().add(containerKeyPrefix.getKeyVersion());
                keyMetadataMap.put(ozoneKey, keyMetadata);
                keyMetadata.getBlockIds().put(containerKeyPrefix.getKeyVersion(), blockIds);
            }
            totalCount = this.reconContainerMetadataManager.getKeyCountForContainer(containerID);
        }
        catch (IOException ioEx) {
            throw new WebApplicationException((Throwable)ioEx, Response.Status.INTERNAL_SERVER_ERROR);
        }
        KeysResponse keysResponse = new KeysResponse(totalCount, keyMetadataMap.values());
        return Response.ok((Object)keysResponse).build();
    }

    @GET
    @Path(value="/{id}/replicaHistory")
    public Response getReplicaHistoryForContainer(@PathParam(value="id") Long containerID) {
        return Response.ok(this.containerManager.getAllContainerHistory(containerID)).build();
    }

    @GET
    @Path(value="/missing")
    @Deprecated
    public Response getMissingContainers(@DefaultValue(value="1000") @QueryParam(value="limit") int limit) {
        ArrayList<MissingContainerMetadata> missingContainers = new ArrayList<MissingContainerMetadata>();
        this.containerHealthSchemaManager.getUnhealthyContainers(ContainerSchemaDefinition.UnHealthyContainerStates.MISSING, 0, limit).forEach(container -> {
            long containerID = container.getContainerId();
            try {
                ContainerInfo containerInfo = this.containerManager.getContainer(ContainerID.valueOf((long)containerID));
                long keyCount = containerInfo.getNumberOfKeys();
                UUID pipelineID = containerInfo.getPipelineID().getId();
                List<ContainerHistory> datanodes = this.containerManager.getLatestContainerHistory(containerID, containerInfo.getReplicationConfig().getRequiredNodes());
                missingContainers.add(new MissingContainerMetadata(containerID, container.getInStateSince(), keyCount, pipelineID, datanodes));
            }
            catch (IOException ioEx) {
                throw new WebApplicationException((Throwable)ioEx, Response.Status.INTERNAL_SERVER_ERROR);
            }
        });
        MissingContainersResponse response = new MissingContainersResponse(missingContainers.size(), missingContainers);
        return Response.ok((Object)response).build();
    }

    @GET
    @Path(value="/unhealthy/{state}")
    public Response getUnhealthyContainers(@PathParam(value="state") String state, @DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="1") @QueryParam(value="batchNum") int batchNum) {
        List<UnhealthyContainersSummary> summary;
        int offset = Math.max((batchNum - 1) * limit, 0);
        ArrayList<UnhealthyContainerMetadata> unhealthyMeta = new ArrayList<UnhealthyContainerMetadata>();
        try {
            ContainerSchemaDefinition.UnHealthyContainerStates internalState = null;
            if (state != null) {
                internalState = ContainerSchemaDefinition.UnHealthyContainerStates.valueOf((String)state);
            }
            summary = this.containerHealthSchemaManager.getUnhealthyContainersSummary();
            List<UnhealthyContainers> containers = this.containerHealthSchemaManager.getUnhealthyContainers(internalState, offset, limit);
            for (UnhealthyContainers c : containers) {
                long containerID = c.getContainerId();
                ContainerInfo containerInfo = this.containerManager.getContainer(ContainerID.valueOf((long)containerID));
                long keyCount = containerInfo.getNumberOfKeys();
                UUID pipelineID = containerInfo.getPipelineID().getId();
                List<ContainerHistory> datanodes = this.containerManager.getLatestContainerHistory(containerID, containerInfo.getReplicationConfig().getRequiredNodes());
                unhealthyMeta.add(new UnhealthyContainerMetadata(c, datanodes, pipelineID, keyCount));
            }
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        UnhealthyContainersResponse response = new UnhealthyContainersResponse(unhealthyMeta);
        for (UnhealthyContainersSummary s : summary) {
            response.setSummaryCount(s.getContainerState(), s.getCount());
        }
        return Response.ok((Object)response).build();
    }

    @GET
    @Path(value="/unhealthy")
    public Response getUnhealthyContainers(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="1") @QueryParam(value="batchNum") int batchNum) {
        return this.getUnhealthyContainers(null, limit, batchNum);
    }

    @GET
    @Path(value="/deleted")
    public Response getSCMDeletedContainers(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="prevKey") long prevKey) {
        ArrayList deletedContainerInfoList = new ArrayList();
        try {
            List<ContainerInfo> containers = this.containerManager.getContainers(ContainerID.valueOf((long)prevKey), limit, HddsProtos.LifeCycleState.DELETED);
            containers = containers.stream().filter(containerInfo -> containerInfo.getContainerID() != prevKey).collect(Collectors.toList());
            containers.forEach(containerInfo -> {
                DeletedContainerInfo deletedContainerInfo = new DeletedContainerInfo();
                deletedContainerInfo.setContainerID(containerInfo.getContainerID());
                deletedContainerInfo.setPipelineID(containerInfo.getPipelineID());
                deletedContainerInfo.setNumberOfKeys(containerInfo.getNumberOfKeys());
                deletedContainerInfo.setContainerState(containerInfo.getState().name());
                deletedContainerInfo.setStateEnterTime(containerInfo.getStateEnterTime().toEpochMilli());
                deletedContainerInfo.setLastUsed(containerInfo.getLastUsed().toEpochMilli());
                deletedContainerInfo.setUsedBytes(containerInfo.getUsedBytes());
                deletedContainerInfo.setReplicationConfig(containerInfo.getReplicationConfig());
                deletedContainerInfo.setReplicationFactor(containerInfo.getReplicationFactor().name());
                deletedContainerInfoList.add(deletedContainerInfo);
            });
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.ok(deletedContainerInfoList).build();
    }

    private List<KeyMetadata.ContainerBlockMetadata> getBlocks(List<OmKeyLocationInfoGroup> matchedKeys, long containerID) {
        ArrayList<KeyMetadata.ContainerBlockMetadata> blockIds = new ArrayList<KeyMetadata.ContainerBlockMetadata>();
        for (OmKeyLocationInfoGroup omKeyLocationInfoGroup : matchedKeys) {
            List omKeyLocationInfos = omKeyLocationInfoGroup.getLocationList().stream().filter(c -> c.getContainerID() == containerID).collect(Collectors.toList());
            for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfos) {
                blockIds.add(new KeyMetadata.ContainerBlockMetadata(omKeyLocationInfo.getContainerID(), omKeyLocationInfo.getLocalID()));
            }
        }
        return blockIds;
    }

    @GET
    @Path(value="/mismatch")
    public Response getContainerMisMatchInsights(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="prevKey") long prevKey, @DefaultValue(value="SCM") @QueryParam(value="missingIn") String missingIn) {
        if (prevKey < 0L || limit < 0) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        ArrayList containerDiscrepancyInfoList = new ArrayList();
        try {
            Map<Long, ContainerMetadata> omContainers = this.reconContainerMetadataManager.getContainers(-1, -1L);
            List scmNonDeletedContainers = this.containerManager.getContainers().stream().filter(containerInfo -> containerInfo.getState() != HddsProtos.LifeCycleState.DELETED).map(containerInfo -> containerInfo.getContainerID()).collect(Collectors.toList());
            DataFilter dataFilter = DataFilter.fromValue(missingIn.toUpperCase());
            switch (dataFilter) {
                case SCM: {
                    List notSCMContainers = omContainers.entrySet().stream().filter(containerMetadataEntry -> !scmNonDeletedContainers.contains(containerMetadataEntry.getKey())).collect(Collectors.toList());
                    if (prevKey > 0L) {
                        int index;
                        for (index = 0; index < notSCMContainers.size() && (Long)((Map.Entry)notSCMContainers.get(index)).getKey() <= prevKey; ++index) {
                        }
                        notSCMContainers = index < notSCMContainers.size() ? notSCMContainers.subList(index, Math.min(index + limit, notSCMContainers.size())) : Collections.emptyList();
                    } else {
                        notSCMContainers = notSCMContainers.subList(0, Math.min(limit, notSCMContainers.size()));
                    }
                    notSCMContainers.forEach(nonSCMContainer -> {
                        ContainerDiscrepancyInfo containerDiscrepancyInfo = new ContainerDiscrepancyInfo();
                        containerDiscrepancyInfo.setContainerID((Long)nonSCMContainer.getKey());
                        containerDiscrepancyInfo.setNumberOfKeys(((ContainerMetadata)nonSCMContainer.getValue()).getNumberOfKeys());
                        containerDiscrepancyInfo.setPipelines(((ContainerMetadata)nonSCMContainer.getValue()).getPipelines());
                        containerDiscrepancyInfo.setExistsAt("OM");
                        containerDiscrepancyInfoList.add(containerDiscrepancyInfo);
                    });
                    break;
                }
                case OM: {
                    List<Long> nonOMContainers = scmNonDeletedContainers.stream().filter(containerId -> !omContainers.containsKey(containerId)).collect(Collectors.toList());
                    if (prevKey > 0L) {
                        int index;
                        for (index = 0; index < nonOMContainers.size() && (Long)nonOMContainers.get(index) <= prevKey; ++index) {
                        }
                        nonOMContainers = index < nonOMContainers.size() ? nonOMContainers.subList(index, Math.min(index + limit, nonOMContainers.size())) : Collections.emptyList();
                    } else {
                        nonOMContainers = nonOMContainers.subList(0, Math.min(limit, nonOMContainers.size()));
                    }
                    ArrayList pipelines = new ArrayList();
                    nonOMContainers.forEach(nonOMContainerId -> {
                        boolean containerExistsInScm = true;
                        ContainerDiscrepancyInfo containerDiscrepancyInfo = new ContainerDiscrepancyInfo();
                        containerDiscrepancyInfo.setContainerID((long)nonOMContainerId);
                        containerDiscrepancyInfo.setNumberOfKeys(0L);
                        PipelineID pipelineID = null;
                        try {
                            pipelineID = this.containerManager.getContainer(ContainerID.valueOf((long)nonOMContainerId)).getPipelineID();
                            if (pipelineID != null) {
                                pipelines.add(this.pipelineManager.getPipeline(pipelineID));
                            }
                        }
                        catch (ContainerNotFoundException e) {
                            containerExistsInScm = false;
                            LOG.warn("Container {} not found in SCM: {}", nonOMContainerId, (Object)e);
                        }
                        catch (PipelineNotFoundException e) {
                            LOG.debug("Pipeline not found for container: {} and pipelineId: {}", new Object[]{nonOMContainerId, pipelineID, e});
                        }
                        if (containerExistsInScm) {
                            containerDiscrepancyInfo.setPipelines(pipelines);
                            containerDiscrepancyInfo.setExistsAt("SCM");
                            containerDiscrepancyInfoList.add(containerDiscrepancyInfo);
                        }
                    });
                    break;
                }
                default: {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        if (!containerDiscrepancyInfoList.isEmpty()) {
            response.put("lastKey", Long.valueOf(((ContainerDiscrepancyInfo)containerDiscrepancyInfoList.get(containerDiscrepancyInfoList.size() - 1)).getContainerID()));
        } else {
            response.put("lastKey", null);
        }
        response.put("containerDiscrepancyInfo", containerDiscrepancyInfoList);
        return Response.ok(response).build();
    }

    @GET
    @Path(value="/mismatch/deleted")
    public Response getOmContainersDeletedInSCM(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="prevKey") long prevKey) {
        if (prevKey < 0L) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        ArrayList containerDiscrepancyInfoList = new ArrayList();
        try {
            Map<Long, ContainerMetadata> omContainers = this.reconContainerMetadataManager.getContainers(limit, prevKey);
            List deletedStateSCMContainerIds = this.containerManager.getContainers().stream().filter(containerInfo -> containerInfo.getState() == HddsProtos.LifeCycleState.DELETED).map(containerInfo -> containerInfo.getContainerID()).collect(Collectors.toList());
            List<Map.Entry> omContainersDeletedInSCM = omContainers.entrySet().stream().filter(containerMetadataEntry -> deletedStateSCMContainerIds.contains(containerMetadataEntry.getKey())).collect(Collectors.toList());
            omContainersDeletedInSCM.forEach(containerMetadataEntry -> {
                ContainerDiscrepancyInfo containerDiscrepancyInfo = new ContainerDiscrepancyInfo();
                containerDiscrepancyInfo.setContainerID((Long)containerMetadataEntry.getKey());
                containerDiscrepancyInfo.setNumberOfKeys(((ContainerMetadata)containerMetadataEntry.getValue()).getNumberOfKeys());
                containerDiscrepancyInfo.setPipelines(((ContainerMetadata)containerMetadataEntry.getValue()).getPipelines());
                containerDiscrepancyInfoList.add(containerDiscrepancyInfo);
            });
        }
        catch (IOException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        if (!containerDiscrepancyInfoList.isEmpty()) {
            response.put("lastKey", Long.valueOf(((ContainerDiscrepancyInfo)containerDiscrepancyInfoList.get(containerDiscrepancyInfoList.size() - 1)).getContainerID()));
        } else {
            response.put("lastKey", null);
        }
        response.put("containerDiscrepancyInfo", containerDiscrepancyInfoList);
        return Response.ok(response).build();
    }

    public static enum DataFilter {
        SCM("SCM"),
        OM("OM");

        private final String value;

        private DataFilter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static DataFilter fromValue(String value) {
            for (DataFilter filter : DataFilter.values()) {
                if (!filter.getValue().equalsIgnoreCase(value)) continue;
                return filter;
            }
            throw new IllegalArgumentException("Invalid DataFilter value: " + value);
        }
    }
}

