/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.recon.api.AdminOnly;
import org.apache.hadoop.ozone.recon.api.handlers.EntityHandler;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.api.types.FileSizeDistributionResponse;
import org.apache.hadoop.ozone.recon.api.types.NamespaceSummaryResponse;
import org.apache.hadoop.ozone.recon.api.types.QuotaUsageResponse;
import org.apache.hadoop.ozone.recon.api.types.ResponseStatus;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;

@Path(value="/namespace")
@Produces(value={"application/json"})
@AdminOnly
public class NSSummaryEndpoint {
    private final ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private final ReconOMMetadataManager omMetadataManager;
    private final OzoneStorageContainerManager reconSCM;

    @Inject
    public NSSummaryEndpoint(ReconNamespaceSummaryManager namespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM) {
        this.reconNamespaceSummaryManager = namespaceSummaryManager;
        this.omMetadataManager = omMetadataManager;
        this.reconSCM = reconSCM;
    }

    @GET
    @Path(value="/summary")
    public Response getBasicInfo(@QueryParam(value="path") String path) throws IOException {
        if (path == null || path.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.isInitializationComplete()) {
            NamespaceSummaryResponse namespaceSummaryResponse = NamespaceSummaryResponse.newBuilder().setEntityType(EntityType.UNKNOWN).setStatus(ResponseStatus.INITIALIZING).build();
            return Response.ok((Object)namespaceSummaryResponse).build();
        }
        EntityHandler handler = EntityHandler.getEntityHandler(this.reconNamespaceSummaryManager, this.omMetadataManager, this.reconSCM, path);
        NamespaceSummaryResponse namespaceSummaryResponse = handler.getSummaryResponse();
        return Response.ok((Object)namespaceSummaryResponse).build();
    }

    @GET
    @Path(value="/du")
    public Response getDiskUsage(@QueryParam(value="path") String path, @DefaultValue(value="false") @QueryParam(value="files") boolean listFile, @DefaultValue(value="false") @QueryParam(value="replica") boolean withReplica) throws IOException {
        if (path == null || path.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        DUResponse duResponse = new DUResponse();
        if (!this.isInitializationComplete()) {
            duResponse.setStatus(ResponseStatus.INITIALIZING);
            return Response.ok((Object)duResponse).build();
        }
        EntityHandler handler = EntityHandler.getEntityHandler(this.reconNamespaceSummaryManager, this.omMetadataManager, this.reconSCM, path);
        duResponse = handler.getDuResponse(listFile, withReplica);
        return Response.ok((Object)duResponse).build();
    }

    @GET
    @Path(value="/quota")
    public Response getQuotaUsage(@QueryParam(value="path") String path) throws IOException {
        if (path == null || path.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        QuotaUsageResponse quotaUsageResponse = new QuotaUsageResponse();
        if (!this.isInitializationComplete()) {
            quotaUsageResponse.setResponseCode(ResponseStatus.INITIALIZING);
            return Response.ok((Object)quotaUsageResponse).build();
        }
        EntityHandler handler = EntityHandler.getEntityHandler(this.reconNamespaceSummaryManager, this.omMetadataManager, this.reconSCM, path);
        quotaUsageResponse = handler.getQuotaResponse();
        return Response.ok((Object)quotaUsageResponse).build();
    }

    @GET
    @Path(value="/dist")
    public Response getFileSizeDistribution(@QueryParam(value="path") String path) throws IOException {
        if (path == null || path.length() == 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        FileSizeDistributionResponse distResponse = new FileSizeDistributionResponse();
        if (!this.isInitializationComplete()) {
            distResponse.setStatus(ResponseStatus.INITIALIZING);
            return Response.ok((Object)distResponse).build();
        }
        EntityHandler handler = EntityHandler.getEntityHandler(this.reconNamespaceSummaryManager, this.omMetadataManager, this.reconSCM, path);
        distResponse = handler.getDistResponse();
        return Response.ok((Object)distResponse).build();
    }

    private boolean isInitializationComplete() {
        if (this.omMetadataManager == null) {
            return false;
        }
        return this.omMetadataManager.getVolumeTable() != null && this.omMetadataManager.getBucketTable() != null && this.omMetadataManager.getDirectoryTable() != null && this.omMetadataManager.getFileTable() != null && this.omMetadataManager.getKeyTable(BucketLayout.LEGACY) != null;
    }
}

