/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.node.DatanodeInfo;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.recon.api.types.DatanodeMetadata;
import org.apache.hadoop.ozone.recon.api.types.DatanodePipeline;
import org.apache.hadoop.ozone.recon.api.types.DatanodeStorageReport;
import org.apache.hadoop.ozone.recon.api.types.DatanodesResponse;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.apache.hadoop.ozone.recon.scm.ReconNodeManager;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/datanodes")
@Produces(value={"application/json"})
public class NodeEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(NodeEndpoint.class);
    private ReconNodeManager nodeManager;
    private ReconPipelineManager pipelineManager;
    private ReconContainerManager reconContainerManager;

    @Inject
    NodeEndpoint(OzoneStorageContainerManager reconSCM) {
        this.nodeManager = (ReconNodeManager)reconSCM.getScmNodeManager();
        this.reconContainerManager = (ReconContainerManager)reconSCM.getContainerManager();
        this.pipelineManager = (ReconPipelineManager)reconSCM.getPipelineManager();
    }

    @GET
    public Response getDatanodes() {
        ArrayList<DatanodeMetadata> datanodes = new ArrayList<DatanodeMetadata>();
        List datanodeDetails = this.nodeManager.getAllNodes();
        datanodeDetails.forEach(datanode -> {
            DatanodeStorageReport storageReport = this.getStorageReport((DatanodeDetails)datanode);
            HddsProtos.NodeState nodeState = null;
            try {
                nodeState = this.nodeManager.getNodeStatus((DatanodeDetails)datanode).getHealth();
            }
            catch (NodeNotFoundException e) {
                LOG.warn("Cannot get nodeState for datanode {}", datanode, (Object)e);
            }
            HddsProtos.NodeOperationalState nodeOpState = datanode.getPersistedOpState();
            String hostname = datanode.getHostName();
            Set pipelineIDs = this.nodeManager.getPipelines((DatanodeDetails)datanode);
            ArrayList<DatanodePipeline> pipelines = new ArrayList<DatanodePipeline>();
            AtomicInteger leaderCount = new AtomicInteger();
            AtomicInteger openContainers = new AtomicInteger();
            DatanodeMetadata.Builder builder = DatanodeMetadata.newBuilder();
            pipelineIDs.forEach(pipelineID -> {
                try {
                    Pipeline pipeline = this.pipelineManager.getPipeline((PipelineID)pipelineID);
                    String leaderNode = pipeline.getLeaderNode().getHostName();
                    DatanodePipeline datanodePipeline = new DatanodePipeline(pipelineID.getId(), pipeline.getReplicationConfig(), leaderNode);
                    pipelines.add(datanodePipeline);
                    if (datanode.getUuid().equals(pipeline.getLeaderId())) {
                        leaderCount.getAndIncrement();
                    }
                    int openContainerPerPipeline = this.reconContainerManager.getPipelineToOpenContainer().getOrDefault(pipelineID, 0);
                    openContainers.getAndAdd(openContainerPerPipeline);
                }
                catch (PipelineNotFoundException ex) {
                    LOG.warn("Cannot get pipeline {} for datanode {}, pipeline not found", new Object[]{pipelineID.getId(), hostname, ex});
                }
                catch (IOException ioEx) {
                    LOG.warn("Cannot get leader node of pipeline with id {}.", (Object)pipelineID.getId(), (Object)ioEx);
                }
            });
            try {
                Set allContainers = this.nodeManager.getContainers((DatanodeDetails)datanode);
                builder.withContainers(allContainers.size());
                builder.withOpenContainers(openContainers.get());
            }
            catch (NodeNotFoundException ex) {
                LOG.warn("Cannot get containers, datanode {} not found.", (Object)datanode.getUuid(), (Object)ex);
            }
            DatanodeInfo dnInfo = (DatanodeInfo)datanode;
            datanodes.add(builder.withHostname(this.nodeManager.getHostName((DatanodeDetails)datanode)).withDatanodeStorageReport(storageReport).withLastHeartbeat(this.nodeManager.getLastHeartbeat((DatanodeDetails)datanode)).withState(nodeState).withOperationalState(nodeOpState).withPipelines(pipelines).withLeaderCount(leaderCount.get()).withUUid(datanode.getUuidString()).withVersion(this.nodeManager.getVersion((DatanodeDetails)datanode)).withSetupTime(this.nodeManager.getSetupTime((DatanodeDetails)datanode)).withRevision(this.nodeManager.getRevision((DatanodeDetails)datanode)).withBuildDate(this.nodeManager.getBuildDate((DatanodeDetails)datanode)).withLayoutVersion(dnInfo.getLastKnownLayoutVersion().getMetadataLayoutVersion()).withNetworkLocation(datanode.getNetworkLocation()).build());
        });
        DatanodesResponse datanodesResponse = new DatanodesResponse(datanodes.size(), datanodes);
        return Response.ok((Object)datanodesResponse).build();
    }

    private DatanodeStorageReport getStorageReport(DatanodeDetails datanode) {
        SCMNodeStat nodeStat = this.nodeManager.getNodeStat(datanode).get();
        long capacity = nodeStat.getCapacity().get();
        long used = nodeStat.getScmUsed().get();
        long remaining = nodeStat.getRemaining().get();
        return new DatanodeStorageReport(capacity, used, remaining);
    }
}

