/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.handlers;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.api.handlers.BucketHandler;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSOBucketHandler
extends BucketHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FSOBucketHandler.class);
    private final long volumeId;
    private final long bucketId;

    public FSOBucketHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, OmBucketInfo bucketInfo) throws IOException {
        super(reconNamespaceSummaryManager, omMetadataManager, reconSCM);
        String vol = bucketInfo.getVolumeName();
        String bucket = bucketInfo.getBucketName();
        String[] names = new String[]{vol, bucket};
        this.volumeId = this.getVolumeObjectId(names);
        this.bucketId = this.getBucketObjectId(names);
    }

    @Override
    public EntityType determineKeyPath(String keyName) throws IOException {
        Path keyPath = Paths.get(keyName, new String[0]);
        Iterator<Path> elements = keyPath.iterator();
        long lastKnownParentId = this.bucketId;
        OmDirectoryInfo omDirInfo = null;
        while (elements.hasNext()) {
            String fileName = elements.next().toString();
            String dbNodeName = this.getOmMetadataManager().getOzonePathKey(this.volumeId, this.bucketId, lastKnownParentId, fileName);
            omDirInfo = (OmDirectoryInfo)this.getOmMetadataManager().getDirectoryTable().getSkipCache((Object)dbNodeName);
            if (omDirInfo != null) {
                lastKnownParentId = omDirInfo.getObjectID();
                continue;
            }
            if (!elements.hasNext()) {
                OmKeyInfo omKeyInfo = (OmKeyInfo)this.getOmMetadataManager().getFileTable().getSkipCache((Object)dbNodeName);
                if (omKeyInfo == null) continue;
                omKeyInfo.setKeyName(keyName);
                return EntityType.KEY;
            }
            return EntityType.UNKNOWN;
        }
        if (omDirInfo != null) {
            return EntityType.DIRECTORY;
        }
        return EntityType.UNKNOWN;
    }

    @Override
    public long calculateDUUnderObject(long parentId) throws IOException {
        NSSummary nsSummary;
        Table keyTable = this.getOmMetadataManager().getFileTable();
        long totalDU = 0L;
        try (TableIterator iterator = keyTable.iterator();){
            String seekPrefix = "/" + this.volumeId + "/" + this.bucketId + "/" + parentId + "/";
            iterator.seek((Object)seekPrefix);
            while (iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                String dbKey = (String)kv.getKey();
                if (!dbKey.startsWith(seekPrefix)) {
                    break;
                }
                OmKeyInfo keyInfo = (OmKeyInfo)kv.getValue();
                if (keyInfo == null) continue;
                totalDU += keyInfo.getReplicatedSize();
            }
        }
        if ((nsSummary = this.getReconNamespaceSummaryManager().getNSSummary(parentId)) == null) {
            return 0L;
        }
        Set<Long> subDirIds = nsSummary.getChildDir();
        for (long subDirId : subDirIds) {
            totalDU += this.calculateDUUnderObject(subDirId);
        }
        return totalDU;
    }

    @Override
    public long handleDirectKeys(long parentId, boolean withReplica, boolean listFile, List<DUResponse.DiskUsage> duData, String normalizedPath) throws IOException {
        Table keyTable = this.getOmMetadataManager().getFileTable();
        long keyDataSizeWithReplica = 0L;
        try (TableIterator iterator = keyTable.iterator();){
            String seekPrefix = "/" + this.volumeId + "/" + this.bucketId + "/" + parentId + "/";
            iterator.seek((Object)seekPrefix);
            while (iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                String dbKey = (String)kv.getKey();
                if (!dbKey.startsWith(seekPrefix)) {
                    break;
                }
                OmKeyInfo keyInfo = (OmKeyInfo)kv.getValue();
                if (keyInfo == null) continue;
                DUResponse.DiskUsage diskUsage = new DUResponse.DiskUsage();
                String subpath = FSOBucketHandler.buildSubpath(normalizedPath, keyInfo.getFileName());
                diskUsage.setSubpath(subpath);
                diskUsage.setKey(true);
                diskUsage.setSize(keyInfo.getDataSize());
                if (withReplica) {
                    long keyDU = keyInfo.getReplicatedSize();
                    keyDataSizeWithReplica += keyDU;
                    diskUsage.setSizeWithReplica(keyDU);
                }
                if (!listFile) continue;
                duData.add(diskUsage);
            }
        }
        return keyDataSizeWithReplica;
    }

    @Override
    public long getDirObjectId(String[] names) throws IOException {
        return this.getDirObjectId(names, names.length);
    }

    @Override
    public long getDirObjectId(String[] names, int cutoff) throws IOException {
        long dirObjectId = this.getBucketObjectId(names);
        for (int i = 2; i < cutoff; ++i) {
            String dirKey = this.getOmMetadataManager().getOzonePathKey(this.getVolumeObjectId(names), this.getBucketObjectId(names), dirObjectId, names[i]);
            OmDirectoryInfo dirInfo = (OmDirectoryInfo)this.getOmMetadataManager().getDirectoryTable().getSkipCache((Object)dirKey);
            if (null == dirInfo) continue;
            dirObjectId = dirInfo.getObjectID();
        }
        return dirObjectId;
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.FILE_SYSTEM_OPTIMIZED;
    }

    @Override
    public OmKeyInfo getKeyInfo(String[] names) throws IOException {
        long parentObjectId = this.getDirObjectId(names, names.length - 1);
        String fileName = names[names.length - 1];
        String ozoneKey = this.getOmMetadataManager().getOzonePathKey(this.volumeId, this.bucketId, parentObjectId, fileName);
        return (OmKeyInfo)this.getOmMetadataManager().getFileTable().getSkipCache((Object)ozoneKey);
    }

    @Override
    public OmDirectoryInfo getDirInfo(String[] names) throws IOException {
        String path = "/";
        path = path + String.join((CharSequence)"/", names);
        Preconditions.checkArgument((names.length >= 3 ? 1 : 0) != 0, (String)"Path should be a directory: %s", (Object)path);
        long parentObjectId = this.getDirObjectId(names, names.length - 1);
        String dirKey = this.getOmMetadataManager().getOzonePathKey(this.getVolumeObjectId(names), this.getBucketObjectId(names), parentObjectId, names[names.length - 1]);
        OmDirectoryInfo dirInfo = (OmDirectoryInfo)this.getOmMetadataManager().getDirectoryTable().getSkipCache((Object)dirKey);
        return dirInfo;
    }
}

