/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.handlers;

import java.io.IOException;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.recon.api.handlers.EntityHandler;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.api.types.FileSizeDistributionResponse;
import org.apache.hadoop.ozone.recon.api.types.NamespaceSummaryResponse;
import org.apache.hadoop.ozone.recon.api.types.QuotaUsageResponse;
import org.apache.hadoop.ozone.recon.api.types.ResponseStatus;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;

public class UnknownEntityHandler
extends EntityHandler {
    public UnknownEntityHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM) {
        super(reconNamespaceSummaryManager, omMetadataManager, reconSCM, null, null);
    }

    @Override
    public NamespaceSummaryResponse getSummaryResponse() throws IOException {
        return NamespaceSummaryResponse.newBuilder().setEntityType(EntityType.UNKNOWN).setStatus(ResponseStatus.PATH_NOT_FOUND).build();
    }

    @Override
    public DUResponse getDuResponse(boolean listFile, boolean withReplica) throws IOException {
        DUResponse duResponse = new DUResponse();
        duResponse.setStatus(ResponseStatus.PATH_NOT_FOUND);
        return duResponse;
    }

    @Override
    public QuotaUsageResponse getQuotaResponse() throws IOException {
        QuotaUsageResponse quotaUsageResponse = new QuotaUsageResponse();
        quotaUsageResponse.setResponseCode(ResponseStatus.PATH_NOT_FOUND);
        return quotaUsageResponse;
    }

    @Override
    public FileSizeDistributionResponse getDistResponse() throws IOException {
        FileSizeDistributionResponse distResponse = new FileSizeDistributionResponse();
        distResponse.setStatus(ResponseStatus.PATH_NOT_FOUND);
        return distResponse;
    }
}

