/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.executor.DaemonThreadFactory;
import org.jboss.weld.executor.SecurityActions;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.api.ExecutorServices;

public abstract class AbstractExecutorServices
implements ExecutorServices {
    private static final long SHUTDOWN_TIMEOUT = 60L;
    private final ScheduledExecutorService timerExecutor = Executors.newScheduledThreadPool(1, new DaemonThreadFactory(new ThreadGroup("weld-workers"), "weld-timer-"));

    @Override
    public ScheduledExecutorService getTimerExecutor() {
        return this.timerExecutor;
    }

    @Override
    public <T> List<Future<T>> invokeAllAndCheckForExceptions(Collection<? extends Callable<T>> tasks) {
        try {
            return this.checkForExceptions(this.getTaskExecutor().invokeAll(this.wrap(tasks)));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DeploymentException(e);
        }
    }

    @Override
    public <T> List<Future<T>> invokeAllAndCheckForExceptions(ExecutorServices.TaskFactory<T> factory) {
        return this.invokeAllAndCheckForExceptions(factory.createTasks(this.getThreadPoolSize()));
    }

    protected <T> List<Future<T>> checkForExceptions(List<Future<T>> futures) {
        for (Future<T> result : futures) {
            try {
                result.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WeldException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)RuntimeException.class.cast(cause);
                }
                throw new WeldException(cause);
            }
        }
        return futures;
    }

    protected abstract int getThreadPoolSize();

    @Override
    public void cleanup() {
        this.shutdown();
    }

    protected void shutdown() {
        SecurityActions.shutdown(this.getTaskExecutor());
        SecurityActions.shutdown(this.getTimerExecutor());
        try {
            if (!this.getTaskExecutor().awaitTermination(60L, TimeUnit.SECONDS)) {
                SecurityActions.shutdownNow(this.getTaskExecutor());
                if (!this.getTaskExecutor().awaitTermination(60L, TimeUnit.SECONDS)) {
                    BootstrapLogger.LOG.timeoutShuttingDownThreadPool(this.getTaskExecutor(), this);
                }
            }
        }
        catch (InterruptedException ie) {
            SecurityActions.shutdownNow(this.getTaskExecutor());
            Thread.currentThread().interrupt();
        }
        try {
            if (!this.getTimerExecutor().isShutdown()) {
                SecurityActions.shutdownNow(this.getTimerExecutor());
                if (!this.getTimerExecutor().awaitTermination(60L, TimeUnit.SECONDS)) {
                    BootstrapLogger.LOG.timeoutShuttingDownThreadPool(this.getTimerExecutor(), this);
                }
            }
        }
        catch (InterruptedException ie) {
            SecurityActions.shutdownNow(this.getTimerExecutor());
            Thread.currentThread().interrupt();
        }
    }

    public <T> Collection<? extends Callable<T>> wrap(Collection<? extends Callable<T>> tasks) {
        return tasks;
    }
}

