/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.hadoop.ozone.common.ChecksumByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumByteBufferImpl
implements ChecksumByteBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(ChecksumByteBufferImpl.class);
    private final Checksum checksum;
    private static final Field IS_READY_ONLY_FIELD;

    public ChecksumByteBufferImpl(Checksum impl) {
        this.checksum = impl;
    }

    @Override
    public void update(ByteBuffer buffer) {
        if (IS_READY_ONLY_FIELD != null) {
            try {
                IS_READY_ONLY_FIELD.setBoolean(buffer, false);
            }
            catch (IllegalAccessException e) {
                LOG.error("Cannot access isReadOnly in ByteBuffer", (Throwable)e);
            }
        }
        if (buffer.hasArray()) {
            this.checksum.update(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.remaining());
        } else {
            byte[] b = new byte[buffer.remaining()];
            buffer.get(b);
            this.checksum.update(b, 0, b.length);
        }
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.checksum.update(b, off, len);
    }

    @Override
    public void update(int i) {
        this.checksum.update(i);
    }

    @Override
    public long getValue() {
        return this.checksum.getValue();
    }

    @Override
    public void reset() {
        this.checksum.reset();
    }

    static {
        Field f = null;
        try {
            f = ByteBuffer.class.getDeclaredField("isReadOnly");
            f.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            LOG.error("No isReadOnly field in ByteBuffer", (Throwable)e);
        }
        IS_READY_ONLY_FIELD = f;
    }
}

