/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.QuotaUtil;
import org.apache.hadoop.ozone.om.helpers.WithParentObjectId;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OmKeyInfo
extends WithParentObjectId
implements CopyObject<OmKeyInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(OmKeyInfo.class);
    private static final Codec<OmKeyInfo> CODEC_TRUE = OmKeyInfo.newCodec(true);
    private static final Codec<OmKeyInfo> CODEC_FALSE = OmKeyInfo.newCodec(false);
    private final String volumeName;
    private final String bucketName;
    private String keyName;
    private long dataSize;
    private List<OmKeyLocationInfoGroup> keyLocationVersions;
    private final long creationTime;
    private long modificationTime;
    private ReplicationConfig replicationConfig;
    private FileEncryptionInfo encInfo;
    private final FileChecksum fileChecksum;
    private boolean isFile;
    private String fileName;
    private List<OzoneAcl> acls;

    private static Codec<OmKeyInfo> newCodec(boolean ignorePipeline) {
        return new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.KeyInfo.getDefaultInstance()), OmKeyInfo::getFromProtobuf, k -> k.getProtobuf(ignorePipeline, ClientVersion.CURRENT_VERSION));
    }

    public static Codec<OmKeyInfo> getCodec(boolean ignorePipeline) {
        LOG.info("OmKeyInfo.getCodec ignorePipeline = {}", (Object)ignorePipeline);
        return ignorePipeline ? CODEC_TRUE : CODEC_FALSE;
    }

    OmKeyInfo(String volumeName, String bucketName, String keyName, List<OmKeyLocationInfoGroup> versions, long dataSize, long creationTime, long modificationTime, ReplicationConfig replicationConfig, Map<String, String> metadata, FileEncryptionInfo encInfo, List<OzoneAcl> acls, long objectID, long updateID, FileChecksum fileChecksum) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.dataSize = dataSize;
        this.keyLocationVersions = versions;
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.replicationConfig = replicationConfig;
        this.metadata = metadata;
        this.encInfo = encInfo;
        this.acls = acls;
        this.objectID = objectID;
        this.updateID = updateID;
        this.fileChecksum = fileChecksum;
    }

    OmKeyInfo(String volumeName, String bucketName, String keyName, String fileName, List<OmKeyLocationInfoGroup> versions, long dataSize, long creationTime, long modificationTime, ReplicationConfig replicationConfig, Map<String, String> metadata, FileEncryptionInfo encInfo, List<OzoneAcl> acls, long parentObjectID, long objectID, long updateID, FileChecksum fileChecksum, boolean isFile) {
        this(volumeName, bucketName, keyName, versions, dataSize, creationTime, modificationTime, replicationConfig, metadata, encInfo, acls, objectID, updateID, fileChecksum);
        this.fileName = fileName;
        this.parentObjectID = parentObjectID;
        this.isFile = isFile;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getReplicatedSize() {
        return QuotaUtil.getReplicatedSize(this.getDataSize(), this.replicationConfig);
    }

    public void setDataSize(long size) {
        this.dataSize = size;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getParentObjectID() {
        return this.parentObjectID;
    }

    public synchronized OmKeyLocationInfoGroup getLatestVersionLocations() {
        return this.keyLocationVersions.size() == 0 ? null : this.keyLocationVersions.get(this.keyLocationVersions.size() - 1);
    }

    public List<OmKeyLocationInfoGroup> getKeyLocationVersions() {
        return this.keyLocationVersions;
    }

    public void setKeyLocationVersions(List<OmKeyLocationInfoGroup> keyLocationVersions) {
        this.keyLocationVersions = keyLocationVersions;
    }

    public void updateModifcationTime() {
        this.modificationTime = Time.monotonicNow();
    }

    public void setFile(boolean file) {
        this.isFile = file;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isHsync() {
        return this.metadata.containsKey("hsyncClientId");
    }

    public List<OmKeyLocationInfo> updateLocationInfoList(List<OmKeyLocationInfo> locationInfoList, boolean isMpu) {
        return this.updateLocationInfoList(locationInfoList, isMpu, false);
    }

    public List<OmKeyLocationInfo> updateLocationInfoList(List<OmKeyLocationInfo> locationInfoList, boolean isMpu, boolean skipBlockIDCheck) {
        ArrayList<OmKeyLocationInfo> uncommittedBlocks;
        List updatedBlockLocations;
        long latestVersion = this.getLatestVersionLocations().getVersion();
        OmKeyLocationInfoGroup keyLocationInfoGroup = this.getLatestVersionLocations();
        keyLocationInfoGroup.setMultipartKey(isMpu);
        if (skipBlockIDCheck) {
            updatedBlockLocations = locationInfoList;
            uncommittedBlocks = new ArrayList();
        } else {
            Pair<List<OmKeyLocationInfo>, List<OmKeyLocationInfo>> verifiedResult = this.verifyAndGetKeyLocations(locationInfoList, keyLocationInfoGroup);
            updatedBlockLocations = (List)verifiedResult.getLeft();
            uncommittedBlocks = (List)verifiedResult.getRight();
        }
        keyLocationInfoGroup.removeBlocks(latestVersion);
        updatedBlockLocations.forEach(omKeyLocationInfo -> omKeyLocationInfo.setCreateVersion(latestVersion));
        keyLocationInfoGroup.addAll(latestVersion, updatedBlockLocations);
        return uncommittedBlocks;
    }

    private Pair<List<OmKeyLocationInfo>, List<OmKeyLocationInfo>> verifyAndGetKeyLocations(List<OmKeyLocationInfo> locationInfoList, OmKeyLocationInfoGroup keyLocationInfoGroup) {
        HashMap<ContainerBlockID, OmKeyLocationInfo> allocatedBlockLocations = new HashMap<ContainerBlockID, OmKeyLocationInfo>();
        for (OmKeyLocationInfo omKeyLocationInfo : keyLocationInfoGroup.getLocationList()) {
            ContainerBlockID existingBlockID = omKeyLocationInfo.getBlockID().getContainerBlockID();
            allocatedBlockLocations.put(existingBlockID, omKeyLocationInfo);
        }
        ArrayList<OmKeyLocationInfo> updatedBlockLocations = new ArrayList<OmKeyLocationInfo>();
        for (OmKeyLocationInfo modifiedLocationInfo : locationInfoList) {
            ContainerBlockID modifiedContainerBlockId = modifiedLocationInfo.getBlockID().getContainerBlockID();
            if (allocatedBlockLocations.containsKey(modifiedContainerBlockId)) {
                updatedBlockLocations.add(modifiedLocationInfo);
                allocatedBlockLocations.remove(modifiedContainerBlockId);
                continue;
            }
            LOG.warn("Unknown BlockLocation:{}, where the blockID of given location doesn't match with the stored/allocated block of keyName:{}", (Object)modifiedLocationInfo, (Object)this.keyName);
        }
        ArrayList arrayList = new ArrayList(allocatedBlockLocations.values());
        return Pair.of(updatedBlockLocations, arrayList);
    }

    public synchronized void appendNewBlocks(List<OmKeyLocationInfo> newLocationList, boolean updateTime) throws IOException {
        if (this.keyLocationVersions.size() == 0) {
            throw new IOException("Appending new block, but no version exist");
        }
        OmKeyLocationInfoGroup currentLatestVersion = this.keyLocationVersions.get(this.keyLocationVersions.size() - 1);
        currentLatestVersion.appendNewBlocks(newLocationList);
        if (updateTime) {
            this.setModificationTime(Time.now());
        }
    }

    public synchronized long addNewVersion(List<OmKeyLocationInfo> newLocationList, boolean updateTime, boolean keepOldVersions) {
        long latestVersionNum;
        if (!keepOldVersions) {
            this.keyLocationVersions.clear();
        }
        if (this.keyLocationVersions.size() == 0) {
            this.keyLocationVersions.add(new OmKeyLocationInfoGroup(0L, newLocationList));
            latestVersionNum = 0L;
        } else {
            OmKeyLocationInfoGroup currentLatestVersion = this.keyLocationVersions.get(this.keyLocationVersions.size() - 1);
            OmKeyLocationInfoGroup newVersion = currentLatestVersion.generateNextVersion(newLocationList);
            this.keyLocationVersions.add(newVersion);
            latestVersionNum = newVersion.getVersion();
        }
        if (updateTime) {
            this.setModificationTime(Time.now());
        }
        return latestVersionNum;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public FileEncryptionInfo getFileEncryptionInfo() {
        return this.encInfo;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public boolean addAcl(OzoneAcl acl) {
        return OzoneAclUtil.addAcl(this.acls, acl);
    }

    public boolean removeAcl(OzoneAcl acl) {
        return OzoneAclUtil.removeAcl(this.acls, acl);
    }

    public boolean setAcls(List<OzoneAcl> newAcls) {
        return OzoneAclUtil.setAcl(this.acls, newAcls);
    }

    public void setParentObjectID(long parentObjectID) {
        this.parentObjectID = parentObjectID;
    }

    public void setReplicationConfig(ReplicationConfig repConfig) {
        this.replicationConfig = repConfig;
    }

    public FileChecksum getFileChecksum() {
        return this.fileChecksum;
    }

    public String toString() {
        return "OmKeyInfo{volumeName='" + this.volumeName + '\'' + ", bucketName='" + this.bucketName + '\'' + ", keyName='" + this.keyName + '\'' + ", dataSize=" + this.dataSize + ", keyLocationVersions=" + this.keyLocationVersions + ", creationTime=" + this.creationTime + ", modificationTime=" + this.modificationTime + ", replicationConfig=" + this.replicationConfig + ", encInfo=" + (this.encInfo == null ? "null" : "<REDACTED>") + ", fileChecksum=" + this.fileChecksum + ", isFile=" + this.isFile + ", fileName='" + this.fileName + '\'' + ", acls=" + this.acls + '}';
    }

    public OzoneManagerProtocolProtos.KeyInfo getProtobuf(int clientVersion) {
        return this.getProtobuf(false, clientVersion);
    }

    public OzoneManagerProtocolProtos.KeyInfo getNetworkProtobuf(int clientVersion, boolean latestVersion) {
        return this.getProtobuf(false, null, clientVersion, latestVersion);
    }

    public OzoneManagerProtocolProtos.KeyInfo getNetworkProtobuf(String fullKeyName, int clientVersion, boolean latestVersion) {
        return this.getProtobuf(false, fullKeyName, clientVersion, latestVersion);
    }

    public OzoneManagerProtocolProtos.KeyInfo getProtobuf(boolean ignorePipeline, int clientVersion) {
        return this.getProtobuf(ignorePipeline, null, clientVersion, false);
    }

    private OzoneManagerProtocolProtos.KeyInfo getProtobuf(boolean ignorePipeline, String fullKeyName, int clientVersion, boolean latestVersionBlocks) {
        long latestVersion = this.keyLocationVersions.size() == 0 ? -1L : this.keyLocationVersions.get(this.keyLocationVersions.size() - 1).getVersion();
        ArrayList<OzoneManagerProtocolProtos.KeyLocationList> keyLocations = new ArrayList<OzoneManagerProtocolProtos.KeyLocationList>();
        if (!latestVersionBlocks) {
            for (OmKeyLocationInfoGroup locationInfoGroup : this.keyLocationVersions) {
                keyLocations.add(locationInfoGroup.getProtobuf(ignorePipeline, clientVersion));
            }
        } else if (latestVersion != -1L) {
            keyLocations.add(this.keyLocationVersions.get(this.keyLocationVersions.size() - 1).getProtobuf(ignorePipeline, clientVersion));
        }
        OzoneManagerProtocolProtos.KeyInfo.Builder kb = OzoneManagerProtocolProtos.KeyInfo.newBuilder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setDataSize(this.dataSize).setType(this.replicationConfig.getReplicationType());
        if (this.replicationConfig instanceof ECReplicationConfig) {
            kb.setEcReplicationConfig(((ECReplicationConfig)this.replicationConfig).toProto());
        } else {
            kb.setFactor(ReplicationConfig.getLegacyFactor((ReplicationConfig)this.replicationConfig));
        }
        kb.setLatestVersion(latestVersion).addAllKeyLocationList(keyLocations).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).addAllMetadata(KeyValueUtil.toProtobuf(this.metadata)).addAllAcls(OzoneAclUtil.toProtobuf(this.acls)).setObjectID(this.objectID).setUpdateID(this.updateID).setParentID(this.parentObjectID);
        OzoneManagerProtocolProtos.FileChecksumProto fileChecksumProto = OMPBHelper.convert(this.fileChecksum);
        if (fileChecksumProto != null) {
            kb.setFileChecksum(fileChecksumProto);
        }
        if (StringUtils.isNotBlank((CharSequence)fullKeyName)) {
            kb.setKeyName(fullKeyName);
        } else {
            kb.setKeyName(this.keyName);
        }
        if (this.encInfo != null) {
            kb.setFileEncryptionInfo(OMPBHelper.convert(this.encInfo));
        }
        kb.setIsFile(this.isFile);
        return kb.build();
    }

    public static OmKeyInfo getFromProtobuf(OzoneManagerProtocolProtos.KeyInfo keyInfo) throws IOException {
        if (keyInfo == null) {
            return null;
        }
        ArrayList<OmKeyLocationInfoGroup> omKeyLocationInfos = new ArrayList<OmKeyLocationInfoGroup>();
        for (OzoneManagerProtocolProtos.KeyLocationList keyLocationList : keyInfo.getKeyLocationListList()) {
            omKeyLocationInfos.add(OmKeyLocationInfoGroup.getFromProtobuf(keyLocationList));
        }
        Builder builder = new Builder().setVolumeName(keyInfo.getVolumeName()).setBucketName(keyInfo.getBucketName()).setKeyName(keyInfo.getKeyName()).setOmKeyLocationInfos(omKeyLocationInfos).setDataSize(keyInfo.getDataSize()).setCreationTime(keyInfo.getCreationTime()).setModificationTime(keyInfo.getModificationTime()).setReplicationConfig(ReplicationConfig.fromProto((HddsProtos.ReplicationType)keyInfo.getType(), (HddsProtos.ReplicationFactor)keyInfo.getFactor(), (HddsProtos.ECReplicationConfig)keyInfo.getEcReplicationConfig())).addAllMetadata(KeyValueUtil.getFromProtobuf(keyInfo.getMetadataList())).setFileEncryptionInfo(keyInfo.hasFileEncryptionInfo() ? OMPBHelper.convert(keyInfo.getFileEncryptionInfo()) : null).setAcls(OzoneAclUtil.fromProtobuf(keyInfo.getAclsList()));
        if (keyInfo.hasObjectID()) {
            builder.setObjectID(keyInfo.getObjectID());
        }
        if (keyInfo.hasUpdateID()) {
            builder.setUpdateID(keyInfo.getUpdateID());
        }
        if (keyInfo.hasParentID()) {
            builder.setParentObjectID(keyInfo.getParentID());
        }
        if (keyInfo.hasFileChecksum()) {
            FileChecksum fileChecksum = OMPBHelper.convert(keyInfo.getFileChecksum());
            builder.setFileChecksum(fileChecksum);
        }
        if (keyInfo.hasIsFile()) {
            builder.setFile(keyInfo.getIsFile());
        }
        builder.setFileName(OzoneFSUtils.getFileName(keyInfo.getKeyName()));
        return builder.build();
    }

    @Override
    public String getObjectInfo() {
        return "OMKeyInfo{volume='" + this.volumeName + '\'' + ", bucket='" + this.bucketName + '\'' + ", key='" + this.keyName + '\'' + ", dataSize='" + this.dataSize + '\'' + ", creationTime='" + this.creationTime + '\'' + ", objectID='" + this.objectID + '\'' + ", parentID='" + this.parentObjectID + '\'' + ", replication='" + this.replicationConfig + '\'' + ", fileChecksum='" + this.fileChecksum + '}';
    }

    public boolean isKeyInfoSame(OmKeyInfo omKeyInfo, boolean checkPath, boolean checkKeyLocationVersions, boolean checkModificationTime, boolean checkUpdateID) {
        boolean isEqual;
        boolean bl = isEqual = this.dataSize == omKeyInfo.dataSize && this.creationTime == omKeyInfo.creationTime && this.volumeName.equals(omKeyInfo.volumeName) && this.bucketName.equals(omKeyInfo.bucketName) && this.replicationConfig.equals(omKeyInfo.replicationConfig) && Objects.equals(this.metadata, omKeyInfo.metadata) && Objects.equals(this.acls, omKeyInfo.acls) && this.objectID == omKeyInfo.objectID;
        if (isEqual && checkUpdateID) {
            boolean bl2 = isEqual = this.updateID == omKeyInfo.updateID;
        }
        if (isEqual && checkModificationTime) {
            boolean bl3 = isEqual = this.modificationTime == omKeyInfo.modificationTime;
        }
        if (isEqual && checkPath) {
            boolean bl4 = isEqual = this.parentObjectID == omKeyInfo.parentObjectID && this.keyName.equals(omKeyInfo.keyName);
        }
        if (isEqual && checkKeyLocationVersions) {
            isEqual = Objects.equals(this.keyLocationVersions, omKeyInfo.keyLocationVersions);
        }
        return isEqual;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.isKeyInfoSame((OmKeyInfo)o, true, true, true, true);
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.bucketName, this.keyName, this.parentObjectID);
    }

    public OmKeyInfo copyObject() {
        Builder builder = new Builder().setVolumeName(this.volumeName).setBucketName(this.bucketName).setKeyName(this.keyName).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).setDataSize(this.dataSize).setReplicationConfig(this.replicationConfig).setFileEncryptionInfo(this.encInfo).setObjectID(this.objectID).setUpdateID(this.updateID).setParentObjectID(this.parentObjectID).setFileName(this.fileName).setFile(this.isFile);
        this.keyLocationVersions.forEach(keyLocationVersion -> builder.addOmKeyLocationInfoGroup(new OmKeyLocationInfoGroup(keyLocationVersion.getVersion(), keyLocationVersion.getLocationList(), keyLocationVersion.isMultipartKey())));
        this.acls.forEach(acl -> builder.addAcl(new OzoneAcl(acl.getType(), acl.getName(), (BitSet)acl.getAclBitSet().clone(), acl.getAclScope())));
        if (this.metadata != null) {
            this.metadata.forEach((k, v) -> builder.addMetadata((String)k, (String)v));
        }
        if (this.fileChecksum != null) {
            builder.setFileChecksum(this.fileChecksum);
        }
        return builder.build();
    }

    public void clearFileEncryptionInfo() {
        this.encInfo = null;
    }

    public void setFileEncryptionInfo(FileEncryptionInfo fileEncryptionInfo) {
        this.encInfo = fileEncryptionInfo;
    }

    public String getPath() {
        if (StringUtils.isBlank((CharSequence)this.getFileName())) {
            return this.getKeyName();
        }
        return this.getParentObjectID() + "/" + this.getFileName();
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private String keyName;
        private long dataSize;
        private List<OmKeyLocationInfoGroup> omKeyLocationInfoGroups = new ArrayList<OmKeyLocationInfoGroup>();
        private long creationTime;
        private long modificationTime;
        private ReplicationConfig replicationConfig;
        private Map<String, String> metadata = new HashMap<String, String>();
        private FileEncryptionInfo encInfo;
        private List<OzoneAcl> acls;
        private long objectID;
        private long updateID;
        private String fileName;
        private long parentObjectID;
        private FileChecksum fileChecksum;
        private boolean isFile;

        public Builder() {
            this.omKeyLocationInfoGroups = new ArrayList<OmKeyLocationInfoGroup>();
            this.acls = new ArrayList<OzoneAcl>();
        }

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setKeyName(String key) {
            this.keyName = key;
            return this;
        }

        public Builder setOmKeyLocationInfos(List<OmKeyLocationInfoGroup> omKeyLocationInfoList) {
            if (omKeyLocationInfoList != null) {
                this.omKeyLocationInfoGroups.addAll(omKeyLocationInfoList);
            }
            return this;
        }

        public Builder addOmKeyLocationInfoGroup(OmKeyLocationInfoGroup omKeyLocationInfoGroup) {
            if (omKeyLocationInfoGroup != null) {
                this.omKeyLocationInfoGroups.add(omKeyLocationInfoGroup);
            }
            return this;
        }

        public Builder setDataSize(long size) {
            this.dataSize = size;
            return this;
        }

        public Builder setCreationTime(long crTime) {
            this.creationTime = crTime;
            return this;
        }

        public Builder setModificationTime(long mTime) {
            this.modificationTime = mTime;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig replConfig) {
            this.replicationConfig = replConfig;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> newMetadata) {
            this.metadata.putAll(newMetadata);
            return this;
        }

        public Builder setFileEncryptionInfo(FileEncryptionInfo feInfo) {
            this.encInfo = feInfo;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            if (listOfAcls != null) {
                this.acls.addAll(listOfAcls);
            }
            return this;
        }

        public Builder addAcl(OzoneAcl ozoneAcl) {
            if (ozoneAcl != null) {
                this.acls.add(ozoneAcl);
            }
            return this;
        }

        public Builder setObjectID(long obId) {
            this.objectID = obId;
            return this;
        }

        public Builder setUpdateID(long id) {
            this.updateID = id;
            return this;
        }

        public Builder setFileName(String keyFileName) {
            this.fileName = keyFileName;
            return this;
        }

        public Builder setParentObjectID(long parentID) {
            this.parentObjectID = parentID;
            return this;
        }

        public Builder setFileChecksum(FileChecksum checksum) {
            this.fileChecksum = checksum;
            return this;
        }

        public Builder setFile(boolean isAFile) {
            this.isFile = isAFile;
            return this;
        }

        public OmKeyInfo build() {
            return new OmKeyInfo(this.volumeName, this.bucketName, this.keyName, this.fileName, this.omKeyLocationInfoGroups, this.dataSize, this.creationTime, this.modificationTime, this.replicationConfig, this.metadata, this.encInfo, this.acls, this.parentObjectID, this.objectID, this.updateID, this.fileChecksum, this.isFile);
        }
    }
}

