/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.rocksdiff;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSstFileReader;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSstFileReaderIterator;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.SstFileReader;
import org.rocksdb.SstFileReaderIterator;
import org.rocksdb.TableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RocksDiffUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDiffUtils.class);

    private RocksDiffUtils() {
    }

    public static boolean isKeyWithPrefixPresent(String prefixForColumnFamily, String firstDbKey, String lastDbKey) {
        String firstKeyPrefix = RocksDiffUtils.constructBucketKey(firstDbKey);
        String endKeyPrefix = RocksDiffUtils.constructBucketKey(lastDbKey);
        return firstKeyPrefix.compareTo(prefixForColumnFamily) <= 0 && prefixForColumnFamily.compareTo(endKeyPrefix) <= 0;
    }

    public static String constructBucketKey(String keyName) {
        if (!keyName.startsWith("/")) {
            keyName = "/".concat(keyName);
        }
        String[] elements = keyName.split("/");
        String volume = elements[1];
        String bucket = elements[2];
        StringBuilder builder = new StringBuilder().append("/").append(volume);
        if (StringUtils.isNotBlank((CharSequence)bucket)) {
            builder.append("/").append(bucket);
        }
        builder.append("/");
        return builder.toString();
    }

    public static void filterRelevantSstFiles(Set<String> inputFiles, Map<String, String> tableToPrefixMap) throws IOException {
        Iterator<String> fileIterator = inputFiles.iterator();
        while (fileIterator.hasNext()) {
            String filepath = fileIterator.next();
            if (RocksDiffUtils.doesSstFileContainKeyRange(filepath, tableToPrefixMap)) continue;
            fileIterator.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean doesSstFileContainKeyRange(String filepath, Map<String, String> tableToPrefixMap) throws IOException {
        try (ManagedSstFileReader sstFileReader = ManagedSstFileReader.managed((SstFileReader)new SstFileReader(new Options()));){
            ((SstFileReader)sstFileReader.get()).open(filepath);
            TableProperties properties = ((SstFileReader)sstFileReader.get()).getTableProperties();
            String tableName = new String(properties.getColumnFamilyName(), StandardCharsets.UTF_8);
            if (tableToPrefixMap.containsKey(tableName)) {
                String prefix = tableToPrefixMap.get(tableName);
                try (ManagedSstFileReaderIterator iterator = ManagedSstFileReaderIterator.managed((SstFileReaderIterator)((SstFileReader)sstFileReader.get()).newIterator(new ReadOptions()));){
                    ((SstFileReaderIterator)iterator.get()).seek(prefix.getBytes(StandardCharsets.UTF_8));
                    String seekResultKey = new String(((SstFileReaderIterator)iterator.get()).key(), StandardCharsets.UTF_8);
                    boolean bl = seekResultKey.startsWith(prefix);
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (RocksDBException e) {
            LOG.error("Failed to read SST File ", (Throwable)e);
            throw new IOException(e);
        }
    }
}

