/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.SecretKeyProtocolScm;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.DatanodeAdminError;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.ClientTrustManager;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaInfo;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.hdds.security.x509.certificate.client.CACertificateProvider;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerOperationClient
implements ScmClient {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerOperationClient.class);
    private final long containerSizeB;
    private final HddsProtos.ReplicationFactor replicationFactor;
    private final HddsProtos.ReplicationType replicationType;
    private final StorageContainerLocationProtocol storageContainerLocationClient;
    private final SecretKeyProtocolScm secretKeyClient;
    private final boolean containerTokenEnabled;
    private final OzoneConfiguration configuration;
    private XceiverClientManager xceiverClientManager;

    public synchronized XceiverClientManager getXceiverClientManager() throws IOException {
        if (this.xceiverClientManager == null) {
            this.xceiverClientManager = this.newXCeiverClientManager((ConfigurationSource)this.configuration);
        }
        return this.xceiverClientManager;
    }

    public ContainerOperationClient(OzoneConfiguration conf) throws IOException {
        this.configuration = conf;
        this.storageContainerLocationClient = ContainerOperationClient.newContainerRpcClient((ConfigurationSource)conf);
        this.secretKeyClient = ContainerOperationClient.newSecretKeyClient((ConfigurationSource)conf);
        this.containerSizeB = (int)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        boolean useRatis = conf.getBoolean("dfs.container.ratis.enabled", false);
        if (useRatis) {
            this.replicationFactor = HddsProtos.ReplicationFactor.THREE;
            this.replicationType = HddsProtos.ReplicationType.RATIS;
        } else {
            this.replicationFactor = HddsProtos.ReplicationFactor.ONE;
            this.replicationType = HddsProtos.ReplicationType.STAND_ALONE;
        }
        this.containerTokenEnabled = conf.getBoolean("hdds.container.token.enabled", false);
    }

    private XceiverClientManager newXCeiverClientManager(ConfigurationSource conf) throws IOException {
        XceiverClientManager manager;
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            CACertificateProvider caCerts = () -> HAUtils.buildCAX509List(null, (ConfigurationSource)conf);
            manager = new XceiverClientManager(conf, (XceiverClientManager.ScmClientConfig)conf.getObject(XceiverClientManager.ScmClientConfig.class), new ClientTrustManager(caCerts, null));
        } else {
            manager = new XceiverClientManager(conf);
        }
        return manager;
    }

    public static StorageContainerLocationProtocol newContainerRpcClient(ConfigurationSource configSource) {
        return HAUtils.getScmContainerClient((ConfigurationSource)configSource);
    }

    public static SecretKeyProtocolScm newSecretKeyClient(ConfigurationSource configSource) throws IOException {
        return HddsServerUtil.getSecretKeyClientForSCM((ConfigurationSource)configSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerWithPipeline createContainer(String owner) throws IOException {
        ContainerWithPipeline containerWithPipeline;
        block3: {
            XceiverClientSpi client = null;
            XceiverClientManager clientManager = this.getXceiverClientManager();
            try {
                ContainerWithPipeline containerWithPipeline2 = this.storageContainerLocationClient.allocateContainer(this.replicationType, this.replicationFactor, owner);
                Pipeline pipeline = containerWithPipeline2.getPipeline();
                client = clientManager.acquireClient(pipeline);
                Preconditions.checkState((boolean)pipeline.isOpen(), (String)"Unexpected state=%s for pipeline=%s, expected state=%s", (Object)pipeline.getPipelineState(), (Object)pipeline.getId(), (Object)Pipeline.PipelineState.OPEN);
                this.createContainer(client, containerWithPipeline2.getContainerInfo().getContainerID());
                containerWithPipeline = containerWithPipeline2;
                if (client == null) break block3;
            }
            catch (Throwable throwable) {
                if (client != null) {
                    clientManager.releaseClient(client, false);
                }
                throw throwable;
            }
            clientManager.releaseClient(client, false);
        }
        return containerWithPipeline;
    }

    public void createContainer(XceiverClientSpi client, long containerId) throws IOException {
        String encodedToken = this.getEncodedContainerToken(containerId);
        ContainerProtocolCalls.createContainer((XceiverClientSpi)client, (long)containerId, (String)encodedToken);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created container {} machines {}", (Object)containerId, (Object)client.getPipeline().getNodes());
        }
    }

    private String getEncodedContainerToken(long containerId) throws IOException {
        if (!this.containerTokenEnabled) {
            return "";
        }
        ContainerID containerID = ContainerID.valueOf((long)containerId);
        return this.storageContainerLocationClient.getContainerToken(containerID).encodeToUrlString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerWithPipeline createContainer(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        ContainerWithPipeline containerWithPipeline;
        block3: {
            XceiverClientSpi client = null;
            XceiverClientManager clientManager = this.getXceiverClientManager();
            try {
                ContainerWithPipeline containerWithPipeline2 = this.storageContainerLocationClient.allocateContainer(type, factor, owner);
                Pipeline pipeline = containerWithPipeline2.getPipeline();
                client = clientManager.acquireClient(pipeline);
                this.createContainer(client, containerWithPipeline2.getContainerInfo().getContainerID());
                containerWithPipeline = containerWithPipeline2;
                if (client == null) break block3;
            }
            catch (Throwable throwable) {
                if (client != null) {
                    clientManager.releaseClient(client, false);
                }
                throw throwable;
            }
            clientManager.releaseClient(client, false);
        }
        return containerWithPipeline;
    }

    public List<HddsProtos.Node> queryNode(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState nodeState, HddsProtos.QueryScope queryScope, String poolName) throws IOException {
        return this.storageContainerLocationClient.queryNode(opState, nodeState, queryScope, poolName, ClientVersion.CURRENT_VERSION);
    }

    public List<DatanodeAdminError> decommissionNodes(List<String> hosts) throws IOException {
        return this.storageContainerLocationClient.decommissionNodes(hosts);
    }

    public List<DatanodeAdminError> recommissionNodes(List<String> hosts) throws IOException {
        return this.storageContainerLocationClient.recommissionNodes(hosts);
    }

    public List<DatanodeAdminError> startMaintenanceNodes(List<String> hosts, int endHours) throws IOException {
        return this.storageContainerLocationClient.startMaintenanceNodes(hosts, endHours);
    }

    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        return this.storageContainerLocationClient.createReplicationPipeline(type, factor, nodePool);
    }

    public List<Pipeline> listPipelines() throws IOException {
        return this.storageContainerLocationClient.listPipelines();
    }

    public Pipeline getPipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        return this.storageContainerLocationClient.getPipeline(pipelineID);
    }

    public void activatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        this.storageContainerLocationClient.activatePipeline(pipelineID);
    }

    public void deactivatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        this.storageContainerLocationClient.deactivatePipeline(pipelineID);
    }

    public void closePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        this.storageContainerLocationClient.closePipeline(pipelineID);
    }

    public void close() {
        try {
            if (this.xceiverClientManager != null) {
                this.xceiverClientManager.close();
            }
            if (this.storageContainerLocationClient != null) {
                this.storageContainerLocationClient.close();
            }
        }
        catch (Exception ex) {
            LOG.error("Can't close " + this.getClass().getSimpleName(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContainer(long containerId, Pipeline pipeline, boolean force) throws IOException {
        XceiverClientSpi client = null;
        XceiverClientManager clientManager = this.getXceiverClientManager();
        try {
            String encodedToken = this.getEncodedContainerToken(containerId);
            client = clientManager.acquireClient(pipeline);
            ContainerProtocolCalls.deleteContainer((XceiverClientSpi)client, (long)containerId, (boolean)force, (String)encodedToken);
            this.storageContainerLocationClient.deleteContainer(containerId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted container {}, machines: {} ", (Object)containerId, (Object)pipeline.getNodes());
            }
        }
        finally {
            if (client != null) {
                clientManager.releaseClient(client, false);
            }
        }
    }

    public void deleteContainer(long containerID, boolean force) throws IOException {
        ContainerWithPipeline info = this.getContainerWithPipeline(containerID);
        this.deleteContainer(containerID, info.getPipeline(), force);
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count) throws IOException {
        return this.storageContainerLocationClient.listContainer(startContainerID, count);
    }

    public List<ContainerInfo> listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state, HddsProtos.ReplicationType repType, ReplicationConfig replicationConfig) throws IOException {
        return this.storageContainerLocationClient.listContainer(startContainerID, count, state, repType, replicationConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerProtos.ContainerDataProto readContainer(long containerID, Pipeline pipeline) throws IOException {
        XceiverClientManager clientManager = this.getXceiverClientManager();
        String encodedToken = this.getEncodedContainerToken(containerID);
        XceiverClientSpi client = null;
        try {
            client = clientManager.acquireClientForReadData(pipeline);
            ContainerProtos.ReadContainerResponseProto response = ContainerProtocolCalls.readContainer((XceiverClientSpi)client, (long)containerID, (String)encodedToken);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read container {}, machines: {} ", (Object)containerID, (Object)pipeline.getNodes());
            }
            ContainerProtos.ContainerDataProto containerDataProto = response.getContainerData();
            return containerDataProto;
        }
        finally {
            if (client != null) {
                clientManager.releaseClient(client, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DatanodeDetails, ContainerProtos.ReadContainerResponseProto> readContainerFromAllNodes(long containerID, Pipeline pipeline) throws IOException, InterruptedException {
        XceiverClientManager clientManager = this.getXceiverClientManager();
        String encodedToken = this.getEncodedContainerToken(containerID);
        XceiverClientSpi client = null;
        try {
            HashMap responses;
            client = clientManager.acquireClientForReadData(pipeline);
            HashMap hashMap = responses = ContainerProtocolCalls.readContainerFromAllNodes((XceiverClientSpi)client, (long)containerID, (String)encodedToken);
            return hashMap;
        }
        finally {
            if (client != null) {
                clientManager.releaseClient(client, false);
            }
        }
    }

    public ContainerProtos.ContainerDataProto readContainer(long containerID) throws IOException {
        ContainerWithPipeline info = this.getContainerWithPipeline(containerID);
        return this.readContainer(containerID, info.getPipeline());
    }

    public ContainerInfo getContainer(long containerId) throws IOException {
        return this.storageContainerLocationClient.getContainer(containerId);
    }

    public ContainerWithPipeline getContainerWithPipeline(long containerId) throws IOException {
        return this.storageContainerLocationClient.getContainerWithPipeline(containerId);
    }

    public List<ContainerReplicaInfo> getContainerReplicas(long containerId) throws IOException {
        List protos = this.storageContainerLocationClient.getContainerReplicas(containerId, ClientVersion.CURRENT_VERSION);
        ArrayList<ContainerReplicaInfo> replicas = new ArrayList<ContainerReplicaInfo>();
        for (HddsProtos.SCMContainerReplicaProto p : protos) {
            replicas.add(ContainerReplicaInfo.fromProto((HddsProtos.SCMContainerReplicaProto)p));
        }
        return replicas;
    }

    public void closeContainer(long containerId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Close container {}", (Object)containerId);
        }
        this.storageContainerLocationClient.closeContainer(containerId);
    }

    public long getContainerSize(long containerID) throws IOException {
        return this.containerSizeB;
    }

    public boolean inSafeMode() throws IOException {
        return this.storageContainerLocationClient.inSafeMode();
    }

    public Map<String, Pair<Boolean, String>> getSafeModeRuleStatuses() throws IOException {
        return this.storageContainerLocationClient.getSafeModeRuleStatuses();
    }

    public boolean forceExitSafeMode() throws IOException {
        return this.storageContainerLocationClient.forceExitSafeMode();
    }

    public void startReplicationManager() throws IOException {
        this.storageContainerLocationClient.startReplicationManager();
    }

    public void stopReplicationManager() throws IOException {
        this.storageContainerLocationClient.stopReplicationManager();
    }

    public boolean getReplicationManagerStatus() throws IOException {
        return this.storageContainerLocationClient.getReplicationManagerStatus();
    }

    public ReplicationManagerReport getReplicationManagerReport() throws IOException {
        return this.storageContainerLocationClient.getReplicationManagerReport();
    }

    public StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto startContainerBalancer(Optional<Double> threshold, Optional<Integer> iterations, Optional<Integer> maxDatanodesPercentageToInvolvePerIteration, Optional<Long> maxSizeToMovePerIterationInGB, Optional<Long> maxSizeEnteringTargetInGB, Optional<Long> maxSizeLeavingSourceInGB) throws IOException {
        return this.storageContainerLocationClient.startContainerBalancer(threshold, iterations, maxDatanodesPercentageToInvolvePerIteration, maxSizeToMovePerIterationInGB, maxSizeEnteringTargetInGB, maxSizeLeavingSourceInGB);
    }

    public void stopContainerBalancer() throws IOException {
        this.storageContainerLocationClient.stopContainerBalancer();
    }

    public boolean getContainerBalancerStatus() throws IOException {
        return this.storageContainerLocationClient.getContainerBalancerStatus();
    }

    public List<String> getScmRatisRoles() throws IOException {
        return this.storageContainerLocationClient.getScmInfo().getRatisPeerRoles();
    }

    public boolean rotateSecretKeys(boolean force) throws IOException {
        return this.secretKeyClient.checkAndRotate(force);
    }

    public void transferLeadership(String newLeaderId) throws IOException {
        this.storageContainerLocationClient.transferLeadership(newLeaderId);
    }

    public List<HddsProtos.DeletedBlocksTransactionInfo> getFailedDeletedBlockTxn(int count, long startTxId) throws IOException {
        return this.storageContainerLocationClient.getFailedDeletedBlockTxn(count, startTxId);
    }

    public int resetDeletedBlockRetryCount(List<Long> txIDs) throws IOException {
        return this.storageContainerLocationClient.resetDeletedBlockRetryCount(txIDs);
    }

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(String address, String uuid) throws IOException {
        return this.storageContainerLocationClient.getDatanodeUsageInfo(address, uuid, ClientVersion.CURRENT_VERSION);
    }

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(boolean mostUsed, int count) throws IOException {
        return this.storageContainerLocationClient.getDatanodeUsageInfo(mostUsed, count, ClientVersion.CURRENT_VERSION);
    }

    public UpgradeFinalizer.StatusAndMessages finalizeScmUpgrade(String upgradeClientID) throws IOException {
        return this.storageContainerLocationClient.finalizeScmUpgrade(upgradeClientID);
    }

    public UpgradeFinalizer.StatusAndMessages queryUpgradeFinalizationProgress(String upgradeClientID, boolean force, boolean readonly) throws IOException {
        return this.storageContainerLocationClient.queryUpgradeFinalizationProgress(upgradeClientID, force, readonly);
    }

    public StorageContainerLocationProtocolProtos.DecommissionScmResponseProto decommissionScm(String scmId) throws IOException {
        return this.storageContainerLocationClient.decommissionScm(scmId);
    }
}

