/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.cert;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.scm.cli.cert.ScmCertSubcommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="clean", description={"Clean expired certificates from the SCM metadata."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class CleanExpiredCertsSubcommand
extends ScmCertSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(CleanExpiredCertsSubcommand.class);

    @Override
    protected void execute(SCMSecurityProtocol client) throws IOException {
        List pemEncodedCerts = client.removeExpiredCertificates();
        LOG.info("List of removed expired certificates:");
        this.printCertList(LOG, pemEncodedCerts);
    }
}

