/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.cert;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.cert.ScmCertSubcommand;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List certificates"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListSubcommand
extends ScmCertSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(ListSubcommand.class);
    @CommandLine.Option(names={"-s", "--start"}, description={"Certificate serial id to start the iteration"}, defaultValue="0", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private long startSerialId;
    @CommandLine.Option(names={"-c", "--count"}, description={"Maximum number of certificates to list"}, defaultValue="20", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private int count;
    @CommandLine.Option(names={"-r", "--role"}, description={"Filter certificate by the role: om/datanode"}, defaultValue="datanode", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String role;
    @CommandLine.Option(names={"-t", "--type"}, description={"Filter certificate by the type: valid or revoked"}, defaultValue="valid", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String type;
    @CommandLine.Option(names={"--json"}, defaultValue="false", description={"Format output as JSON"})
    private boolean json;

    private HddsProtos.NodeType parseCertRole(String r) {
        if (r.equalsIgnoreCase("om")) {
            return HddsProtos.NodeType.OM;
        }
        if (r.equalsIgnoreCase("scm")) {
            return HddsProtos.NodeType.SCM;
        }
        return HddsProtos.NodeType.DATANODE;
    }

    @Override
    protected void execute(SCMSecurityProtocol client) throws IOException {
        boolean isRevoked = this.type.equalsIgnoreCase("revoked");
        HddsProtos.NodeType nodeType = this.parseCertRole(this.role);
        List certPemList = client.listCertificate(nodeType, this.startSerialId, this.count, isRevoked);
        if (this.count == certPemList.size()) {
            System.err.println("The certificate list could be longer than the batch size: " + this.count + ". Please use the \"-c\" option to see more certificates.");
        }
        if (this.json) {
            System.err.println("Certificate list:(Type=" + this.type.toUpperCase() + ", BatchSize=" + this.count + ", CertCount=" + certPemList.size() + ")");
            ArrayList<Certificate> certList = new ArrayList<Certificate>();
            for (String certPemStr : certPemList) {
                try {
                    X509Certificate cert = CertificateCodec.getX509Certificate((String)certPemStr);
                    certList.add(new Certificate(cert));
                }
                catch (CertificateException ex) {
                    LOG.error("Failed to parse certificate.");
                }
            }
            System.out.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter(certList));
            return;
        }
        LOG.info("Certificate list:(Type={}, BatchSize={}, CertCount={})", new Object[]{this.type.toUpperCase(), this.count, certPemList.size()});
        this.printCertList(LOG, certPemList);
    }

    private static class Certificate {
        private BigInteger serialNumber;
        private String validFrom;
        private String expiry;
        private Map<String, String> subjectDN = new LinkedHashMap<String, String>();
        private Map<String, String> issuerDN = new LinkedHashMap<String, String>();

        Certificate(X509Certificate cert) {
            this.serialNumber = cert.getSerialNumber();
            this.validFrom = cert.getNotBefore().toString();
            this.expiry = cert.getNotAfter().toString();
            String subject = cert.getSubjectDN().getName();
            this.parseDnInfo(subject, true);
            String issuer = cert.getIssuerDN().getName();
            this.parseDnInfo(issuer, false);
        }

        private void parseDnInfo(String dnName, boolean isSubject) {
            String[] dnNameComponents = dnName.split(",");
            if (dnNameComponents.length == 0) {
                System.err.println("Invalid format of name: " + dnName);
            } else {
                for (String elem : dnNameComponents) {
                    String[] components = elem.split("=");
                    if (components.length == 2) {
                        (isSubject ? this.subjectDN : this.issuerDN).put(components[0], components[1]);
                        continue;
                    }
                    System.err.println("Invalid format of name: " + dnName);
                }
            }
        }

        @JsonSerialize(using=BigIntJsonSerializer.class)
        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        public String getValidFrom() {
            return this.validFrom;
        }

        public String getExpiry() {
            return this.expiry;
        }

        public Map<String, String> getSubjectDN() {
            return this.subjectDN;
        }

        public Map<String, String> getIssuerDN() {
            return this.issuerDN;
        }
    }

    private static class BigIntJsonSerializer
    extends JsonSerializer<BigInteger> {
        private BigIntJsonSerializer() {
        }

        public void serialize(BigInteger value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(String.format("%d", value));
        }
    }
}

