/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.cert;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.scm.cli.ScmOption;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.slf4j.Logger;
import picocli.CommandLine;

public abstract class ScmCertSubcommand
implements Callable<Void> {
    @CommandLine.Mixin
    private ScmOption scmOption;
    private static final String OUTPUT_FORMAT = "%-17s %-30s %-30s %-110s %-110s";

    protected void printCertList(Logger log, List<String> pemEncodedCerts) {
        if (pemEncodedCerts.isEmpty()) {
            log.info("No certificates to list");
            return;
        }
        log.info(String.format(OUTPUT_FORMAT, "SerialNumber", "Valid From", "Expiry", "Subject", "Issuer"));
        for (String certPemStr : pemEncodedCerts) {
            try {
                X509Certificate cert = CertificateCodec.getX509Certificate((String)certPemStr);
                this.printCert(cert, log);
            }
            catch (CertificateException e) {
                log.error("Failed to parse certificate.", (Throwable)e);
            }
        }
    }

    protected void printCert(X509Certificate cert, Logger log) {
        log.info(String.format(OUTPUT_FORMAT, cert.getSerialNumber(), cert.getNotBefore(), cert.getNotAfter(), cert.getSubjectDN(), cert.getIssuerDN()));
    }

    protected abstract void execute(SCMSecurityProtocol var1) throws IOException;

    @Override
    public final Void call() throws Exception {
        SCMSecurityProtocol client = this.scmOption.createScmSecurityClient();
        this.execute(client);
        return null;
    }
}

