/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create container"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class CreateSubcommand
extends ScmSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSubcommand.class);
    @CommandLine.Option(description={"Owner of the new container"}, defaultValue="OZONE", names={"-o", "--owner"})
    private String owner;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        ContainerWithPipeline container = scmClient.createContainer(this.owner);
        LOG.info("Container {} is created.", (Object)container.getContainerInfo().getContainerID());
    }
}

