/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.GenericParentCommand;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Show information about a specific container"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class InfoSubcommand
extends ScmSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(InfoSubcommand.class);
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--json"}, defaultValue="false", description={"Format output as JSON"})
    private boolean json;
    @CommandLine.Parameters(description={"One or more container IDs separated by spaces. To read from stdin, specify '-' and supply the container IDs separated by newlines."}, arity="1..*", paramLabel="<container ID>")
    private String[] containerList;
    private boolean multiContainer = false;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        boolean first = true;
        boolean stdin = false;
        if (this.containerList.length > 1) {
            this.multiContainer = true;
        } else if (this.containerList[0].equals("-")) {
            stdin = true;
            this.multiContainer = true;
        }
        this.printHeader();
        if (stdin) {
            Scanner scanner = new Scanner(System.in, "UTF-8");
            while (scanner.hasNextLine()) {
                String id = scanner.nextLine().trim();
                this.printOutput(scmClient, id, first);
                first = false;
            }
        } else {
            for (String id : this.containerList) {
                this.printOutput(scmClient, id, first);
                first = false;
            }
        }
        this.printFooter();
    }

    private void printOutput(ScmClient scmClient, String id, boolean first) throws IOException {
        long containerID;
        try {
            containerID = Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            this.printError("Invalid container ID: " + id);
            return;
        }
        this.printDetails(scmClient, containerID, first);
    }

    private void printHeader() {
        if (this.json && this.multiContainer) {
            LOG.info("[");
        }
    }

    private void printFooter() {
        if (this.json && this.multiContainer) {
            LOG.info("]");
        }
    }

    private void printError(String error) {
        System.err.println(error);
    }

    private void printBreak() {
        if (this.json) {
            LOG.info(",");
        } else {
            LOG.info("");
        }
    }

    private void printDetails(ScmClient scmClient, long containerID, boolean first) throws IOException {
        ContainerWithPipeline container;
        try {
            container = scmClient.getContainerWithPipeline(containerID);
            Preconditions.checkNotNull((Object)container, (Object)"Container cannot be null");
        }
        catch (IOException e) {
            this.printError("Unable to retrieve the container details for " + containerID);
            return;
        }
        List replicas = null;
        try {
            replicas = scmClient.getContainerReplicas(containerID);
        }
        catch (IOException e) {
            this.printError("Unable to retrieve the replica details: " + e.getMessage());
        }
        if (!first) {
            this.printBreak();
        }
        if (this.json) {
            if (container.getPipeline().size() != 0) {
                ContainerWithPipelineAndReplicas wrapper = new ContainerWithPipelineAndReplicas(container.getContainerInfo(), container.getPipeline(), replicas, container.getContainerInfo().getPipelineID());
                LOG.info(JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)wrapper));
            } else {
                ContainerWithoutDatanodes wrapper = new ContainerWithoutDatanodes(container.getContainerInfo(), container.getPipeline(), replicas, container.getContainerInfo().getPipelineID());
                LOG.info(JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)wrapper));
            }
        } else {
            boolean verbose;
            LOG.info("Container id: {}", (Object)containerID);
            boolean bl = verbose = this.spec != null && this.spec.root().userObject() instanceof GenericParentCommand && ((GenericParentCommand)this.spec.root().userObject()).isVerbose();
            if (verbose) {
                LOG.info("Pipeline Info: {}", (Object)container.getPipeline());
            } else {
                LOG.info("Pipeline id: {}", (Object)container.getPipeline().getId().getId());
            }
            LOG.info("Write PipelineId: {}", (Object)container.getContainerInfo().getPipelineID().getId());
            try {
                String pipelineState = scmClient.getPipeline(container.getContainerInfo().getPipelineID().getProtobuf()).getPipelineState().toString();
                LOG.info("Write Pipeline State: {}", (Object)pipelineState);
            }
            catch (IOException ioe) {
                if (SCMHAUtils.unwrapException((Exception)ioe) instanceof PipelineNotFoundException) {
                    LOG.info("Write Pipeline State: CLOSED");
                }
                this.printError("Failed to retrieve pipeline info");
            }
            LOG.info("Container State: {}", (Object)container.getContainerInfo().getState());
            String machinesStr = container.getPipeline().getNodes().stream().map(InfoSubcommand::buildDatanodeDetails).collect(Collectors.joining(",\n"));
            LOG.info("Datanodes: [{}]", (Object)machinesStr);
            if (replicas != null) {
                String replicaStr = replicas.stream().sorted(Comparator.comparing(ContainerReplicaInfo::getReplicaIndex)).map(InfoSubcommand::buildReplicaDetails).collect(Collectors.joining(",\n"));
                LOG.info("Replicas: [{}]", (Object)replicaStr);
            }
        }
    }

    private static String buildDatanodeDetails(DatanodeDetails details) {
        return details.getUuidString() + "/" + details.getHostName();
    }

    private static String buildReplicaDetails(ContainerReplicaInfo replica) {
        StringBuilder sb = new StringBuilder();
        sb.append("State: " + replica.getState() + ";");
        if (replica.getReplicaIndex() != -1) {
            sb.append(" ReplicaIndex: " + replica.getReplicaIndex() + ";");
        }
        sb.append(" Origin: " + replica.getPlaceOfBirth().toString() + ";");
        sb.append(" Location: " + InfoSubcommand.buildDatanodeDetails(replica.getDatanodeDetails()));
        return sb.toString();
    }

    private static final class PipelineWithoutDatanodes {
        private final PipelineID id;
        private final ReplicationConfig replicationConfig;
        private final Pipeline.PipelineState state;
        private Instant creationTimestamp;
        private Map<DatanodeDetails, Long> nodeStatus;

        private PipelineWithoutDatanodes(Pipeline pipeline) {
            this.id = pipeline.getId();
            this.replicationConfig = pipeline.getReplicationConfig();
            this.state = pipeline.getPipelineState();
            this.creationTimestamp = pipeline.getCreationTimestamp();
            this.nodeStatus = new HashMap<DatanodeDetails, Long>();
        }

        public PipelineID getId() {
            return this.id;
        }

        public ReplicationConfig getReplicationConfig() {
            return this.replicationConfig;
        }

        public Pipeline.PipelineState getPipelineState() {
            return this.state;
        }

        public Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public HddsProtos.ReplicationType getType() {
            return this.replicationConfig.getReplicationType();
        }

        public boolean isEmpty() {
            return this.nodeStatus.isEmpty();
        }

        public List<DatanodeDetails> getNodes() {
            return new ArrayList<DatanodeDetails>(this.nodeStatus.keySet());
        }

        public boolean isAllocationTimeout() {
            return false;
        }

        public boolean isHealthy() {
            return false;
        }
    }

    private static class ContainerWithoutDatanodes {
        private ContainerInfo containerInfo;
        private PipelineWithoutDatanodes pipeline;
        private List<ContainerReplicaInfo> replicas;
        private PipelineID writePipelineId;

        ContainerWithoutDatanodes(ContainerInfo container, Pipeline pipeline, List<ContainerReplicaInfo> replicas, PipelineID pipelineID) {
            this.containerInfo = container;
            this.pipeline = new PipelineWithoutDatanodes(pipeline);
            this.replicas = replicas;
            this.writePipelineId = pipelineID;
        }

        public ContainerInfo getContainerInfo() {
            return this.containerInfo;
        }

        public PipelineWithoutDatanodes getPipeline() {
            return this.pipeline;
        }

        public List<ContainerReplicaInfo> getReplicas() {
            return this.replicas;
        }

        public PipelineID getWritePipelineId() {
            return this.writePipelineId;
        }
    }

    private static class ContainerWithPipelineAndReplicas {
        private ContainerInfo containerInfo;
        private Pipeline pipeline;
        private List<ContainerReplicaInfo> replicas;
        private PipelineID writePipelineID;

        ContainerWithPipelineAndReplicas(ContainerInfo container, Pipeline pipeline, List<ContainerReplicaInfo> replicas, PipelineID pipelineID) {
            this.containerInfo = container;
            this.pipeline = pipeline;
            this.replicas = replicas;
            this.writePipelineID = pipelineID;
        }

        public ContainerInfo getContainerInfo() {
            return this.containerInfo;
        }

        public Pipeline getPipeline() {
            return this.pipeline;
        }

        public List<ContainerReplicaInfo> getReplicas() {
            return this.replicas;
        }

        public PipelineID getWritePipelineID() {
            return this.writePipelineID;
        }
    }
}

