/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List containers"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListSubcommand
extends ScmSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(ListSubcommand.class);
    @CommandLine.Option(names={"-s", "--start"}, description={"Container id to start the iteration"})
    private long startId;
    @CommandLine.Option(names={"-c", "--count"}, description={"Maximum number of containers to list"}, defaultValue="20", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private int count;
    @CommandLine.Option(names={"--state"}, description={"Container state(OPEN, CLOSING, QUASI_CLOSED, CLOSED, DELETING, DELETED)"})
    private HddsProtos.LifeCycleState state;
    @CommandLine.Option(names={"-t", "--type"}, description={"Replication Type (RATIS, STAND_ALONE or EC)"})
    private HddsProtos.ReplicationType type;
    @CommandLine.Option(names={"-r", "--replication", "--factor"}, description={"Container replication (ONE, THREE for Ratis, rs-6-3-1024k for EC)"})
    private String replication;
    private static final ObjectWriter WRITER;

    private void outputContainerInfo(ContainerInfo containerInfo) throws IOException {
        LOG.info("{}", (Object)WRITER.writeValueAsString((Object)containerInfo));
    }

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        if (!Strings.isNullOrEmpty((String)this.replication) && this.type == null) {
            this.type = HddsProtos.ReplicationType.RATIS;
        }
        ReplicationConfig repConfig = null;
        if (!Strings.isNullOrEmpty((String)this.replication)) {
            repConfig = ReplicationConfig.parse((ReplicationType)ReplicationType.fromProto((HddsProtos.ReplicationType)this.type), (String)this.replication, (ConfigurationSource)new OzoneConfiguration());
        }
        List containerList = scmClient.listContainer(this.startId, this.count, this.state, this.type, repConfig);
        for (ContainerInfo container : containerList) {
            this.outputContainerInfo(container);
        }
    }

    static {
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }
}

