/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.datanode;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Strings;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.util.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="usageinfo", description={"List usage information (such as Capacity, SCMUsed, Remaining) of a datanode by IP address or Host name or UUID"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class UsageInfoSubcommand
extends ScmSubcommand {
    private static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
    @CommandLine.ArgGroup(multiplicity="1")
    private ExclusiveArguments exclusiveArguments;
    @CommandLine.Option(names={"-c", "--count"}, description={"Number of datanodes to display (Default: ${DEFAULT-VALUE})."}, paramLabel="NUMBER OF NODES", defaultValue="3")
    private int count;
    @CommandLine.Option(names={"--json"}, defaultValue="false", description={"Format output as JSON"})
    private boolean json;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        if (this.count < 1) {
            throw new IOException("Count must be an integer greater than 0.");
        }
        List infoList = !Strings.isNullOrEmpty((String)this.exclusiveArguments.address) || !Strings.isNullOrEmpty((String)this.exclusiveArguments.uuid) ? scmClient.getDatanodeUsageInfo(this.exclusiveArguments.address, this.exclusiveArguments.uuid) : scmClient.getDatanodeUsageInfo(this.exclusiveArguments.mostUsed, this.count);
        List<DatanodeUsage> usageList = infoList.stream().map(d -> new DatanodeUsage((HddsProtos.DatanodeUsageInfoProto)d)).collect(Collectors.toList());
        if (this.json) {
            System.out.print(JsonUtils.toJsonStringWithDefaultPrettyPrinter(usageList));
            return;
        }
        System.out.printf("Usage Information (%d Datanodes)%n%n", usageList.size());
        usageList.forEach(this::printInfo);
    }

    private void printInfo(DatanodeUsage info) {
        System.out.printf("%-13s: %s %n", "UUID", info.getDatanodeDetails().getUuid());
        System.out.printf("%-13s: %s %n", "IP Address", info.getDatanodeDetails().getIpAddress());
        System.out.printf("%-13s: %s %n", "Hostname", info.getDatanodeDetails().getHostName());
        System.out.printf("%-13s: %s (%s) %n", "Capacity", info.getCapacity() + " B", StringUtils.byteDesc((long)info.getCapacity()));
        System.out.printf("%-13s: %s (%s) %n", "Total Used", info.getTotalUsed() + " B", StringUtils.byteDesc((long)info.getTotalUsed()));
        System.out.printf("%-13s: %s %n", "Total Used %", PERCENT_FORMAT.format(info.getTotalUsedRatio()));
        System.out.printf("%-13s: %s (%s) %n", "Ozone Used", info.getOzoneUsed() + " B", StringUtils.byteDesc((long)info.getOzoneUsed()));
        System.out.printf("%-13s: %s %n", "Ozone Used %", PERCENT_FORMAT.format(info.getUsedRatio()));
        System.out.printf("%-13s: %s (%s) %n", "Remaining", info.getRemaining() + " B", StringUtils.byteDesc((long)info.getRemaining()));
        System.out.printf("%-13s: %s %n", "Remaining %", PERCENT_FORMAT.format(info.getRemainingRatio()));
        System.out.printf("%-13s: %d %n%n", "Container(s)", info.getContainerCount());
    }

    static {
        PERCENT_FORMAT.setMinimumFractionDigits(2);
        PERCENT_FORMAT.setMaximumFractionDigits(2);
    }

    private static class DatanodeUsage {
        private DatanodeDetails datanodeDetails = null;
        private long capacity = 0L;
        private long used = 0L;
        private long remaining = 0L;
        private long containerCount = 0L;

        DatanodeUsage(HddsProtos.DatanodeUsageInfoProto proto) {
            if (proto.hasNode()) {
                this.datanodeDetails = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)proto.getNode());
            }
            if (proto.hasCapacity()) {
                this.capacity = proto.getCapacity();
            }
            if (proto.hasUsed()) {
                this.used = proto.getUsed();
            }
            if (proto.hasRemaining()) {
                this.remaining = proto.getRemaining();
            }
            if (proto.hasContainerCount()) {
                this.containerCount = proto.getContainerCount();
            }
        }

        public DatanodeDetails getDatanodeDetails() {
            return this.datanodeDetails;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public long getTotalUsed() {
            return this.capacity - this.remaining;
        }

        public long getOzoneUsed() {
            return this.used;
        }

        public long getRemaining() {
            return this.remaining;
        }

        public long getContainerCount() {
            return this.containerCount;
        }

        @JsonSerialize(using=DecimalJsonSerializer.class)
        public double getTotalUsedPercent() {
            return this.getTotalUsedRatio() * 100.0;
        }

        @JsonSerialize(using=DecimalJsonSerializer.class)
        public double getOzoneUsedPercent() {
            return this.getUsedRatio() * 100.0;
        }

        @JsonSerialize(using=DecimalJsonSerializer.class)
        public double getRemainingPercent() {
            return this.getRemainingRatio() * 100.0;
        }

        @JsonIgnore
        public double getTotalUsedRatio() {
            return 1.0 - this.getRemainingRatio();
        }

        @JsonIgnore
        public double getUsedRatio() {
            return (double)this.used / (double)this.capacity;
        }

        @JsonIgnore
        public double getRemainingRatio() {
            return (double)this.remaining / (double)this.capacity;
        }
    }

    private static class DecimalJsonSerializer
    extends JsonSerializer<Double> {
        private DecimalJsonSerializer() {
        }

        public void serialize(Double value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeNumber(String.format("%.2f", value));
        }
    }

    private static class ExclusiveArguments {
        @CommandLine.Option(names={"--address"}, paramLabel="ADDRESS", description={"Show info by datanode ip or hostname address."}, defaultValue="")
        private String address;
        @CommandLine.Option(names={"--uuid"}, paramLabel="UUID", description={"Show info by datanode UUID."}, defaultValue="")
        private String uuid;
        @CommandLine.Option(names={"-m", "--most-used"}, description={"Show the most used datanodes."}, defaultValue="false")
        private boolean mostUsed;
        @CommandLine.Option(names={"-l", "--least-used"}, description={"Show the least used datanodes."}, defaultValue="false")
        private boolean leastUsed;

        private ExclusiveArguments() {
        }
    }
}

