/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.cubrid;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.ConnectionRunnable;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultEnumDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.cubrid.CUBRIDTableDefinition;
import org.jooq.meta.cubrid.dba.Tables;
import org.jooq.tools.StringUtils;

public class CUBRIDDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys(Tables.DB_INDEX.IS_UNIQUE.isTrue().and(Tables.DB_INDEX.IS_PRIMARY_KEY.isFalse()))) {
            String key = (String)record.get("constraint_name", String.class);
            String tableName = (String)record.get(Tables.DB_CLASS.CLASS_NAME);
            String columnName = (String)record.get(Tables.DB_INDEX_KEY.KEY_ATTR_NAME);
            TableDefinition table = this.getTable(this.getSchemata().get(0), tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys(Tables.DB_INDEX.IS_PRIMARY_KEY.isTrue())) {
            String key = (String)record.get("constraint_name", String.class);
            String tableName = (String)record.get(Tables.DB_CLASS.CLASS_NAME);
            String columnName = (String)record.get(Tables.DB_INDEX_KEY.KEY_ATTR_NAME);
            TableDefinition table = this.getTable(this.getSchemata().get(0), tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    private Result<Record3<String, String, String>> fetchKeys(Condition condition) {
        return this.create().select((SelectField)DSL.concat((Field[])new Field[]{Tables.DB_CLASS.CLASS_NAME, DSL.val((String)"__"), Tables.DB_INDEX.INDEX_NAME}).as("constraint_name"), Tables.DB_INDEX_KEY.KEY_ATTR_NAME, Tables.DB_CLASS.CLASS_NAME).from((TableLike)Tables.DB_INDEX).join((TableLike)Tables.DB_CLASS).on(Tables.DB_INDEX.CLASS_NAME.equal(Tables.DB_CLASS.CLASS_NAME)).join((TableLike)Tables.DB_INDEX_KEY).on(Tables.DB_INDEX_KEY.INDEX_NAME.equal(Tables.DB_INDEX.INDEX_NAME).and(Tables.DB_INDEX_KEY.CLASS_NAME.equal(Tables.DB_INDEX.CLASS_NAME))).where(condition).orderBy((OrderField)Tables.DB_INDEX.INDEX_NAME.asc()).fetch();
    }

    @Override
    protected void loadForeignKeys(final DefaultRelations relations2) throws SQLException {
        this.create().connection(new ConnectionRunnable(){

            public void run(Connection connection) throws SQLException {
                DatabaseMetaData meta = connection.getMetaData();
                for (String table : CUBRIDDatabase.this.create().selectDistinct(Tables.DB_INDEX.CLASS_NAME).from((TableLike)Tables.DB_INDEX).where(Tables.DB_INDEX.IS_FOREIGN_KEY.isTrue()).fetch(Tables.DB_INDEX.CLASS_NAME)) {
                    for (Record record : CUBRIDDatabase.this.create().fetch(meta.getImportedKeys(null, null, table))) {
                        String foreignKeyName = (String)record.get("FKTABLE_NAME", String.class) + "__" + (String)record.get("FK_NAME", String.class);
                        String foreignKeyTableName = (String)record.get("FKTABLE_NAME", String.class);
                        String foreignKeyColumnName = (String)record.get("FKCOLUMN_NAME", String.class);
                        String uniqueKeyName = (String)record.get("PKTABLE_NAME", String.class) + "__" + (String)record.get("PK_NAME", String.class);
                        TableDefinition referencingTable = CUBRIDDatabase.this.getTable(CUBRIDDatabase.this.getSchemata().get(0), foreignKeyTableName);
                        if (referencingTable == null) continue;
                        ColumnDefinition column = referencingTable.getColumn(foreignKeyColumnName);
                        relations2.addForeignKey(foreignKeyName, uniqueKeyName, column, CUBRIDDatabase.this.getSchemata().get(0));
                    }
                }
            }
        });
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r) throws SQLException {
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        result.add(new SchemaDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(Tables.DB_SERIAL.NAME, Tables.DB_SERIAL.MAX_VAL).from((TableLike)Tables.DB_SERIAL).fetch()) {
            BigInteger value = (BigInteger)StringUtils.defaultIfNull((Object)record.get(Tables.DB_SERIAL.MAX_VAL, BigInteger.class), (Object)BigInteger.valueOf(Long.MAX_VALUE));
            DataTypeDefinition type = this.getDataTypeForMAX_VAL(this.getSchemata().get(0), value);
            result.add(new DefaultSequenceDefinition(this.getSchemata().get(0), (String)record.get(Tables.DB_SERIAL.NAME), type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Tables.DB_CLASS.CLASS_NAME).from((TableLike)Tables.DB_CLASS).orderBy((OrderField)Tables.DB_CLASS.CLASS_NAME.asc()).fetch()) {
            String name = (String)record.get(Tables.DB_CLASS.CLASS_NAME);
            CUBRIDTableDefinition table = new CUBRIDTableDefinition(this.getSchemata().get(0), name, null);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        for (TableDefinition tableDefinition : this.getTables(this.getSchemata().get(0))) {
            for (Record record : this.create().fetch("SHOW COLUMNS FROM {0} WHERE TYPE LIKE 'ENUM(%)'", new QueryPart[]{DSL.field((Name)DSL.name((String)tableDefinition.getInputName()))})) {
                String table = tableDefinition.getInputName();
                String column = (String)record.get("Field", String.class);
                String columnType = (String)record.get("Type", String.class);
                String name = table + "_" + column;
                ColumnDefinition columnDefinition = tableDefinition.getColumn(column);
                if (this.getConfiguredForcedType(columnDefinition) != null) continue;
                DefaultEnumDefinition definition = new DefaultEnumDefinition(this.getSchemata().get(0), name, "");
                for (String string : columnType.replaceAll("ENUM\\(|\\)", "").split(",")) {
                    definition.addLiteral(string.trim().replaceAll("'", ""));
                }
                result.add(definition);
            }
        }
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.CUBRID);
    }
}

