/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenSecretManager;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.ExpiredOpenKeys;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMPerformanceMetrics;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneListStatusHelper;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.OzoneManagerUtils;
import org.apache.hadoop.ozone.om.PendingKeysDeletion;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.ScmClient;
import org.apache.hadoop.ozone.om.SstFilteringService;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.ListKeysResult;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUpload;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmPartInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.util.OMMultipartUploadUtils;
import org.apache.hadoop.ozone.om.service.DirectoryDeletingService;
import org.apache.hadoop.ozone.om.service.KeyDeletingService;
import org.apache.hadoop.ozone.om.service.MultipartUploadCleanupService;
import org.apache.hadoop.ozone.om.service.OpenKeyCleanupService;
import org.apache.hadoop.ozone.om.service.SnapshotDeletingService;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.MetricUtil;
import org.apache.hadoop.util.Time;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerImpl
implements KeyManager {
    private static final Logger LOG = LoggerFactory.getLogger(KeyManagerImpl.class);
    public static final int DISABLE_VALUE = -1;
    private final OzoneManager ozoneManager;
    private final ScmClient scmClient;
    private final OMMetadataManager metadataManager;
    private final long scmBlockSize;
    private final int listTrashKeysMax;
    private final OzoneBlockTokenSecretManager secretManager;
    private final boolean grpcBlockTokenEnabled;
    private KeyDeletingService keyDeletingService;
    private SstFilteringService snapshotSstFilteringService;
    private SnapshotDeletingService snapshotDeletingService;
    private final KeyProviderCryptoExtension kmsProvider;
    private final boolean enableFileSystemPaths;
    private BackgroundService dirDeletingService;
    private final OMPerformanceMetrics metrics;
    private BackgroundService openKeyCleanupService;
    private BackgroundService multipartUploadCleanupService;

    public KeyManagerImpl(OzoneManager om, ScmClient scmClient, OzoneConfiguration conf, OMPerformanceMetrics metrics) {
        this(om, scmClient, om.getMetadataManager(), conf, om.getBlockTokenMgr(), om.getKmsProvider(), metrics);
    }

    public KeyManagerImpl(OzoneManager om, ScmClient scmClient, OMMetadataManager metadataManager, OzoneConfiguration conf, OzoneBlockTokenSecretManager secretManager, KeyProviderCryptoExtension kmsProvider, OMPerformanceMetrics metrics) {
        this.scmBlockSize = (long)conf.getStorageSize("ozone.scm.block.size", "256MB", StorageUnit.BYTES);
        this.grpcBlockTokenEnabled = conf.getBoolean("hdds.block.token.enabled", false);
        this.listTrashKeysMax = conf.getInt("ozone.client.list.trash.keys.max", 1000);
        this.enableFileSystemPaths = conf.getBoolean("ozone.om.enable.filesystem.paths", false);
        this.ozoneManager = om;
        this.scmClient = scmClient;
        this.metadataManager = metadataManager;
        this.secretManager = secretManager;
        this.kmsProvider = kmsProvider;
        this.metrics = metrics;
    }

    @Override
    public void start(OzoneConfiguration configuration) {
        long serviceInterval;
        long serviceTimeout;
        if (this.keyDeletingService == null) {
            long blockDeleteInterval = configuration.getTimeDuration("ozone.block.deleting.service.interval", "60s", TimeUnit.MILLISECONDS);
            serviceTimeout = configuration.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
            this.keyDeletingService = new KeyDeletingService(this.ozoneManager, this.scmClient.getBlockClient(), this, blockDeleteInterval, serviceTimeout, (ConfigurationSource)configuration);
            this.keyDeletingService.start();
        }
        if (this.dirDeletingService == null) {
            long dirDeleteInterval = configuration.getTimeDuration("ozone.directory.deleting.service.interval", "60s", TimeUnit.MILLISECONDS);
            serviceTimeout = configuration.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
            this.dirDeletingService = new DirectoryDeletingService(dirDeleteInterval, TimeUnit.MILLISECONDS, serviceTimeout, this.ozoneManager, configuration);
            this.dirDeletingService.start();
        }
        if (this.openKeyCleanupService == null) {
            serviceInterval = configuration.getTimeDuration("ozone.om.open.key.cleanup.service.interval", "24h", TimeUnit.MILLISECONDS);
            serviceTimeout = configuration.getTimeDuration("ozone.om.open.key.cleanup.service.timeout", "300s", TimeUnit.MILLISECONDS);
            this.openKeyCleanupService = new OpenKeyCleanupService(serviceInterval, TimeUnit.MILLISECONDS, serviceTimeout, this.ozoneManager, (ConfigurationSource)configuration);
            this.openKeyCleanupService.start();
        }
        if (this.snapshotSstFilteringService == null && this.ozoneManager.isFilesystemSnapshotEnabled()) {
            serviceInterval = configuration.getTimeDuration("ozone.snapshot.filtering.service.interval", "60s", TimeUnit.MILLISECONDS);
            serviceTimeout = configuration.getTimeDuration("ozone.sst.filtering.service.timeout", "300s", TimeUnit.MILLISECONDS);
            if (this.isSstFilteringSvcEnabled()) {
                this.snapshotSstFilteringService = new SstFilteringService(serviceInterval, TimeUnit.MILLISECONDS, serviceTimeout, this.ozoneManager, configuration);
                this.snapshotSstFilteringService.start();
            }
        }
        if (this.snapshotDeletingService == null && this.ozoneManager.isFilesystemSnapshotEnabled()) {
            long snapshotServiceInterval = configuration.getTimeDuration("ozone.snapshot.deleting.service.interval", "30s", TimeUnit.MILLISECONDS);
            long snapshotServiceTimeout = configuration.getTimeDuration("ozone.snapshot.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
            try {
                this.snapshotDeletingService = new SnapshotDeletingService(snapshotServiceInterval, snapshotServiceTimeout, this.ozoneManager, this.scmClient.getBlockClient());
                this.snapshotDeletingService.start();
            }
            catch (IOException e) {
                LOG.error("Error starting Snapshot Deleting Service", (Throwable)e);
            }
        }
        if (this.multipartUploadCleanupService == null) {
            serviceInterval = configuration.getTimeDuration("ozone.om.open.mpu.cleanup.service.interval", "24h", TimeUnit.MILLISECONDS);
            serviceTimeout = configuration.getTimeDuration("ozone.om.open.mpu.cleanup.service.timeout", "300s", TimeUnit.MILLISECONDS);
            this.multipartUploadCleanupService = new MultipartUploadCleanupService(serviceInterval, TimeUnit.MILLISECONDS, serviceTimeout, this.ozoneManager, (ConfigurationSource)configuration);
            this.multipartUploadCleanupService.start();
        }
    }

    KeyProviderCryptoExtension getKMSProvider() {
        return this.kmsProvider;
    }

    @Override
    public void stop() throws IOException {
        if (this.keyDeletingService != null) {
            this.keyDeletingService.shutdown();
            this.keyDeletingService = null;
        }
        if (this.dirDeletingService != null) {
            this.dirDeletingService.shutdown();
            this.dirDeletingService = null;
        }
        if (this.openKeyCleanupService != null) {
            this.openKeyCleanupService.shutdown();
            this.openKeyCleanupService = null;
        }
        if (this.snapshotSstFilteringService != null) {
            this.snapshotSstFilteringService.shutdown();
            this.snapshotSstFilteringService = null;
        }
        if (this.snapshotDeletingService != null) {
            this.snapshotDeletingService.shutdown();
            this.snapshotDeletingService = null;
        }
        if (this.multipartUploadCleanupService != null) {
            this.multipartUploadCleanupService.shutdown();
            this.multipartUploadCleanupService = null;
        }
    }

    private OmBucketInfo getBucketInfo(String volumeName, String bucketName) throws IOException {
        String bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        return (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)bucketKey);
    }

    private KeyProviderCryptoExtension.EncryptedKeyVersion generateEDEK(final String ezKeyName) throws IOException {
        if (ezKeyName == null) {
            return null;
        }
        long generateEDEKStartTime = Time.monotonicNow();
        KeyProviderCryptoExtension.EncryptedKeyVersion edek = (KeyProviderCryptoExtension.EncryptedKeyVersion)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

            @Override
            public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws IOException {
                try {
                    return KeyManagerImpl.this.getKMSProvider().generateEncryptedKey(ezKeyName);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        });
        long generateEDEKTime = Time.monotonicNow() - generateEDEKStartTime;
        LOG.debug("generateEDEK takes {} ms", (Object)generateEDEKTime);
        Preconditions.checkNotNull((Object)edek);
        return edek;
    }

    @Override
    public OmKeyInfo lookupKey(OmKeyArgs args, ResolvedBucket bucket, String clientAddress) throws IOException {
        Preconditions.checkNotNull((Object)args);
        OmKeyInfo value = (OmKeyInfo)MetricUtil.captureLatencyNs((MutableRate)this.metrics.getLookupReadKeyInfoLatencyNs(), () -> this.readKeyInfo(args, bucket.bucketLayout()));
        if (!args.isHeadOp()) {
            MetricUtil.captureLatencyNs((MutableRate)this.metrics.getLookupGenerateBlockTokenLatencyNs(), () -> this.addBlockToken4Read(value));
            MetricUtil.captureLatencyNs((MutableRate)this.metrics.getLookupRefreshLocationLatencyNs(), () -> this.refresh(value));
            if (args.getSortDatanodes()) {
                this.sortDatanodes(clientAddress, value);
            }
        }
        return value;
    }

    private OmKeyInfo readKeyInfo(OmKeyArgs args, BucketLayout bucketLayout) throws IOException {
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        OmKeyInfo value = null;
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            try {
                keyName = OMClientRequest.validateAndNormalizeKey(this.enableFileSystemPaths, keyName, bucketLayout);
                if (bucketLayout.isFileSystemOptimized()) {
                    value = this.getOmKeyInfoFSO(volumeName, bucketName, keyName);
                } else {
                    value = this.getOmKeyInfo(volumeName, bucketName, keyName, bucketLayout);
                    if (value != null) {
                        value.setFile(true);
                    }
                }
            }
            catch (IOException ex) {
                if (ex instanceof OMException) {
                    throw ex;
                }
                throw new OMException(String.format("Error reading key metadata: /%s/%s/%s", volumeName, bucketName, keyName), (Throwable)ex, OMException.ResultCodes.INTERNAL_ERROR);
            }
        }
        catch (Throwable throwable) {
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            throw throwable;
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("volume:{} bucket:{} Key:{} not found", new Object[]{volumeName, bucketName, keyName});
            }
            throw new OMException("Key:" + keyName + " not found", OMException.ResultCodes.KEY_NOT_FOUND);
        }
        if (args.getLatestVersionLocation()) {
            this.slimLocationVersion(value);
        }
        return value;
    }

    private OmKeyInfo getOmKeyInfo(String volumeName, String bucketName, String keyName, BucketLayout bucketLayout) throws IOException {
        String keyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
        return (OmKeyInfo)this.metadataManager.getKeyTable(bucketLayout).get((Object)keyBytes);
    }

    private OmKeyInfo getOmKeyInfoFSO(String volumeName, String bucketName, String keyName) throws IOException {
        OzoneFileStatus fileStatus = OMFileRequest.getOMKeyInfoIfExists(this.metadataManager, volumeName, bucketName, keyName, this.scmBlockSize, this.ozoneManager.getDefaultReplicationConfig(), false);
        if (fileStatus == null) {
            return null;
        }
        if (fileStatus.isDirectory()) {
            String keyPath = OzoneFSUtils.addTrailingSlashIfNeeded((String)fileStatus.getKeyInfo().getKeyName());
            fileStatus.getKeyInfo().setKeyName(keyPath);
        }
        fileStatus.getKeyInfo().setFile(fileStatus.isFile());
        return fileStatus.getKeyInfo();
    }

    private void addBlockToken4Read(OmKeyInfo value) throws IOException {
        Preconditions.checkNotNull((Object)value, (Object)"OMKeyInfo cannot be null");
        if (this.grpcBlockTokenEnabled) {
            String remoteUser = HddsServerUtil.getRemoteUser().getShortUserName();
            for (OmKeyLocationInfoGroup key : value.getKeyLocationVersions()) {
                key.getLocationList().forEach(k -> k.setToken(this.secretManager.generateToken(remoteUser, k.getBlockID(), EnumSet.of(HddsProtos.BlockTokenSecretProto.AccessModeProto.READ), k.getLength())));
            }
        }
    }

    @VisibleForTesting
    protected void refreshPipeline(List<OmKeyInfo> keyList) throws IOException {
        if (keyList == null || keyList.isEmpty()) {
            return;
        }
        HashSet<Long> containerIDs = new HashSet<Long>();
        for (OmKeyInfo keyInfo : keyList) {
            List locationInfoGroups = keyInfo.getKeyLocationVersions();
            for (OmKeyLocationInfoGroup key : locationInfoGroups) {
                for (List omKeyLocationInfoList : key.getLocationLists()) {
                    for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoList) {
                        containerIDs.add(omKeyLocationInfo.getContainerID());
                    }
                }
            }
        }
        Map<Long, ContainerWithPipeline> containerWithPipelineMap = this.refreshPipeline(containerIDs);
        for (OmKeyInfo keyInfo : keyList) {
            List locationInfoGroups = keyInfo.getKeyLocationVersions();
            for (OmKeyLocationInfoGroup key : locationInfoGroups) {
                for (List omKeyLocationInfoList : key.getLocationLists()) {
                    for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoList) {
                        ContainerWithPipeline cp = containerWithPipelineMap.get(omKeyLocationInfo.getContainerID());
                        if (cp == null || cp.getPipeline().equals((Object)omKeyLocationInfo.getPipeline())) continue;
                        omKeyLocationInfo.setPipeline(cp.getPipeline());
                    }
                }
            }
        }
    }

    @VisibleForTesting
    protected Map<Long, ContainerWithPipeline> refreshPipeline(Set<Long> containerIDs) throws IOException {
        if (this.scmClient.getContainerClient() == null || containerIDs == null || containerIDs.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, ContainerWithPipeline> containerWithPipelineMap = new HashMap<Long, ContainerWithPipeline>();
        try {
            List cpList = this.scmClient.getContainerClient().getContainerWithPipelineBatch(new ArrayList<Long>(containerIDs));
            for (ContainerWithPipeline cp : cpList) {
                containerWithPipelineMap.put(cp.getContainerInfo().getContainerID(), cp);
            }
            return containerWithPipelineMap;
        }
        catch (IOException ioEx) {
            LOG.debug("Get containerPipeline failed for {}", containerIDs, (Object)ioEx);
            throw new OMException(ioEx.getMessage(), OMException.ResultCodes.SCM_GET_PIPELINE_EXCEPTION);
        }
    }

    @Override
    public ListKeysResult listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        if (this.enableFileSystemPaths) {
            startKey = OmUtils.normalizeKey((String)startKey, (boolean)true);
            keyPrefix = OmUtils.normalizeKey((String)keyPrefix, (boolean)true);
        }
        ListKeysResult listKeysResult = this.metadataManager.listKeys(volumeName, bucketName, startKey, keyPrefix, maxKeys);
        List keyList = listKeysResult.getKeys();
        for (OmKeyInfo omKeyInfo : keyList) {
            this.slimLocationVersion(omKeyInfo);
        }
        return listKeysResult;
    }

    @Override
    public List<RepeatedOmKeyInfo> listTrash(String volumeName, String bucketName, String startKeyName, String keyPrefix, int maxKeys) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkArgument((maxKeys <= this.listTrashKeysMax ? 1 : 0) != 0, (Object)"The max keys limit specified is not less than the cluster allowed maximum limit.");
        return this.metadataManager.listTrash(volumeName, bucketName, startKeyName, keyPrefix, maxKeys);
    }

    @Override
    public PendingKeysDeletion getPendingDeletionKeys(int count) throws IOException {
        OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)this.metadataManager;
        return omMetadataManager.getPendingDeletionKeys(count, this.ozoneManager.getOmSnapshotManager());
    }

    @Override
    public ExpiredOpenKeys getExpiredOpenKeys(Duration expireThreshold, int count, BucketLayout bucketLayout) throws IOException {
        return this.metadataManager.getExpiredOpenKeys(expireThreshold, count, bucketLayout);
    }

    @Override
    public List<OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket> getExpiredMultipartUploads(Duration expireThreshold, int maxParts) throws IOException {
        return this.metadataManager.getExpiredMultipartUploads(expireThreshold, maxParts);
    }

    @Override
    public OMMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public KeyDeletingService getDeletingService() {
        return this.keyDeletingService;
    }

    @Override
    public BackgroundService getDirDeletingService() {
        return this.dirDeletingService;
    }

    @Override
    public BackgroundService getOpenKeyCleanupService() {
        return this.openKeyCleanupService;
    }

    @Override
    public BackgroundService getMultipartUploadCleanupService() {
        return this.multipartUploadCleanupService;
    }

    @Override
    public SstFilteringService getSnapshotSstFilteringService() {
        return this.snapshotSstFilteringService;
    }

    @Override
    public SnapshotDeletingService getSnapshotDeletingService() {
        return this.snapshotDeletingService;
    }

    public boolean isSstFilteringSvcEnabled() {
        long serviceInterval = this.ozoneManager.getConfiguration().getTimeDuration("ozone.snapshot.filtering.service.interval", "60s", TimeUnit.MILLISECONDS);
        return serviceInterval != -1L;
    }

    @Override
    public OmMultipartUploadList listMultipartUploads(String volumeName, String bucketName, String prefix) throws OMException {
        OmMultipartUploadList omMultipartUploadList;
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            Set multipartUploadKeys = this.metadataManager.getMultipartUploadKeys(volumeName, bucketName, prefix);
            List collect = multipartUploadKeys.stream().map(OmMultipartUpload::from).peek(upload -> {
                try {
                    Table keyInfoTable = this.metadataManager.getMultipartInfoTable();
                    OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)keyInfoTable.get((Object)upload.getDbKey());
                    upload.setCreationTime(Instant.ofEpochMilli(multipartKeyInfo.getCreationTime()));
                    upload.setReplicationConfig(multipartKeyInfo.getReplicationConfig());
                }
                catch (IOException iOException) {
                    LOG.warn("Open key entry for multipart upload record can be read  {}", (Object)this.metadataManager.getOzoneKey(upload.getVolumeName(), upload.getBucketName(), upload.getKeyName()));
                }
            }).collect(Collectors.toList());
            omMultipartUploadList = new OmMultipartUploadList(collect);
        }
        catch (IOException ex) {
            try {
                LOG.error("List Multipart Uploads Failed: volume: " + volumeName + "bucket: " + bucketName + "prefix: " + prefix, (Throwable)ex);
                throw new OMException(ex.getMessage(), OMException.ResultCodes.LIST_MULTIPART_UPLOAD_PARTS_FAILED);
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return omMultipartUploadList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OmMultipartUploadListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        OmMultipartUploadListParts omMultipartUploadListParts;
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)keyName);
        Preconditions.checkNotNull((Object)uploadID);
        boolean isTruncated = false;
        int nextPartNumberMarker = 0;
        BucketLayout bucketLayout = BucketLayout.DEFAULT;
        String buckKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        OmBucketInfo buckInfo = (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)buckKey);
        bucketLayout = buckInfo.getBucketLayout();
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            ArrayList<OmPartInfo> omPartInfoList;
            ReplicationConfig replicationConfig;
            Iterator partKeyInfoMapIterator;
            block12: {
                OmKeyInfo omKeyInfo;
                String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
                OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
                if (multipartKeyInfo == null) {
                    throw new OMException("No Such Multipart upload exists for this key.", OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                }
                partKeyInfoMapIterator = multipartKeyInfo.getPartKeyInfoMap().iterator();
                replicationConfig = null;
                int count = 0;
                omPartInfoList = new ArrayList<OmPartInfo>();
                while (true) {
                    if (count >= maxParts || !partKeyInfoMapIterator.hasNext()) {
                        if (replicationConfig == null) {
                            if (this.isBucketFSOptimized(volumeName, bucketName)) {
                                multipartKey = this.getMultipartOpenKeyFSO(volumeName, bucketName, keyName, uploadID);
                            }
                            if ((omKeyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable(bucketLayout).get((Object)multipartKey)) != null) break;
                            throw new IllegalStateException("Open key is missing for multipart upload " + multipartKey);
                        }
                        break block12;
                    }
                    OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoMapIterator.next();
                    nextPartNumberMarker = partKeyInfo.getPartNumber();
                    if (nextPartNumberMarker <= partNumberMarker) continue;
                    String partName = this.getPartName(partKeyInfo, volumeName, bucketName, keyName);
                    OmPartInfo omPartInfo = new OmPartInfo(partKeyInfo.getPartNumber(), partName, partKeyInfo.getPartKeyInfo().getModificationTime(), partKeyInfo.getPartKeyInfo().getDataSize());
                    omPartInfoList.add(omPartInfo);
                    replicationConfig = ReplicationConfig.fromProto((HddsProtos.ReplicationType)partKeyInfo.getPartKeyInfo().getType(), (HddsProtos.ReplicationFactor)partKeyInfo.getPartKeyInfo().getFactor(), (HddsProtos.ECReplicationConfig)partKeyInfo.getPartKeyInfo().getEcReplicationConfig());
                    ++count;
                }
                replicationConfig = omKeyInfo.getReplicationConfig();
            }
            Preconditions.checkNotNull(replicationConfig, (Object)"ReplicationConfig can't be identified");
            if (partKeyInfoMapIterator.hasNext()) {
                isTruncated = true;
            } else {
                isTruncated = false;
                nextPartNumberMarker = 0;
            }
            OmMultipartUploadListParts omMultipartUploadListParts2 = new OmMultipartUploadListParts(replicationConfig, nextPartNumberMarker, isTruncated);
            omMultipartUploadListParts2.addPartList(omPartInfoList);
            omMultipartUploadListParts = omMultipartUploadListParts2;
        }
        catch (OMException ex) {
            try {
                throw ex;
                catch (IOException ex2) {
                    LOG.error("List Multipart Upload Parts Failed: volume: {}, bucket: {}, ,key: {} ", new Object[]{volumeName, bucketName, keyName, ex2});
                    throw new OMException(ex2.getMessage(), OMException.ResultCodes.LIST_MULTIPART_UPLOAD_PARTS_FAILED);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return omMultipartUploadListParts;
    }

    private String getPartName(OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo, String volName, String buckName, String keyName) throws IOException {
        String partName = partKeyInfo.getPartName();
        if (this.isBucketFSOptimized(volName, buckName)) {
            String parentDir = OzoneFSUtils.getParentDir((String)keyName);
            String partFileName = OzoneFSUtils.getFileName((String)partKeyInfo.getPartName());
            StringBuilder fullKeyPartName = new StringBuilder();
            fullKeyPartName.append("/");
            fullKeyPartName.append(volName);
            fullKeyPartName.append("/");
            fullKeyPartName.append(buckName);
            if (StringUtils.isNotEmpty((CharSequence)parentDir)) {
                fullKeyPartName.append("/");
                fullKeyPartName.append(parentDir);
            }
            fullKeyPartName.append("/");
            fullKeyPartName.append(partFileName);
            return fullKeyPartName.toString();
        }
        return partName;
    }

    private String getMultipartOpenKeyFSO(String volumeName, String bucketName, String keyName, String uploadID) throws IOException {
        OMMetadataManager metaMgr = this.metadataManager;
        return OMMultipartUploadUtils.getMultipartOpenKeyFSO(volumeName, bucketName, keyName, uploadID, metaMgr);
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        List list;
        this.validateOzoneObj(obj);
        ResolvedBucket resolvedBucket = this.ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)obj.getVolumeName(), (Object)obj.getBucketName()));
        String volume = resolvedBucket.realVolume();
        String bucket = resolvedBucket.realBucket();
        String keyName = obj.getKeyName();
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        try {
            OMFileRequest.validateBucket(this.metadataManager, volume, bucket);
            String objectKey = this.metadataManager.getOzoneKey(volume, bucket, keyName);
            OmKeyInfo keyInfo = this.isBucketFSOptimized(volume, bucket) ? this.getOmKeyInfoFSO(volume, bucket, keyName) : this.getOmKeyInfo(volume, bucket, keyName, resolvedBucket.bucketLayout());
            if (keyInfo == null) {
                throw new OMException("Key not found. Key:" + objectKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            list = keyInfo.getAcls();
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Get acl operation failed for key:{}/{}/{}", new Object[]{volume, bucket, keyName, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        return list;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean checkAccess(OzoneObj ozObject, RequestContext context) throws OMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 10[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkChildrenAcls(OzoneObj ozObject, RequestContext context) throws IOException {
        OzoneFileStatus ozoneFileStatus = ozObject.getOzonePrefixPathViewer().getOzoneFileStatus();
        OmKeyInfo keyInfo = ozoneFileStatus.getKeyInfo();
        Stack<OzoneFileStatus> directories = new Stack<OzoneFileStatus>();
        boolean hasAccess = OzoneAclUtil.checkAclRights((List)keyInfo.getAcls(), (RequestContext)context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("user:{} has access rights for key:{} :{} ", new Object[]{context.getClientUgi(), ozObject.getKeyName(), hasAccess});
        }
        if (ozoneFileStatus.isDirectory() && hasAccess) {
            directories.add(ozoneFileStatus);
        }
        while (!directories.isEmpty() && hasAccess) {
            ozoneFileStatus = (OzoneFileStatus)directories.pop();
            String keyPath = ozoneFileStatus.getTrimmedName();
            Iterator children = ozObject.getOzonePrefixPathViewer().getChildren(keyPath);
            while (hasAccess && children.hasNext()) {
                ozoneFileStatus = (OzoneFileStatus)children.next();
                keyInfo = ozoneFileStatus.getKeyInfo();
                hasAccess = OzoneAclUtil.checkAclRights((List)keyInfo.getAcls(), (RequestContext)context);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("user:{} has access rights for key:{} :{} ", new Object[]{context.getClientUgi(), keyInfo.getKeyName(), hasAccess});
                }
                if (!hasAccess || !ozoneFileStatus.isDirectory()) continue;
                directories.add(ozoneFileStatus);
            }
        }
        return hasAccess;
    }

    private void validateOzoneObj(OzoneObj obj) throws OMException {
        Objects.requireNonNull(obj);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.KEY)) {
            throw new IllegalArgumentException("Unexpected argument passed to KeyManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String keyName = obj.getKeyName();
        if (Strings.isNullOrEmpty((String)volume)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)bucket)) {
            throw new OMException("Bucket name is required.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)keyName)) {
            throw new OMException("Key name is required.", OMException.ResultCodes.KEY_NOT_FOUND);
        }
    }

    @Override
    public OzoneFileStatus getFileStatus(OmKeyArgs args) throws IOException {
        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
        return this.getFileStatus(args, null);
    }

    @Override
    public OzoneFileStatus getFileStatus(OmKeyArgs args, String clientAddress) throws IOException {
        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        if (this.isBucketFSOptimized(volumeName, bucketName)) {
            return this.getOzoneFileStatusFSO(args, clientAddress, false);
        }
        return this.getOzoneFileStatus(args, clientAddress);
    }

    private OzoneFileStatus getOzoneFileStatus(OmKeyArgs args, String clientAddress) throws IOException {
        OmKeyInfo fakeDirKeyInfo;
        OmKeyInfo dirKeyInfo;
        OmKeyInfo fileKeyInfo;
        String keyName;
        String bucketName;
        String volumeName;
        block21: {
            OzoneFileStatus ozoneFileStatus;
            Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
            volumeName = args.getVolumeName();
            bucketName = args.getBucketName();
            keyName = args.getKeyName();
            fileKeyInfo = null;
            dirKeyInfo = null;
            fakeDirKeyInfo = null;
            this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            try {
                if (keyName.length() != 0) break block21;
                OMFileRequest.validateBucket(this.metadataManager, volumeName, bucketName);
                ozoneFileStatus = new OzoneFileStatus();
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                if (fileKeyInfo != null) {
                    if (args.getLatestVersionLocation()) {
                        this.slimLocationVersion(fileKeyInfo);
                    }
                    if (!args.isHeadOp()) {
                        this.refresh(fileKeyInfo);
                        if (args.getSortDatanodes()) {
                            this.sortDatanodes(clientAddress, fileKeyInfo);
                        }
                    }
                }
                throw throwable;
            }
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            if (fileKeyInfo != null) {
                if (args.getLatestVersionLocation()) {
                    this.slimLocationVersion(fileKeyInfo);
                }
                if (!args.isHeadOp()) {
                    this.refresh(fileKeyInfo);
                    if (args.getSortDatanodes()) {
                        this.sortDatanodes(clientAddress, fileKeyInfo);
                    }
                }
            }
            return ozoneFileStatus;
        }
        String fileKeyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
        BucketLayout layout = OzoneManagerUtils.getBucketLayout(this.metadataManager, volumeName, bucketName);
        fileKeyInfo = (OmKeyInfo)this.metadataManager.getKeyTable(layout).get((Object)fileKeyBytes);
        String dirKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        if (fileKeyInfo == null) {
            String dirKeyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, dirKey);
            dirKeyInfo = (OmKeyInfo)this.metadataManager.getKeyTable(layout).get((Object)dirKeyBytes);
            if (dirKeyInfo == null) {
                fakeDirKeyInfo = this.createFakeDirIfShould(volumeName, bucketName, keyName, layout);
            }
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        if (fileKeyInfo != null) {
            if (args.getLatestVersionLocation()) {
                this.slimLocationVersion(fileKeyInfo);
            }
            if (!args.isHeadOp()) {
                this.refresh(fileKeyInfo);
                if (args.getSortDatanodes()) {
                    this.sortDatanodes(clientAddress, fileKeyInfo);
                }
            }
        }
        if (fileKeyInfo != null) {
            return new OzoneFileStatus(fileKeyInfo, this.scmBlockSize, false);
        }
        if (dirKeyInfo != null) {
            return new OzoneFileStatus(dirKeyInfo, this.scmBlockSize, true);
        }
        if (fakeDirKeyInfo != null) {
            return new OzoneFileStatus(fakeDirKeyInfo, this.scmBlockSize, true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to get file status for the key: volume: {}, bucket: {}, key: {}, with error: No such file exists.", new Object[]{volumeName, bucketName, keyName});
        }
        throw new OMException("Unable to get file status: volume: " + volumeName + " bucket: " + bucketName + " key: " + keyName, OMException.ResultCodes.FILE_NOT_FOUND);
    }

    private OmKeyInfo createFakeDirIfShould(String volume, String bucket, String keyName, BucketLayout layout) throws IOException {
        String dirKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        String targetKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)this.metadataManager.getOzoneKey(volume, bucket, keyName));
        Table keyTable = this.metadataManager.getKeyTable(layout);
        Iterator cacheIterator = keyTable.cacheIterator();
        HashSet<String> deletedKeys = new HashSet<String>();
        while (cacheIterator.hasNext()) {
            boolean exists;
            Map.Entry cacheEntry = (Map.Entry)cacheIterator.next();
            String cacheKey = (String)((CacheKey)cacheEntry.getKey()).getCacheKey();
            CacheValue cacheValue = (CacheValue)cacheEntry.getValue();
            boolean bl = exists = cacheValue != null && cacheValue.getCacheValue() != null;
            if (exists && cacheKey.startsWith(targetKey) && !Objects.equals(cacheKey, targetKey)) {
                LOG.debug("Fake dir {} required for {}", (Object)targetKey, (Object)cacheKey);
                return this.createDirectoryKey((OmKeyInfo)cacheValue.getCacheValue(), dirKey);
            }
            if (exists) continue;
            deletedKeys.add(cacheKey);
        }
        Throwable throwable = null;
        Object var11_12 = null;
        try (TableIterator keyTblItr = keyTable.iterator((Object)targetKey);){
            while (keyTblItr.hasNext()) {
                Table.KeyValue keyValue = (Table.KeyValue)keyTblItr.next();
                if (keyValue == null) continue;
                String key = (String)keyValue.getKey();
                if (key.startsWith(targetKey)) {
                    if (Objects.equals(key, targetKey) || deletedKeys.contains(key)) continue;
                    LOG.debug("Fake dir {} required for {}", (Object)targetKey, (Object)key);
                    return this.createDirectoryKey((OmKeyInfo)keyValue.getValue(), dirKey);
                }
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    private OzoneFileStatus getOzoneFileStatusFSO(OmKeyArgs args, String clientAddress, boolean skipFileNotFoundError) throws IOException {
        OzoneFileStatus fileStatus;
        String keyName;
        String bucketName;
        String volumeName;
        block10: {
            OzoneFileStatus ozoneFileStatus;
            volumeName = args.getVolumeName();
            bucketName = args.getBucketName();
            keyName = args.getKeyName();
            fileStatus = null;
            this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            try {
                if (keyName.length() != 0) break block10;
                OMFileRequest.validateBucket(this.metadataManager, volumeName, bucketName);
                ozoneFileStatus = new OzoneFileStatus();
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return ozoneFileStatus;
        }
        fileStatus = OMFileRequest.getOMKeyInfoIfExists(this.metadataManager, volumeName, bucketName, keyName, this.scmBlockSize, this.ozoneManager.getDefaultReplicationConfig());
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        if (fileStatus != null) {
            if (fileStatus.isFile()) {
                OmKeyInfo fileKeyInfo = fileStatus.getKeyInfo();
                if (args.getLatestVersionLocation()) {
                    this.slimLocationVersion(fileKeyInfo);
                }
                if (!args.isHeadOp()) {
                    this.refresh(fileKeyInfo);
                    if (args.getSortDatanodes()) {
                        this.sortDatanodes(clientAddress, fileKeyInfo);
                    }
                }
                return new OzoneFileStatus(fileKeyInfo, this.scmBlockSize, false);
            }
            return fileStatus;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to get file status for the key: volume: {}, bucket: {}, key: {}, with error: No such file exists.", new Object[]{volumeName, bucketName, keyName});
        }
        if (skipFileNotFoundError) {
            return fileStatus;
        }
        throw new OMException("Unable to get file status: volume: " + volumeName + " bucket: " + bucketName + " key: " + keyName, OMException.ResultCodes.FILE_NOT_FOUND);
    }

    private OmKeyInfo createDirectoryKey(OmKeyInfo keyInfo, String keyName) throws IOException {
        OmBucketInfo bucketInfo = this.getBucketInfo(keyInfo.getVolumeName(), keyInfo.getBucketName());
        String dir = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        FileEncryptionInfo encInfo = this.getFileEncryptionInfo(bucketInfo);
        return new OmKeyInfo.Builder().setVolumeName(keyInfo.getVolumeName()).setBucketName(keyInfo.getBucketName()).setKeyName(dir).setFileName(OzoneFSUtils.getFileName((String)keyName)).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList()))).setCreationTime(Time.now()).setModificationTime(Time.now()).setDataSize(0L).setReplicationConfig(keyInfo.getReplicationConfig()).setFileEncryptionInfo(encInfo).setAcls(keyInfo.getAcls()).build();
    }

    @Override
    public OmKeyInfo lookupFile(OmKeyArgs args, String clientAddress) throws IOException {
        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        OzoneFileStatus fileStatus = this.isBucketFSOptimized(volumeName, bucketName) ? this.getOzoneFileStatusFSO(args, clientAddress, false) : this.getOzoneFileStatus(args, clientAddress);
        if (fileStatus.isFile()) {
            if (!args.isHeadOp()) {
                this.addBlockToken4Read(fileStatus.getKeyInfo());
            }
            return fileStatus.getKeyInfo();
        }
        throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
    }

    @Override
    public void refresh(OmKeyInfo key) throws IOException {
        Preconditions.checkNotNull((Object)key, (Object)"Key info can not be null");
        this.refreshPipeline(Arrays.asList(key));
    }

    public static boolean isKeyDeleted(String key, Table keyTable) {
        CacheValue omKeyInfoCacheValue = keyTable.getCacheValue(new CacheKey((Object)key));
        return omKeyInfoCacheValue != null && omKeyInfoCacheValue.getCacheValue() == null;
    }

    public static boolean isKeyInCache(String key, Table keyTable) {
        return keyTable.getCacheValue(new CacheKey((Object)key)) != null;
    }

    private void listStatusFindKeyInTableCache(Iterator<Map.Entry<CacheKey<String>, CacheValue<OmKeyInfo>>> cacheIter, String keyArgs, String startCacheKey, boolean recursive, TreeMap<String, OzoneFileStatus> cacheKeyMap) throws IOException {
        HashMap<String, OmKeyInfo> remainingKeys = new HashMap<String, OmKeyInfo>();
        int volBuckEndIndex = StringUtils.ordinalIndexOf((CharSequence)startCacheKey, (CharSequence)"/", (int)3);
        String volumeBuckPrefix = startCacheKey.substring(0, volBuckEndIndex + 1);
        while (cacheIter.hasNext()) {
            Map.Entry<CacheKey<String>, CacheValue<OmKeyInfo>> entry = cacheIter.next();
            String cacheKey = (String)entry.getKey().getCacheKey();
            if (cacheKey.equals(keyArgs)) continue;
            OmKeyInfo cacheOmKeyInfo = (OmKeyInfo)entry.getValue().getCacheValue();
            if (cacheOmKeyInfo != null && cacheKey.startsWith(keyArgs) && cacheKey.compareTo(startCacheKey) >= 0) {
                String remainingKey;
                if (!recursive && (remainingKey = StringUtils.stripEnd((String)cacheKey.substring(keyArgs.length()), (String)"/")).contains("/")) {
                    remainingKeys.put(cacheKey, cacheOmKeyInfo);
                    continue;
                }
                OzoneFileStatus fileStatus = new OzoneFileStatus(cacheOmKeyInfo, this.scmBlockSize, !OzoneFSUtils.isFile((String)cacheKey));
                cacheKeyMap.putIfAbsent(cacheKey, fileStatus);
                continue;
            }
            if (cacheOmKeyInfo != null || cacheKeyMap.containsKey(cacheKey)) continue;
            cacheKeyMap.put(cacheKey, null);
        }
        if (!recursive) {
            for (Map.Entry entry : remainingKeys.entrySet()) {
                String remainingKey = (String)entry.getKey();
                String immediateChild = OzoneFSUtils.getImmediateChild((String)remainingKey, (String)keyArgs);
                if (cacheKeyMap.containsKey(immediateChild)) continue;
                String immediateChildKeyName = immediateChild.replaceAll(volumeBuckPrefix, "");
                OmKeyInfo fakeDirEntry = this.createDirectoryKey((OmKeyInfo)entry.getValue(), immediateChildKeyName);
                cacheKeyMap.put(immediateChild, new OzoneFileStatus(fakeDirEntry, this.scmBlockSize, true));
            }
        }
    }

    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries) throws IOException {
        return this.listStatus(args, recursive, startKey, numEntries, null);
    }

    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries, String clientAddress) throws IOException {
        return this.listStatus(args, recursive, startKey, numEntries, clientAddress, false);
    }

    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries, String clientAddress, boolean allowPartialPrefixes) throws IOException {
        TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> iterator;
        Table keyTable;
        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        ArrayList<OzoneFileStatus> fileStatusList = new ArrayList<OzoneFileStatus>();
        if (numEntries <= 0L) {
            return fileStatusList;
        }
        if (this.isBucketFSOptimized(volumeName, bucketName)) {
            Preconditions.checkArgument((!recursive ? 1 : 0) != 0);
            OzoneListStatusHelper statusHelper = new OzoneListStatusHelper(this.metadataManager, this.scmBlockSize, this::getOzoneFileStatusFSO, this.ozoneManager.getDefaultReplicationConfig());
            Collection<OzoneFileStatus> statuses = statusHelper.listStatusFSO(args, startKey, numEntries, clientAddress, allowPartialPrefixes);
            return this.buildFinalStatusList(statuses, args, clientAddress);
        }
        TreeMap<String, OzoneFileStatus> cacheKeyMap = new TreeMap<String, OzoneFileStatus>();
        if (Strings.isNullOrEmpty((String)startKey)) {
            OzoneFileStatus fileStatus = this.getFileStatus(args, clientAddress);
            if (fileStatus.isFile()) {
                return Collections.singletonList(fileStatus);
            }
            startKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        }
        String keyArgs = OzoneFSUtils.addTrailingSlashIfNeeded((String)this.metadataManager.getOzoneKey(volumeName, bucketName, keyName));
        this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            keyTable = this.metadataManager.getKeyTable(OzoneManagerUtils.getBucketLayout(this.metadataManager, volumeName, bucketName));
            iterator = this.getIteratorForKeyInTableCache(recursive, startKey, volumeName, bucketName, cacheKeyMap, keyArgs, (Table<String, OmKeyInfo>)keyTable);
        }
        catch (Throwable throwable) {
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            throw throwable;
        }
        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            this.findKeyInDbWithIterator(recursive, startKey, numEntries, volumeName, bucketName, keyName, cacheKeyMap, keyArgs, (Table<String, OmKeyInfo>)keyTable, iterator);
        }
        finally {
            iterator.close();
        }
        int countEntries = 0;
        for (OzoneFileStatus fileStatus : cacheKeyMap.values()) {
            if (fileStatus == null) continue;
            fileStatusList.add(fileStatus);
            if ((long)(++countEntries) >= numEntries) break;
        }
        cacheKeyMap.clear();
        ArrayList<OmKeyInfo> keyInfoList = new ArrayList<OmKeyInfo>(fileStatusList.size());
        fileStatusList.stream().map(s -> s.getKeyInfo()).forEach(keyInfoList::add);
        if (args.getLatestVersionLocation()) {
            this.slimLocationVersion(keyInfoList.toArray(new OmKeyInfo[0]));
        }
        this.refreshPipelineFromCache(keyInfoList);
        if (args.getSortDatanodes()) {
            this.sortDatanodes(clientAddress, keyInfoList.toArray(new OmKeyInfo[0]));
        }
        return fileStatusList;
    }

    private TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> getIteratorForKeyInTableCache(boolean recursive, String startKey, String volumeName, String bucketName, TreeMap<String, OzoneFileStatus> cacheKeyMap, String keyArgs, Table<String, OmKeyInfo> keyTable) throws IOException {
        Iterator cacheIter = keyTable.cacheIterator();
        String startCacheKey = "/" + volumeName + "/" + bucketName + "/" + (startKey.equals("/") ? "" : startKey);
        this.listStatusFindKeyInTableCache(cacheIter, keyArgs, startCacheKey, recursive, cacheKeyMap);
        TableIterator iterator = keyTable.iterator();
        return iterator;
    }

    private void findKeyInDbWithIterator(boolean recursive, String startKey, long numEntries, String volumeName, String bucketName, String keyName, TreeMap<String, OzoneFileStatus> cacheKeyMap, String keyArgs, Table<String, OmKeyInfo> keyTable, TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> iterator) throws IOException {
        String seekKeyInDb = this.metadataManager.getOzoneKey(volumeName, bucketName, startKey);
        Table.KeyValue entry = (Table.KeyValue)iterator.seek((Object)seekKeyInDb);
        int countEntries = 0;
        if (iterator.hasNext()) {
            if (((String)entry.getKey()).equals(keyArgs)) {
                iterator.next();
            }
            while (iterator.hasNext() && numEntries - (long)countEntries > 0L) {
                entry = (Table.KeyValue)iterator.next();
                String entryInDb = (String)entry.getKey();
                OmKeyInfo omKeyInfo = (OmKeyInfo)entry.getValue();
                if (!entryInDb.startsWith(keyArgs)) break;
                String entryKeyName = omKeyInfo.getKeyName();
                if (recursive) {
                    if (cacheKeyMap.containsKey(entryInDb)) continue;
                    cacheKeyMap.put(entryInDb, new OzoneFileStatus(omKeyInfo, this.scmBlockSize, !OzoneFSUtils.isFile((String)entryKeyName)));
                    ++countEntries;
                    continue;
                }
                String immediateChild = OzoneFSUtils.getImmediateChild((String)entryKeyName, (String)keyName);
                boolean isFile = OzoneFSUtils.isFile((String)immediateChild);
                if (isFile) {
                    if (cacheKeyMap.containsKey(entryInDb)) continue;
                    cacheKeyMap.put(entryInDb, new OzoneFileStatus(omKeyInfo, this.scmBlockSize, !isFile));
                    ++countEntries;
                    continue;
                }
                if (!cacheKeyMap.containsKey(entryInDb)) {
                    if (!entryKeyName.equals(immediateChild)) {
                        OmKeyInfo fakeDirEntry = this.createDirectoryKey(omKeyInfo, immediateChild);
                        String fakeDirKey = this.ozoneManager.getMetadataManager().getOzoneKey(fakeDirEntry.getVolumeName(), fakeDirEntry.getBucketName(), fakeDirEntry.getKeyName());
                        cacheKeyMap.put(fakeDirKey, new OzoneFileStatus(fakeDirEntry, this.scmBlockSize, true));
                    } else {
                        cacheKeyMap.put(entryInDb, new OzoneFileStatus(omKeyInfo, 0L, true));
                    }
                    ++countEntries;
                }
                iterator.seek((Object)this.getNextGreaterString(volumeName, bucketName, immediateChild));
            }
        }
    }

    private List<OzoneFileStatus> buildFinalStatusList(Collection<OzoneFileStatus> statusesCollection, OmKeyArgs omKeyArgs, String clientAddress) throws IOException {
        ArrayList<OzoneFileStatus> fileStatusFinalList = new ArrayList<OzoneFileStatus>();
        ArrayList<OmKeyInfo> keyInfoList = new ArrayList<OmKeyInfo>();
        for (OzoneFileStatus fileStatus : statusesCollection) {
            if (fileStatus.isFile()) {
                keyInfoList.add(fileStatus.getKeyInfo());
            }
            fileStatusFinalList.add(fileStatus);
        }
        return this.sortPipelineInfo(fileStatusFinalList, keyInfoList, omKeyArgs, clientAddress);
    }

    private List<OzoneFileStatus> sortPipelineInfo(List<OzoneFileStatus> fileStatusFinalList, List<OmKeyInfo> keyInfoList, OmKeyArgs omKeyArgs, String clientAddress) throws IOException {
        if (omKeyArgs.getLatestVersionLocation()) {
            this.slimLocationVersion(keyInfoList.toArray(new OmKeyInfo[0]));
        }
        this.refreshPipelineFromCache(keyInfoList);
        if (omKeyArgs.getSortDatanodes()) {
            this.sortDatanodes(clientAddress, keyInfoList.toArray(new OmKeyInfo[0]));
        }
        return fileStatusFinalList;
    }

    private String getNextGreaterString(String volumeName, String bucketName, String keyPrefix) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyPrefix) ? 1 : 0) != 0, (Object)"Key prefix is null or empty");
        StringCodec codec = StringCodec.get();
        byte[] keyPrefixInBytes = codec.toPersistedFormat(keyPrefix);
        int n = keyPrefixInBytes.length - 1;
        keyPrefixInBytes[n] = (byte)(keyPrefixInBytes[n] + 1);
        return this.metadataManager.getOzoneKey(volumeName, bucketName, codec.fromPersistedFormat(keyPrefixInBytes));
    }

    private FileEncryptionInfo getFileEncryptionInfo(OmBucketInfo bucketInfo) throws IOException {
        FileEncryptionInfo encInfo = null;
        BucketEncryptionKeyInfo ezInfo = bucketInfo.getEncryptionKeyInfo();
        if (ezInfo != null) {
            if (this.getKMSProvider() == null) {
                throw new OMException("Invalid KMS provider, check configuration hadoop.security.key.provider.path", OMException.ResultCodes.INVALID_KMS_PROVIDER);
            }
            String ezKeyName = ezInfo.getKeyName();
            KeyProviderCryptoExtension.EncryptedKeyVersion edek = this.generateEDEK(ezKeyName);
            encInfo = new FileEncryptionInfo(ezInfo.getSuite(), ezInfo.getVersion(), edek.getEncryptedKeyVersion().getMaterial(), edek.getEncryptedKeyIv(), ezKeyName, edek.getEncryptionKeyVersionName());
        }
        return encInfo;
    }

    @VisibleForTesting
    void sortDatanodes(String clientMachine, OmKeyInfo ... keyInfos) {
        if (keyInfos != null && clientMachine != null) {
            HashMap<HashSet<String>, List<DatanodeDetails>> sortedPipelines = new HashMap<HashSet<String>, List<DatanodeDetails>>();
            OmKeyInfo[] omKeyInfoArray = keyInfos;
            int n = keyInfos.length;
            int n2 = 0;
            while (n2 < n) {
                OmKeyInfo keyInfo = omKeyInfoArray[n2];
                OmKeyLocationInfoGroup key = keyInfo.getLatestVersionLocations();
                if (key == null) {
                    LOG.warn("No location for key {}", (Object)keyInfo);
                } else {
                    for (OmKeyLocationInfo k : key.getLocationList()) {
                        Pipeline pipeline = k.getPipeline();
                        List nodes = pipeline.getNodes();
                        List<String> uuidList = KeyManagerImpl.toNodeUuid(nodes);
                        HashSet<String> uuidSet = new HashSet<String>(uuidList);
                        List<DatanodeDetails> sortedNodes = (List<DatanodeDetails>)sortedPipelines.get(uuidSet);
                        if (sortedNodes == null) {
                            if (nodes.isEmpty()) {
                                LOG.warn("No datanodes in pipeline {}", (Object)pipeline.getId());
                                continue;
                            }
                            sortedNodes = this.sortDatanodes(clientMachine, nodes, keyInfo, uuidList);
                            if (sortedNodes != null) {
                                sortedPipelines.put(uuidSet, sortedNodes);
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("Found sorted datanodes for pipeline {} and client {} in cache", (Object)pipeline.getId(), (Object)clientMachine);
                        }
                        pipeline.setNodesInOrder((List)sortedNodes);
                    }
                }
                ++n2;
            }
        }
    }

    private List<DatanodeDetails> sortDatanodes(String clientMachine, List<DatanodeDetails> nodes, OmKeyInfo keyInfo, List<String> nodeList) {
        List sortedNodes = null;
        try {
            sortedNodes = this.scmClient.getBlockClient().sortDatanodes(nodeList, clientMachine);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sorted datanodes {} for client {}, result: {}", new Object[]{nodes, clientMachine, sortedNodes});
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to sort datanodes based on distance to client,  volume={}, bucket={}, key={}, client={}, datanodes={},  exception={}", new Object[]{keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName(), clientMachine, nodeList, e.getMessage()});
        }
        return sortedNodes;
    }

    private static List<String> toNodeUuid(Collection<DatanodeDetails> nodes) {
        ArrayList<String> nodeSet = new ArrayList<String>(nodes.size());
        for (DatanodeDetails node : nodes) {
            nodeSet.add(node.getUuidString());
        }
        return nodeSet;
    }

    private void slimLocationVersion(OmKeyInfo ... keyInfos) {
        if (keyInfos != null) {
            OmKeyInfo[] omKeyInfoArray = keyInfos;
            int n = keyInfos.length;
            int n2 = 0;
            while (n2 < n) {
                OmKeyInfo keyInfo = omKeyInfoArray[n2];
                OmKeyLocationInfoGroup key = keyInfo.getLatestVersionLocations();
                if (key == null) {
                    LOG.warn("No location version for key {}", (Object)keyInfo);
                } else {
                    int keyLocationVersionLength = keyInfo.getKeyLocationVersions().size();
                    if (keyLocationVersionLength > 1) {
                        keyInfo.setKeyLocationVersions(keyInfo.getKeyLocationVersions().subList(keyLocationVersionLength - 1, keyLocationVersionLength));
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public Table.KeyValue<String, OmKeyInfo> getPendingDeletionDir() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TableIterator deletedDirItr = this.metadataManager.getDeletedDirTable().iterator();){
            Table.KeyValue keyValue;
            if (deletedDirItr.hasNext() && (keyValue = (Table.KeyValue)deletedDirItr.next()) != null) {
                return keyValue;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    @Override
    public List<OmKeyInfo> getPendingDeletionSubDirs(long volumeId, long bucketId, OmKeyInfo parentInfo, long numEntries) throws IOException {
        String seekDirInDB = this.metadataManager.getOzonePathKey(volumeId, bucketId, parentInfo.getObjectID(), "");
        long countEntries = 0L;
        Table dirTable = this.metadataManager.getDirectoryTable();
        Throwable throwable = null;
        Object var13_10 = null;
        try (TableIterator iterator = dirTable.iterator();){
            return this.gatherSubDirsWithIterator(parentInfo, numEntries, seekDirInDB, countEntries, (TableIterator<String, ? extends Table.KeyValue<String, OmDirectoryInfo>>)iterator);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<OmKeyInfo> gatherSubDirsWithIterator(OmKeyInfo parentInfo, long numEntries, String seekDirInDB, long countEntries, TableIterator<String, ? extends Table.KeyValue<String, OmDirectoryInfo>> iterator) throws IOException {
        ArrayList<OmKeyInfo> directories = new ArrayList<OmKeyInfo>();
        iterator.seek((Object)seekDirInDB);
        while (iterator.hasNext() && numEntries - countEntries > 0L) {
            Table.KeyValue entry = (Table.KeyValue)iterator.next();
            OmDirectoryInfo dirInfo = (OmDirectoryInfo)entry.getValue();
            if (!OMFileRequest.isImmediateChild(dirInfo.getParentObjectID(), parentInfo.getObjectID())) break;
            String dirName = OMFileRequest.getAbsolutePath(parentInfo.getKeyName(), dirInfo.getName());
            OmKeyInfo omKeyInfo = OMFileRequest.getOmKeyInfo(parentInfo.getVolumeName(), parentInfo.getBucketName(), dirInfo, dirName);
            directories.add(omKeyInfo);
            ++countEntries;
        }
        return directories;
    }

    @Override
    public List<OmKeyInfo> getPendingDeletionSubFiles(long volumeId, long bucketId, OmKeyInfo parentInfo, long numEntries) throws IOException {
        ArrayList<OmKeyInfo> files = new ArrayList<OmKeyInfo>();
        String seekFileInDB = this.metadataManager.getOzonePathKey(volumeId, bucketId, parentInfo.getObjectID(), "");
        long countEntries = 0L;
        Table fileTable = this.metadataManager.getFileTable();
        Throwable throwable = null;
        Object var14_11 = null;
        try (TableIterator iterator = fileTable.iterator();){
            iterator.seek((Object)seekFileInDB);
            while (iterator.hasNext() && numEntries - countEntries > 0L) {
                Table.KeyValue entry = (Table.KeyValue)iterator.next();
                OmKeyInfo fileInfo = (OmKeyInfo)entry.getValue();
                if (!OMFileRequest.isImmediateChild(fileInfo.getParentObjectID(), parentInfo.getObjectID())) {
                    break;
                }
                fileInfo.setFileName(fileInfo.getKeyName());
                String fullKeyPath = OMFileRequest.getAbsolutePath(parentInfo.getKeyName(), fileInfo.getKeyName());
                fileInfo.setKeyName(fullKeyPath);
                files.add(fileInfo);
                ++countEntries;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return files;
    }

    public boolean isBucketFSOptimized(String volName, String buckName) throws IOException {
        String buckKey = this.metadataManager.getBucketKey(volName, buckName);
        OmBucketInfo buckInfo = (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)buckKey);
        if (buckInfo != null) {
            return buckInfo.getBucketLayout().isFileSystemOptimized();
        }
        return false;
    }

    @Override
    public OmKeyInfo getKeyInfo(OmKeyArgs args, ResolvedBucket bucket, String clientAddress) throws IOException {
        Preconditions.checkNotNull((Object)args);
        OmKeyInfo value = (OmKeyInfo)MetricUtil.captureLatencyNs((MutableRate)this.metrics.getGetKeyInfoReadKeyInfoLatencyNs(), () -> this.readKeyInfo(args, bucket.bucketLayout()));
        if (!args.isHeadOp()) {
            MetricUtil.captureLatencyNs((MutableRate)this.metrics.getGetKeyInfoGenerateBlockTokenLatencyNs(), () -> this.addBlockToken4Read(value));
            MetricUtil.captureLatencyNs((MutableRate)this.metrics.getGetKeyInfoRefreshLocationLatencyNs(), () -> this.refreshPipelineFromCache(value, args.isForceUpdateContainerCacheFromSCM()));
            if (args.getSortDatanodes()) {
                MetricUtil.captureLatencyNs((MutableRate)this.metrics.getGetKeyInfoSortDatanodesLatencyNs(), () -> this.sortDatanodes(clientAddress, value));
            }
        }
        return value;
    }

    private void refreshPipelineFromCache(Iterable<OmKeyInfo> keyInfos) throws IOException {
        HashSet<Long> containerIds = new HashSet<Long>();
        for (OmKeyInfo keyInfo : keyInfos) {
            this.extractContainerIDs(keyInfo).forEach(containerIds::add);
        }
        Map<Long, Pipeline> containerLocations = this.scmClient.getContainerLocations(containerIds, false);
        for (OmKeyInfo keyInfo : keyInfos) {
            this.setUpdatedContainerLocation(keyInfo, containerLocations);
        }
    }

    protected void refreshPipelineFromCache(OmKeyInfo keyInfo, boolean forceRefresh) throws IOException {
        Set<Long> containerIds = this.extractContainerIDs(keyInfo).collect(Collectors.toSet());
        this.metrics.setForceContainerCacheRefresh(forceRefresh);
        Map<Long, Pipeline> containerLocations = this.scmClient.getContainerLocations(containerIds, forceRefresh);
        this.setUpdatedContainerLocation(keyInfo, containerLocations);
    }

    private void setUpdatedContainerLocation(OmKeyInfo keyInfo, Map<Long, Pipeline> containerLocations) {
        for (OmKeyLocationInfoGroup key : keyInfo.getKeyLocationVersions()) {
            for (List omKeyLocationInfoList : key.getLocationLists()) {
                for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoList) {
                    Pipeline pipeline = containerLocations.get(omKeyLocationInfo.getContainerID());
                    if (pipeline == null || pipeline.equals((Object)omKeyLocationInfo.getPipeline())) continue;
                    omKeyLocationInfo.setPipeline(pipeline);
                }
            }
        }
    }

    @NotNull
    private Stream<Long> extractContainerIDs(OmKeyInfo keyInfo) {
        return keyInfo.getKeyLocationVersions().stream().flatMap(v -> v.getLocationList().stream()).map(BlockLocationInfo::getContainerID);
    }
}

