/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.recon.ReconConfig;
import org.apache.hadoop.hdds.utils.DBCheckpointServlet;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.RDBCheckpointUtils;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.lock.BootstrapStateHandler;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.snapshot.OmSnapshotUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ozone.rocksdiff.RocksDBCheckpointDiffer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDBCheckpointServlet
extends DBCheckpointServlet {
    private static final Logger LOG = LoggerFactory.getLogger(OMDBCheckpointServlet.class);
    private static final long serialVersionUID = 1L;
    private transient BootstrapStateHandler.Lock lock;
    private long maxTotalSstSize = 0L;
    private static final AtomicLong PAUSE_COUNTER = new AtomicLong(0L);

    public void init() throws ServletException {
        OzoneManager om = (OzoneManager)this.getServletContext().getAttribute("ozone.om");
        if (om == null) {
            LOG.error("Unable to initialize OMDBCheckpointServlet. OM is null");
            return;
        }
        OzoneConfiguration conf = this.getConf();
        LinkedHashSet<String> allowedUsers = new LinkedHashSet<String>(om.getOmAdminUsernames());
        Collection<String> allowedGroups = om.getOmAdminGroups();
        ReconConfig reconConfig = (ReconConfig)conf.getObject(ReconConfig.class);
        String reconPrincipal = reconConfig.getKerberosPrincipal();
        if (!reconPrincipal.isEmpty()) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)reconPrincipal);
            allowedUsers.add(ugi.getShortUserName());
        }
        this.initialize(om.getMetadataManager().getStore(), om.getMetrics().getDBCheckpointMetrics(), om.getAclsEnabled(), allowedUsers, allowedGroups, om.isSpnegoEnabled());
        this.lock = new Lock(om);
    }

    public void writeDbDataToStream(DBCheckpoint checkpoint, HttpServletRequest request, OutputStream destination, List<String> toExcludeList, List<String> excludedList, Path tmpdir) throws IOException, InterruptedException {
        Objects.requireNonNull(toExcludeList);
        Objects.requireNonNull(excludedList);
        HashMap<Path, Path> copyFiles = new HashMap<Path, Path>();
        HashMap<Path, Path> hardLinkFiles = new HashMap<Path, Path>();
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (TarArchiveOutputStream archiveOutputStream = new TarArchiveOutputStream(destination);){
                archiveOutputStream.setLongFileMode(3);
                archiveOutputStream.setBigNumberMode(2);
                RocksDBCheckpointDiffer differ = this.getDbStore().getRocksDBCheckpointDiffer();
                DirectoryData sstBackupDir = new DirectoryData(tmpdir, differ.getSSTBackupDir());
                DirectoryData compactionLogDir = new DirectoryData(tmpdir, differ.getCompactionLogDir());
                Map<Path, Path> sstFilesToExclude = OMDBCheckpointServlet.normalizeExcludeList(toExcludeList, checkpoint.getCheckpointLocation(), sstBackupDir);
                boolean completed = this.getFilesForArchive(checkpoint, copyFiles, hardLinkFiles, sstFilesToExclude, this.includeSnapshotData(request), excludedList, sstBackupDir, compactionLogDir);
                this.writeFilesToArchive(copyFiles, hardLinkFiles, (ArchiveOutputStream)archiveOutputStream, completed, checkpoint.getCheckpointLocation());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOG.error("got exception writing to archive " + e);
            throw e;
        }
    }

    @VisibleForTesting
    public static Map<Path, Path> normalizeExcludeList(List<String> toExcludeList, Path checkpointLocation, DirectoryData sstBackupDir) {
        HashMap<Path, Path> paths = new HashMap<Path, Path>();
        Path metaDirPath = OMDBCheckpointServlet.getMetaDirPath(checkpointLocation);
        for (String s : toExcludeList) {
            Path destPath = Paths.get(metaDirPath.toString(), s);
            if (destPath.toString().startsWith(sstBackupDir.getOriginalDir().toString())) {
                int truncateLength = sstBackupDir.getOriginalDir().toString().length() + 1;
                Path srcPath = Paths.get(sstBackupDir.getTmpDir().toString(), OmSnapshotUtils.truncateFileName(truncateLength, destPath));
                paths.put(srcPath, destPath);
                continue;
            }
            if (!s.startsWith("db.snapshots")) {
                Path fixedPath = Paths.get(checkpointLocation.toString(), s);
                paths.put(fixedPath, fixedPath);
                continue;
            }
            paths.put(destPath, destPath);
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBCheckpoint getCheckpoint(Path tmpdir, boolean flush) throws IOException {
        DBCheckpoint checkpoint;
        RocksDBCheckpointDiffer differ = this.getDbStore().getRocksDBCheckpointDiffer();
        DirectoryData sstBackupDir = new DirectoryData(tmpdir, differ.getSSTBackupDir());
        DirectoryData compactionLogDir = new DirectoryData(tmpdir, differ.getCompactionLogDir());
        long startTime = System.currentTimeMillis();
        long pauseCounter = PAUSE_COUNTER.incrementAndGet();
        try {
            LOG.info("Compaction pausing {} started.", (Object)pauseCounter);
            differ.incrementTarballRequestCount();
            FileUtils.copyDirectory((File)compactionLogDir.getOriginalDir(), (File)compactionLogDir.getTmpDir());
            OmSnapshotUtils.linkFiles(sstBackupDir.getOriginalDir(), sstBackupDir.getTmpDir());
            checkpoint = this.getDbStore().getCheckpoint(flush);
        }
        catch (Throwable throwable) {
            RocksDBCheckpointDiffer rocksDBCheckpointDiffer = this.getDbStore().getRocksDBCheckpointDiffer();
            synchronized (rocksDBCheckpointDiffer) {
                differ.decrementTarballRequestCount();
                differ.notifyAll();
                long elapsedTime = System.currentTimeMillis() - startTime;
                LOG.info("Compaction pausing {} ended. Elapsed ms: {}", (Object)pauseCounter, (Object)elapsedTime);
            }
            throw throwable;
        }
        RocksDBCheckpointDiffer rocksDBCheckpointDiffer = this.getDbStore().getRocksDBCheckpointDiffer();
        synchronized (rocksDBCheckpointDiffer) {
            differ.decrementTarballRequestCount();
            differ.notifyAll();
            long elapsedTime = System.currentTimeMillis() - startTime;
            LOG.info("Compaction pausing {} ended. Elapsed ms: {}", (Object)pauseCounter, (Object)elapsedTime);
        }
        return checkpoint;
    }

    private boolean getFilesForArchive(DBCheckpoint checkpoint, Map<Path, Path> copyFiles, Map<Path, Path> hardLinkFiles, Map<Path, Path> sstFilesToExclude, boolean includeSnapshotData, List<String> excluded, DirectoryData sstBackupDir, DirectoryData compactionLogDir) throws IOException {
        this.maxTotalSstSize = this.getConf().getLong("ozone.om.ratis.snapshot.max.total.sst.size", 100000000L);
        if (!includeSnapshotData) {
            this.maxTotalSstSize = Long.MAX_VALUE;
        }
        AtomicLong copySize = new AtomicLong(0L);
        Path dir = checkpoint.getCheckpointLocation();
        if (!this.processDir(dir, copyFiles, hardLinkFiles, sstFilesToExclude, new HashSet<Path>(), excluded, copySize, null)) {
            return false;
        }
        if (!includeSnapshotData) {
            return true;
        }
        Set<Path> snapshotPaths = this.waitForSnapshotDirs(checkpoint);
        Path snapshotDir = Paths.get(OMStorage.getOmDbDir((ConfigurationSource)this.getConf()).toString(), "db.snapshots");
        if (!this.processDir(snapshotDir, copyFiles, hardLinkFiles, sstFilesToExclude, snapshotPaths, excluded, copySize, null)) {
            return false;
        }
        if (!this.processDir(sstBackupDir.getTmpDir().toPath(), copyFiles, hardLinkFiles, sstFilesToExclude, new HashSet<Path>(), excluded, copySize, sstBackupDir.getOriginalDir().toPath())) {
            return false;
        }
        return this.processDir(compactionLogDir.getTmpDir().toPath(), copyFiles, hardLinkFiles, sstFilesToExclude, new HashSet<Path>(), excluded, copySize, compactionLogDir.getOriginalDir().toPath());
    }

    private Set<Path> waitForSnapshotDirs(DBCheckpoint checkpoint) throws IOException {
        OzoneConfiguration conf = this.getConf();
        HashSet<Path> snapshotPaths = new HashSet<Path>();
        OmMetadataManagerImpl checkpointMetadataManager = OmMetadataManagerImpl.createCheckpointMetadataManager(conf, checkpoint);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (TableIterator iterator = checkpointMetadataManager.getSnapshotInfoTable().iterator();){
                while (iterator.hasNext()) {
                    Table.KeyValue entry = (Table.KeyValue)iterator.next();
                    Path path = Paths.get(OmSnapshotManager.getSnapshotPath(conf, (SnapshotInfo)entry.getValue()), new String[0]);
                    this.waitForDirToExist(path);
                    snapshotPaths.add(path);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            checkpointMetadataManager.stop();
        }
        return snapshotPaths;
    }

    private void waitForDirToExist(Path dir) throws IOException {
        if (!RDBCheckpointUtils.waitForCheckpointDirectoryExist((File)dir.toFile())) {
            throw new IOException("snapshot dir doesn't exist: " + dir);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean processDir(Path dir, Map<Path, Path> copyFiles, Map<Path, Path> hardLinkFiles, Map<Path, Path> sstFilesToExclude, Set<Path> snapshotPaths, List<String> excluded, AtomicLong copySize, Path destDir) throws IOException {
        block18: {
            var9_9 = null;
            var10_11 = null;
            try {
                files = Files.list(dir);
                var13_14 = files.collect(Collectors.toList()).iterator();
lbl8:
                // 1 sources

                file = (Path)var13_14.next();
                f = file.toFile();
                if (!f.isDirectory()) ** break block19
                parent = f.getParent();
                if (parent != null && parent.contains("db.snapshots/checkpointState") && !snapshotPaths.contains(file)) {
                    OMDBCheckpointServlet.LOG.debug("Skipping unneeded file: " + file);
                }
                compactionLogDir = new File(this.getDbStore().getRocksDBCheckpointDiffer().getCompactionLogDir());
                if (f.equals(compactionLogDir)) {
                    OMDBCheckpointServlet.LOG.debug("Skipping compaction log dir");
                }
                sstBackupDir = new File(this.getDbStore().getRocksDBCheckpointDiffer().getSSTBackupDir());
                if (f.equals(sstBackupDir)) {
                    OMDBCheckpointServlet.LOG.debug("Skipping sst backup dir");
                }
                filename = file.getFileName();
                if (filename == null) {
                    throw new IOException("file has no filename:" + file);
                }
                destSubDir = null;
                if (destDir != null) {
                    destSubDir = Paths.get(destDir.toString(), new String[]{filename.toString()});
                }
                if (this.processDir(file, copyFiles, hardLinkFiles, sstFilesToExclude, snapshotPaths, excluded, copySize, destSubDir)) break block20;
                return false;
                {
                    block20: {
                        fileSize = OMDBCheckpointServlet.processFile(file, copyFiles, hardLinkFiles, sstFilesToExclude, excluded, destDir);
                        if (copySize.get() + fileSize > this.maxTotalSstSize) {
                        }
                        copySize.addAndGet(fileSize);
                    }
                }
                while (files != null) {
                    files.close();
                    break block18;
                }
                break block18;
                finally {
                    if (files == null) ** continue;
                    files.close();
                }
            }
            finally {
                if (var13_14.hasNext()) ** GOTO lbl8
            }
        }
        return true;
    }

    @VisibleForTesting
    public static long processFile(Path file, Map<Path, Path> copyFiles, Map<Path, Path> hardLinkFiles, Map<Path, Path> sstFilesToExclude, List<String> excluded, Path destDir) throws IOException {
        long fileSize = 0L;
        Path destFile = file;
        Path fileNamePath = file.getFileName();
        if (fileNamePath == null) {
            throw new IOException("file has no filename:" + file);
        }
        String fileName = fileNamePath.toString();
        if (destDir != null) {
            destFile = Paths.get(destDir.toString(), fileName);
        }
        if (sstFilesToExclude.containsKey(file)) {
            excluded.add(destFile.toString());
        } else if (fileName.endsWith(".sst")) {
            Path linkPath = OMDBCheckpointServlet.findLinkPath(sstFilesToExclude, file);
            if (linkPath != null) {
                hardLinkFiles.put(destFile, linkPath);
            } else {
                linkPath = OMDBCheckpointServlet.findLinkPath(copyFiles, file);
                if (linkPath != null) {
                    hardLinkFiles.put(destFile, linkPath);
                } else {
                    copyFiles.put(file, destFile);
                    fileSize = Files.size(file);
                }
            }
        } else {
            copyFiles.put(file, destFile);
        }
        return fileSize;
    }

    private static Path findLinkPath(Map<Path, Path> files, Path file) throws IOException {
        Path fileNamePath = file.getFileName();
        if (fileNamePath == null) {
            throw new IOException("file has no filename:" + file);
        }
        String fileName = fileNamePath.toString();
        for (Map.Entry<Path, Path> entry : files.entrySet()) {
            Path srcPath = entry.getKey();
            Path destPath = entry.getValue();
            if (!srcPath.toString().endsWith(fileName) || !srcPath.toFile().exists()) continue;
            if (OmSnapshotUtils.getINode(srcPath).equals(OmSnapshotUtils.getINode(file))) {
                return destPath;
            }
            LOG.info("Found non linked sst files with the same name: {}, {}", (Object)srcPath, (Object)file);
        }
        return null;
    }

    private boolean includeSnapshotData(HttpServletRequest request) {
        String includeParam = request.getParameter("includeSnapshotData");
        return Boolean.parseBoolean(includeParam);
    }

    private void writeFilesToArchive(Map<Path, Path> copyFiles, Map<Path, Path> hardLinkFiles, ArchiveOutputStream archiveOutputStream, boolean completed, Path checkpointLocation) throws IOException {
        Path metaDirPath = OMDBCheckpointServlet.getMetaDirPath(checkpointLocation);
        int truncateLength = metaDirPath.toString().length() + 1;
        Map<Path, Path> filteredCopyFiles = completed ? copyFiles : copyFiles.entrySet().stream().filter(e -> ((Path)e.getKey()).getFileName().toString().toLowerCase().endsWith(".sst")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Map.Entry<Path, Path> entry : filteredCopyFiles.entrySet()) {
            Path f;
            Path file = entry.getValue();
            if (!file.toString().startsWith(metaDirPath.toString())) {
                throw new IOException("tarball file not in metadata dir: " + file + ": " + metaDirPath);
            }
            String fixedFile = OmSnapshotUtils.truncateFileName(truncateLength, file);
            if (fixedFile.startsWith("db.checkpoints") && (f = Paths.get(fixedFile, new String[0]).getFileName()) != null) {
                fixedFile = f.toString();
            }
            HddsServerUtil.includeFile((File)entry.getKey().toFile(), (String)fixedFile, (ArchiveOutputStream)archiveOutputStream);
        }
        if (completed) {
            if (!hardLinkFiles.isEmpty()) {
                Path hardLinkFile = null;
                try {
                    hardLinkFile = OmSnapshotUtils.createHardLinkList(truncateLength, hardLinkFiles);
                    HddsServerUtil.includeFile((File)hardLinkFile.toFile(), (String)"hardLinkFile", (ArchiveOutputStream)archiveOutputStream);
                }
                finally {
                    if (Objects.nonNull(hardLinkFile)) {
                        try {
                            Files.delete(hardLinkFile);
                        }
                        catch (Exception e2) {
                            LOG.error("Exception during hard link file: {} deletion", (Object)hardLinkFile, (Object)e2);
                        }
                    }
                }
            }
            HddsServerUtil.includeRatisSnapshotCompleteFlag((ArchiveOutputStream)archiveOutputStream);
        }
    }

    @NotNull
    private static Path getMetaDirPath(Path checkpointLocation) {
        Path locationParent = checkpointLocation.getParent();
        if (locationParent == null) {
            throw new RuntimeException("checkpoint location's immediate parent is null.");
        }
        Path parent = locationParent.getParent();
        if (parent == null) {
            throw new RuntimeException("checkpoint location's path is invalid and could not be verified.");
        }
        return parent;
    }

    private OzoneConfiguration getConf() {
        return ((OzoneManager)this.getServletContext().getAttribute("ozone.om")).getConfiguration();
    }

    public BootstrapStateHandler.Lock getBootstrapStateLock() {
        return this.lock;
    }

    static class DirectoryData {
        private final File originalDir;
        private final File tmpDir;

        DirectoryData(Path tmpdir, String dirStr) throws IOException {
            this.originalDir = new File(dirStr);
            this.tmpDir = new File(tmpdir.toString(), this.getOriginalDir().getName());
            if (!this.tmpDir.exists() && !this.tmpDir.mkdirs()) {
                throw new IOException("mkdirs failed: " + this.tmpDir);
            }
        }

        public File getOriginalDir() {
            return this.originalDir;
        }

        public File getTmpDir() {
            return this.tmpDir;
        }
    }

    static class Lock
    extends BootstrapStateHandler.Lock {
        private final BootstrapStateHandler keyDeletingService;
        private final BootstrapStateHandler sstFilteringService;
        private final BootstrapStateHandler rocksDbCheckpointDiffer;
        private final BootstrapStateHandler snapshotDeletingService;
        private final OzoneManager om;

        Lock(OzoneManager om) {
            this.om = om;
            this.keyDeletingService = om.getKeyManager().getDeletingService();
            this.sstFilteringService = om.getKeyManager().getSnapshotSstFilteringService();
            this.rocksDbCheckpointDiffer = om.getMetadataManager().getStore().getRocksDBCheckpointDiffer();
            this.snapshotDeletingService = om.getKeyManager().getSnapshotDeletingService();
        }

        public BootstrapStateHandler.Lock lock() throws InterruptedException {
            this.keyDeletingService.getBootstrapStateLock().lock();
            this.sstFilteringService.getBootstrapStateLock().lock();
            this.rocksDbCheckpointDiffer.getBootstrapStateLock().lock();
            this.snapshotDeletingService.getBootstrapStateLock().lock();
            this.om.awaitDoubleBufferFlush();
            return this;
        }

        public void unlock() {
            this.snapshotDeletingService.getBootstrapStateLock().unlock();
            this.rocksDbCheckpointDiffer.getBootstrapStateLock().unlock();
            this.sstFilteringService.getBootstrapStateLock().unlock();
            this.keyDeletingService.getBootstrapStateLock().unlock();
        }
    }
}

