/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneConfigUtil {
    static final Logger LOG = LoggerFactory.getLogger(OzoneConfigUtil.class);

    private OzoneConfigUtil() {
    }

    static Collection<String> getS3AdminsFromConfig(OzoneConfiguration conf) throws IOException {
        String omSPN;
        Collection ozAdmins = conf.getTrimmedStringCollection("ozone.s3.administrators");
        if (ozAdmins == null || ozAdmins.isEmpty()) {
            ozAdmins = conf.getTrimmedStringCollection("ozone.administrators");
        }
        if (!ozAdmins.contains(omSPN = UserGroupInformation.getCurrentUser().getShortUserName())) {
            ozAdmins.add(omSPN);
        }
        return ozAdmins;
    }

    static Collection<String> getS3AdminsGroupsFromConfig(OzoneConfiguration conf) {
        Collection s3AdminsGroup = conf.getTrimmedStringCollection("ozone.s3.administrators.groups");
        if (s3AdminsGroup.isEmpty() && conf.getTrimmedStringCollection("ozone.s3.administrators").isEmpty()) {
            s3AdminsGroup = conf.getTrimmedStringCollection("ozone.administrators.groups");
        }
        return s3AdminsGroup;
    }

    public static ReplicationConfig resolveReplicationConfigPreference(HddsProtos.ReplicationType clientType, HddsProtos.ReplicationFactor clientFactor, HddsProtos.ECReplicationConfig clientECReplicationConfig, DefaultReplicationConfig bucketDefaultReplicationConfig, OzoneManager ozoneManager) throws OMException {
        ReplicationConfig replicationConfig = null;
        if (clientType != HddsProtos.ReplicationType.NONE) {
            replicationConfig = ReplicationConfig.fromProto((HddsProtos.ReplicationType)clientType, (HddsProtos.ReplicationFactor)clientFactor, (HddsProtos.ECReplicationConfig)clientECReplicationConfig);
            ozoneManager.validateReplicationConfig(replicationConfig);
        } else {
            replicationConfig = bucketDefaultReplicationConfig != null ? bucketDefaultReplicationConfig.getReplicationConfig() : ozoneManager.getDefaultReplicationConfig();
        }
        return replicationConfig;
    }

    public static long limitValue(long clientConfValue, String clientConfName, String serverConfName, long serverConfValue) {
        long limitVal = clientConfValue;
        if (clientConfValue > serverConfValue) {
            LOG.debug("{} config value is greater than server config {} value currently set at : {}, so limiting the config value to be used at server side to max value supported at server - {}", new Object[]{clientConfName, serverConfName, serverConfValue, serverConfValue});
            limitVal = serverConfValue;
        }
        if (limitVal <= 1L) {
            limitVal = 2L;
        }
        return limitVal;
    }
}

