/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.security.exception.OzoneSecurityException;
import org.apache.hadoop.ozone.om.S3Batcher;
import org.apache.hadoop.ozone.om.S3SecretCache;
import org.apache.hadoop.ozone.om.S3SecretFunction;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.S3SecretStore;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3SecretManagerImpl
implements S3SecretManager {
    private static final Logger LOG = LoggerFactory.getLogger(S3SecretManagerImpl.class);
    private final S3SecretStore s3SecretStore;
    private final S3SecretCache s3SecretCache;

    public S3SecretManagerImpl(S3SecretStore s3SecretStore, S3SecretCache s3SecretCache) {
        this.s3SecretStore = s3SecretStore;
        this.s3SecretCache = s3SecretCache;
    }

    public S3SecretValue getSecret(String kerberosID) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)kerberosID), (Object)"kerberosID cannot be null or empty.");
        S3SecretValue cacheValue = this.s3SecretCache.get(kerberosID);
        if (cacheValue != null) {
            if (cacheValue.isDeleted()) {
                return null;
            }
            return new S3SecretValue(cacheValue.getKerberosID(), cacheValue.getAwsSecret());
        }
        S3SecretValue result = this.s3SecretStore.getSecret(kerberosID);
        if (result != null) {
            this.updateCache(kerberosID, result);
        }
        return result;
    }

    public String getSecretString(String awsAccessKey) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)awsAccessKey), (Object)"awsAccessKeyId cannot be null or empty.");
        LOG.trace("Get secret for awsAccessKey:{}", (Object)awsAccessKey);
        S3SecretValue cacheValue = this.s3SecretCache.get(awsAccessKey);
        if (cacheValue != null) {
            return cacheValue.getAwsSecret();
        }
        S3SecretValue s3Secret = this.s3SecretStore.getSecret(awsAccessKey);
        if (s3Secret == null) {
            throw new OzoneSecurityException("S3 secret not found for awsAccessKeyId " + awsAccessKey, OzoneSecurityException.ResultCodes.S3_SECRET_NOT_FOUND);
        }
        this.updateCache(awsAccessKey, s3Secret);
        return s3Secret.getAwsSecret();
    }

    public void storeSecret(String kerberosId, S3SecretValue secretValue) throws IOException {
        this.s3SecretStore.storeSecret(kerberosId, secretValue);
        this.updateCache(kerberosId, secretValue);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Secret for accessKey:{} stored", (Object)kerberosId);
        }
    }

    public void revokeSecret(String kerberosId) throws IOException {
        this.s3SecretStore.revokeSecret(kerberosId);
        this.invalidateCacheEntry(kerberosId);
    }

    public void clearS3Cache(List<Long> flushedTransactionIds) {
        this.clearCache(flushedTransactionIds);
    }

    public <T> T doUnderLock(String lockId, S3SecretFunction<T> action) throws IOException {
        throw new UnsupportedOperationException("Lock on locked secret manager is not supported.");
    }

    public S3SecretCache cache() {
        return this.s3SecretCache;
    }

    public S3Batcher batcher() {
        return this.s3SecretStore.batcher();
    }

    public void updateCache(String kerberosID, S3SecretValue secret) {
        super.updateCache(kerberosID, secret);
    }
}

