/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.RocksDatabase;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.lock.BootstrapStateHandler;
import org.apache.hadoop.ozone.om.IOmMetadataReader;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.OMLockDetails;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCounted;
import org.apache.hadoop.ozone.om.snapshot.SnapshotCache;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SstFilteringService
extends BackgroundService
implements BootstrapStateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SstFilteringService.class);
    private static final int SST_FILTERING_CORE_POOL_SIZE = 1;
    private final OzoneManager ozoneManager;
    private final long snapshotLimitPerTask;
    private AtomicLong snapshotFilteredCount;
    private AtomicBoolean running;
    private final BootstrapStateHandler.Lock lock = new BootstrapStateHandler.Lock();

    public SstFilteringService(long interval, TimeUnit unit, long serviceTimeout, OzoneManager ozoneManager, OzoneConfiguration configuration) {
        super("SstFilteringService", interval, unit, 1, serviceTimeout, ozoneManager.getThreadNamePrefix());
        this.ozoneManager = ozoneManager;
        this.snapshotLimitPerTask = configuration.getLong("ozone.snapshot.filtering.limit.per.task", 2L);
        this.snapshotFilteredCount = new AtomicLong(0L);
        this.running = new AtomicBoolean(false);
    }

    public void start() {
        this.running.set(true);
        super.start();
    }

    @VisibleForTesting
    public void pause() {
        this.running.set(false);
    }

    @VisibleForTesting
    public void resume() {
        this.running.set(true);
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new SstFilteringTask());
        return queue;
    }

    public AtomicLong getSnapshotFilteredCount() {
        return this.snapshotFilteredCount;
    }

    public BootstrapStateHandler.Lock getBootstrapStateLock() {
        return this.lock;
    }

    public void shutdown() {
        this.running.set(false);
        super.shutdown();
    }

    private class SstFilteringTask
    implements BackgroundTask {
        private SstFilteringTask() {
        }

        private void markSSTFilteredFlagForSnapshot(String volume, String bucket, String snapshotName) throws IOException {
            OMLockDetails omLockDetails = SstFilteringService.this.ozoneManager.getMetadataManager().getLock().acquireWriteLock(OzoneManagerLock.Resource.SNAPSHOT_LOCK, new String[]{volume, bucket, snapshotName});
            boolean acquiredSnapshotLock = omLockDetails.isLockAcquired();
            if (acquiredSnapshotLock) {
                Table snapshotInfoTable = SstFilteringService.this.ozoneManager.getMetadataManager().getSnapshotInfoTable();
                try {
                    String snapshotTableKey = SnapshotInfo.getTableKey((String)volume, (String)bucket, (String)snapshotName);
                    SnapshotInfo snapshotInfo = (SnapshotInfo)snapshotInfoTable.get((Object)snapshotTableKey);
                    snapshotInfo.setSstFiltered(true);
                    snapshotInfoTable.put((Object)snapshotTableKey, (Object)snapshotInfo);
                }
                catch (Throwable throwable) {
                    SstFilteringService.this.ozoneManager.getMetadataManager().getLock().releaseWriteLock(OzoneManagerLock.Resource.SNAPSHOT_LOCK, new String[]{volume, bucket, snapshotName});
                    throw throwable;
                }
                SstFilteringService.this.ozoneManager.getMetadataManager().getLock().releaseWriteLock(OzoneManagerLock.Resource.SNAPSHOT_LOCK, new String[]{volume, bucket, snapshotName});
            }
        }

        public BackgroundTaskResult call() throws Exception {
            Optional<SnapshotCache> snapshotCache = Optional.ofNullable(SstFilteringService.this.ozoneManager).map(OzoneManager::getOmSnapshotManager).map(OmSnapshotManager::getSnapshotCache);
            if (!snapshotCache.isPresent()) {
                return BackgroundTaskResult.EmptyTaskResult.newResult();
            }
            Table snapshotInfoTable = SstFilteringService.this.ozoneManager.getMetadataManager().getSnapshotInfoTable();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (TableIterator iterator = snapshotInfoTable.iterator();){
                    iterator.seekToFirst();
                    long snapshotLimit = SstFilteringService.this.snapshotLimitPerTask;
                    while (iterator.hasNext() && snapshotLimit > 0L && SstFilteringService.this.running.get()) {
                        try {
                            SnapshotInfo snapshotInfo;
                            block35: {
                                Table.KeyValue keyValue = (Table.KeyValue)iterator.next();
                                String snapShotTableKey = (String)keyValue.getKey();
                                snapshotInfo = (SnapshotInfo)keyValue.getValue();
                                if (snapshotInfo.isSstFiltered()) continue;
                                LOG.debug("Processing snapshot {} to filter relevant SST Files", (Object)snapShotTableKey);
                                Map<String, String> columnFamilyNameToPrefixMap = SnapshotUtils.getColumnFamilyToKeyPrefixMap(SstFilteringService.this.ozoneManager.getMetadataManager(), snapshotInfo.getVolumeName(), snapshotInfo.getBucketName());
                                try {
                                    Throwable throwable2 = null;
                                    Object var13_18 = null;
                                    try (ReferenceCounted<IOmMetadataReader, SnapshotCache> snapshotMetadataReader = snapshotCache.get().get(snapshotInfo.getTableKey());){
                                        OmSnapshot omSnapshot = (OmSnapshot)snapshotMetadataReader.get();
                                        RDBStore rdbStore = (RDBStore)omSnapshot.getMetadataManager().getStore();
                                        RocksDatabase db = rdbStore.getDb();
                                        Throwable throwable3 = null;
                                        Object var19_26 = null;
                                        try (BootstrapStateHandler.Lock lock = SstFilteringService.this.getBootstrapStateLock().lock();){
                                            db.deleteFilesNotMatchingPrefix(columnFamilyNameToPrefixMap);
                                        }
                                        catch (Throwable throwable4) {
                                            if (throwable3 == null) {
                                                throwable3 = throwable4;
                                            } else if (throwable3 != throwable4) {
                                                throwable3.addSuppressed(throwable4);
                                            }
                                            throw throwable3;
                                        }
                                    }
                                    catch (Throwable throwable5) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable5;
                                        } else if (throwable2 != throwable5) {
                                            throwable2.addSuppressed(throwable5);
                                        }
                                        throw throwable2;
                                    }
                                }
                                catch (OMException ome) {
                                    SnapshotInfo snapshotInfoToCheck;
                                    if (ome.getResult() != OMException.ResultCodes.FILE_NOT_FOUND || (snapshotInfoToCheck = (SnapshotInfo)SstFilteringService.this.ozoneManager.getMetadataManager().getSnapshotInfoTable().get((Object)snapShotTableKey)).getSnapshotStatus() != SnapshotInfo.SnapshotStatus.SNAPSHOT_DELETED) break block35;
                                    LOG.info("Snapshot with name: '{}', id: '{}' has been deleted.", (Object)snapshotInfo.getName(), (Object)snapshotInfo.getSnapshotId());
                                }
                            }
                            this.markSSTFilteredFlagForSnapshot(snapshotInfo.getVolumeName(), snapshotInfo.getBucketName(), snapshotInfo.getName());
                            --snapshotLimit;
                            SstFilteringService.this.snapshotFilteredCount.getAndIncrement();
                        }
                        catch (IOException | RocksDBException e) {
                            LOG.error("Exception encountered while filtering a snapshot", e);
                        }
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOG.error("Error during Snapshot sst filtering ", (Throwable)e);
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

