/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TrashPolicyDefault;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OFSPath;
import org.apache.hadoop.ozone.conf.OMClientConfig;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrashPolicyOzone
extends TrashPolicyDefault {
    private static final Logger LOG = LoggerFactory.getLogger(TrashPolicyOzone.class);
    private static final Path CURRENT = new Path("Current");
    private static final FsPermission PERMISSION = new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE);
    private static final DateFormat CHECKPOINT = new SimpleDateFormat("yyMMddHHmmss");
    private static final DateFormat OLD_CHECKPOINT = new SimpleDateFormat("yyMMddHHmm");
    private static final int MSECS_PER_MINUTE = 60000;
    private long emptierInterval;
    private Configuration configuration;
    private OzoneManager om;
    private OzoneConfiguration ozoneConfiguration;

    public TrashPolicyOzone() {
    }

    public void initialize(Configuration conf, FileSystem fs) {
        this.fs = fs;
        this.configuration = conf;
        float hadoopTrashInterval = conf.getFloat("fs.trash.interval", 0.0f);
        this.deletionInterval = (long)(conf.getFloat("ozone.fs.trash.interval", hadoopTrashInterval) * 60000.0f);
        float hadoopCheckpointInterval = conf.getFloat("fs.trash.checkpoint.interval", 0.0f);
        this.emptierInterval = (long)(conf.getFloat("ozone.fs.trash.checkpoint.interval", hadoopCheckpointInterval) * 60000.0f);
        if (this.deletionInterval < 0L) {
            LOG.warn("Invalid value {} for deletion interval, deletion interaval can not be negative.Changing to default value 0", (Object)this.deletionInterval);
            this.deletionInterval = 0L;
        }
        this.ozoneConfiguration = OzoneConfiguration.of((Configuration)this.configuration);
    }

    TrashPolicyOzone(FileSystem fs, Configuration conf, OzoneManager om) {
        this.initialize(conf, fs);
        this.om = om;
    }

    public Runnable getEmptier() throws IOException {
        return new Emptier((OzoneConfiguration)this.configuration, this.emptierInterval, this.om.getThreadNamePrefix());
    }

    /*
     * Unable to fully structure code
     */
    public boolean moveToTrash(Path path) throws IOException {
        block16: {
            if (!this.validatePath(path)) break block16;
            if (!this.isEnabled()) {
                return false;
            }
            if (!path.isAbsolute()) {
                path = new Path(this.fs.getWorkingDirectory(), path);
            }
            this.fs.getFileStatus(path);
            qpath = this.fs.makeQualified(path).toString();
            trashRoot = this.fs.getTrashRoot(path);
            trashCurrent = new Path(trashRoot, TrashPolicyOzone.CURRENT);
            if (qpath.startsWith(trashRoot.toString())) {
                return false;
            }
            if (trashRoot.getParent().toString().startsWith(qpath)) {
                throw new IOException("Cannot move \"" + path + "\" to the trash, as it contains the trash");
            }
            if (this.fs.getUri().getScheme().equals("ofs")) {
                ofsPath = new OFSPath(path, this.ozoneConfiguration);
                trimmedVolumeAndBucket = new Path("/" + ofsPath.getKeyName());
                trashPath = this.makeTrashRelativePath(trashCurrent, trimmedVolumeAndBucket);
                baseTrashPath = this.makeTrashRelativePath(trashCurrent, trimmedVolumeAndBucket.getParent());
            } else {
                trashPath = this.makeTrashRelativePath(trashCurrent, path);
                baseTrashPath = this.makeTrashRelativePath(trashCurrent, path.getParent());
            }
            cause = null;
            i = 0;
            while (i < 2) {
                block17: {
                    try {
                        if (!this.fs.mkdirs(baseTrashPath, TrashPolicyOzone.PERMISSION)) {
                            TrashPolicyOzone.LOG.warn("Can't create(mkdir) trash directory: " + baseTrashPath);
                            return false;
                        }
                    }
                    catch (FileAlreadyExistsException v0) {
                        existsFilePath = baseTrashPath;
                        ** while (!this.fs.exists((Path)existsFilePath))
                    }
lbl-1000:
                    // 1 sources

                    {
                        existsFilePath = existsFilePath.getParent();
                        continue;
                    }
lbl36:
                    // 1 sources

                    baseTrashPath = new Path(baseTrashPath.toString().replace(existsFilePath.toString(), String.valueOf(existsFilePath.toString()) + Time.now()));
                    trashPath = new Path(baseTrashPath, trashPath.getName());
                    --i;
                    break block17;
                    catch (IOException e) {
                        TrashPolicyOzone.LOG.warn("Can't create trash directory: " + baseTrashPath, (Throwable)e);
                        cause = e;
                        break;
                    }
                    try {
                        orig = trashPath.toString();
                        while (this.fs.exists(trashPath)) {
                            trashPath = new Path(String.valueOf(orig) + Time.now());
                        }
                        renamed = this.fs.rename(path, trashPath);
                        if (!renamed) {
                            TrashPolicyOzone.LOG.error("Failed to move to trash: {}", (Object)path);
                            throw new IOException("Failed to move to trash: " + path);
                        }
                        TrashPolicyOzone.LOG.info("Moved: '" + path + "' to trash at: " + trashPath);
                        return true;
                    }
                    catch (IOException e) {
                        cause = e;
                    }
                }
                ++i;
            }
            throw (IOException)new IOException("Failed to move to trash: " + path).initCause(cause);
        }
        return false;
    }

    private boolean validatePath(Path path) throws IOException {
        String key = path.toUri().getPath();
        OFSPath ofsPath = new OFSPath(key.substring(1), this.ozoneConfiguration);
        if (path.isRoot() || ofsPath.isBucket()) {
            throw new IOException("Recursive rm of bucket " + path.toString() + " not permitted");
        }
        Path trashRoot = this.fs.getTrashRoot(path);
        LOG.debug("Key path to moveToTrash: {}", (Object)key);
        String trashRootKey = trashRoot.toUri().getPath();
        LOG.debug("TrashrootKey for moveToTrash: {}", (Object)trashRootKey);
        if (!OzoneFSUtils.isValidName((String)key)) {
            throw new InvalidPathException("Invalid path Name " + key);
        }
        return (!key.contains(".Trash") || !trashRootKey.startsWith(key)) && !key.startsWith(trashRootKey);
    }

    private Path makeTrashRelativePath(Path basePath, Path rmFilePath) {
        return Path.mergePaths((Path)basePath, (Path)rmFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCheckpoint(Path trashRoot, Date date) throws IOException {
        Path checkpointBase;
        if (!this.fs.exists(new Path(trashRoot, CURRENT))) {
            return;
        }
        DateFormat dateFormat = CHECKPOINT;
        synchronized (dateFormat) {
            checkpointBase = new Path(trashRoot, CHECKPOINT.format(date));
        }
        Path checkpoint = checkpointBase;
        Path current = new Path(trashRoot, CURRENT);
        int attempt = 0;
        while (true) {
            try {
                this.fs.rename(current, checkpoint);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Created trash checkpoint: {}", (Object)checkpoint.toUri().getPath());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                if (++attempt > 1000) {
                    this.om.getMetrics().incNumTrashFails();
                    throw new IOException("Failed to checkpoint trash: " + checkpoint);
                }
                checkpoint = checkpointBase.suffix("-" + attempt);
                continue;
            }
            break;
        }
    }

    private void deleteCheckpoint(Path trashRoot, boolean deleteImmediately) throws IOException {
        LOG.debug("TrashPolicyOzone#deleteCheckpoint for trashRoot: {}", (Object)trashRoot);
        FileStatus[] dirs = null;
        try {
            dirs = this.fs.listStatus(trashRoot);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        long now = Time.now();
        int i = 0;
        while (i < dirs.length) {
            block9: {
                Path path = dirs[i].getPath();
                String dir = path.toUri().getPath();
                String name = path.getName();
                if (!name.equals(CURRENT.getName())) {
                    long time;
                    try {
                        time = this.getTimeFromCheckpoint(name);
                    }
                    catch (ParseException parseException) {
                        this.om.getMetrics().incNumTrashFails();
                        LOG.warn("Unexpected item in trash: {} . Ignoring.", (Object)dir);
                        break block9;
                    }
                    if (now - this.deletionInterval > time || deleteImmediately) {
                        if (this.fs.delete(path, true)) {
                            LOG.debug("Deleted trash checkpoint:{} ", (Object)dir);
                        } else {
                            this.om.getMetrics().incNumTrashFails();
                            LOG.warn("Couldn't delete checkpoint: {} Ignoring.", (Object)dir);
                        }
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTimeFromCheckpoint(String name) throws ParseException {
        long time;
        try {
            DateFormat dateFormat = CHECKPOINT;
            synchronized (dateFormat) {
                time = CHECKPOINT.parse(name).getTime();
            }
        }
        catch (ParseException parseException) {
            DateFormat dateFormat = OLD_CHECKPOINT;
            synchronized (dateFormat) {
                time = OLD_CHECKPOINT.parse(name).getTime();
            }
        }
        return time;
    }

    protected class Emptier
    implements Runnable {
        private Configuration conf;
        private long emptierInterval;
        private ThreadPoolExecutor executor;

        Emptier(OzoneConfiguration conf, long emptierInterval, String threadNamePrefix) throws IOException {
            this.conf = conf;
            this.emptierInterval = emptierInterval;
            if (emptierInterval > TrashPolicyOzone.this.deletionInterval || emptierInterval <= 0L) {
                LOG.info("The configured checkpoint interval is " + emptierInterval / 60000L + " minutes." + " Using an interval of " + TrashPolicyOzone.this.deletionInterval / 60000L + " minutes that is used for deletion instead");
                this.emptierInterval = TrashPolicyOzone.this.deletionInterval;
            }
            int trashEmptierCorePoolSize = ((OMClientConfig)conf.getObject(OMClientConfig.class)).getTrashEmptierPoolSize();
            LOG.info("Ozone Manager trash configuration: Deletion interval = " + TrashPolicyOzone.this.deletionInterval / 60000L + " minutes, Emptier interval = " + this.emptierInterval / 60000L + " minutes.");
            this.executor = new ThreadPoolExecutor(trashEmptierCorePoolSize, trashEmptierCorePoolSize, 1L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1024), new ThreadFactoryBuilder().setNameFormat(String.valueOf(threadNamePrefix) + "TrashEmptier-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());
        }

        @Override
        public void run() {
            if (this.emptierInterval == 0L) {
                return;
            }
            block15: while (true) {
                long now = Time.now();
                long end = this.ceiling(now, this.emptierInterval);
                try {
                    Thread.sleep(end - now);
                    if (!TrashPolicyOzone.this.om.isLeaderReady()) {
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
                try {
                    TrashPolicyOzone.this.om.getMetrics().incNumTrashActiveCycles();
                    now = Time.now();
                    if (now < end) continue;
                    Collection trashRoots = TrashPolicyOzone.this.fs.getTrashRoots(true);
                    LOG.debug("Trash root Size: {}", (Object)trashRoots.size());
                    Iterator iterator = trashRoots.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block15;
                        FileStatus trashRoot = (FileStatus)iterator.next();
                        LOG.debug("Trashroot: {}", (Object)trashRoot.getPath());
                        if (!trashRoot.isDirectory()) continue;
                        TrashPolicyOzone trash = new TrashPolicyOzone(TrashPolicyOzone.this.fs, this.conf, TrashPolicyOzone.this.om);
                        Path trashRootPath = trashRoot.getPath();
                        Runnable task = this.getEmptierTask(trashRootPath, trash, false);
                        TrashPolicyOzone.this.om.getMetrics().incNumTrashRootsEnqueued();
                        this.executor.submit(task);
                    }
                }
                catch (Exception e) {
                    TrashPolicyOzone.this.om.getMetrics().incNumTrashFails();
                    LOG.warn("RuntimeException during Trash.Emptier.run(): ", (Throwable)e);
                }
            }
            try {
                try {
                    TrashPolicyOzone.this.fs.close();
                }
                catch (IOException e) {
                    LOG.warn("Trash cannot close FileSystem: ", (Throwable)e);
                    this.executor.shutdown();
                    try {
                        this.executor.awaitTermination(60L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e2) {
                        LOG.error("Error attempting to shutdown", (Throwable)e2);
                        Thread.currentThread().interrupt();
                    }
                }
            }
            finally {
                this.executor.shutdown();
                try {
                    this.executor.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOG.error("Error attempting to shutdown", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }

        private Runnable getEmptierTask(Path trashRootPath, TrashPolicyOzone trash, boolean deleteImmediately) {
            Runnable task = () -> {
                try {
                    TrashPolicyOzone.this.om.getMetrics().incNumTrashRootsProcessed();
                    trash.deleteCheckpoint(trashRootPath, deleteImmediately);
                    trash.createCheckpoint(trashRootPath, new Date(Time.now()));
                }
                catch (Exception e) {
                    TrashPolicyOzone.this.om.getMetrics().incNumTrashFails();
                    LOG.error("Unable to checkpoint:" + trashRootPath, (Throwable)e);
                }
            };
            return task;
        }

        private long ceiling(long time, long interval) {
            return this.floor(time, interval) + interval;
        }

        private long floor(long time, long interval) {
            return time / interval * interval;
        }
    }
}

